/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adsdisplayapi.v6.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import jp.co.yahoo.adsdisplayapi.v6.model.AccountServiceAuthType;
import jp.co.yahoo.adsdisplayapi.v6.model.AccountServiceIncludeManagerAccount;
import jp.co.yahoo.adsdisplayapi.v6.model.AccountServiceIncludeTestAccount;
import jp.co.yahoo.adsdisplayapi.v6.model.AccountServiceStatus;
import jp.co.yahoo.adsdisplayapi.v6.model.AccountServiceType;

@ApiModel(description="<div lang=\"ja\">AccountServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u53d6\u5f97\u3059\u308b\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002</div> <div lang=\"en\">The AccountServiceSelector object is used to select accounts for acquisition.</div> ")
public class AccountServiceSelector {
    @JsonProperty(value="accountIds")
    @Valid
    private List<Long> accountIds = null;
    @JsonProperty(value="accountName")
    private String accountName = null;
    @JsonProperty(value="accountStatuses")
    @Valid
    private List<AccountServiceStatus> accountStatuses = null;
    @JsonProperty(value="accountTypes")
    @Valid
    private List<AccountServiceType> accountTypes = null;
    @JsonProperty(value="authType")
    private AccountServiceAuthType authType = null;
    @JsonProperty(value="includeTestAccount")
    private AccountServiceIncludeTestAccount includeTestAccount = null;
    @JsonProperty(value="includeManagerAccount")
    private AccountServiceIncludeManagerAccount includeManagerAccount = null;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;

    public AccountServiceSelector accountIds(List<Long> accountIds) {
        this.accountIds = accountIds;
        return this;
    }

    public AccountServiceSelector addAccountIdsItem(Long accountIdsItem) {
        if (this.accountIds == null) {
            this.accountIds = new ArrayList<Long>();
        }
        this.accountIds.add(accountIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u6307\u5b9a\u3057\u306a\u3044\u5834\u5408\u306f\u7d10\u3065\u304f\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u3059\u3079\u3066\u53d6\u5f97\u3057\u307e\u3059\u3002</div> <div lang=\"en\">If nothing is selected, all accounts are retrieved.</div> ")
    @Size(max=500)
    public @Size(max=500) List<Long> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(List<Long> accountIds) {
        this.accountIds = accountIds;
    }

    public AccountServiceSelector accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30a2\u30ab\u30a6\u30f3\u30c8\u540d\u3067\u3059\u3002</div> <div lang=\"en\">Account name.</div> ")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public AccountServiceSelector accountStatuses(List<AccountServiceStatus> accountStatuses) {
        this.accountStatuses = accountStatuses;
        return this;
    }

    public AccountServiceSelector addAccountStatusesItem(AccountServiceStatus accountStatusesItem) {
        if (this.accountStatuses == null) {
            this.accountStatuses = new ArrayList<AccountServiceStatus>();
        }
        this.accountStatuses.add(accountStatusesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=6)
    public @Valid @Size(max=6) List<AccountServiceStatus> getAccountStatuses() {
        return this.accountStatuses;
    }

    public void setAccountStatuses(List<AccountServiceStatus> accountStatuses) {
        this.accountStatuses = accountStatuses;
    }

    public AccountServiceSelector accountTypes(List<AccountServiceType> accountTypes) {
        this.accountTypes = accountTypes;
        return this;
    }

    public AccountServiceSelector addAccountTypesItem(AccountServiceType accountTypesItem) {
        if (this.accountTypes == null) {
            this.accountTypes = new ArrayList<AccountServiceType>();
        }
        this.accountTypes.add(accountTypesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=2)
    public @Valid @Size(max=2) List<AccountServiceType> getAccountTypes() {
        return this.accountTypes;
    }

    public void setAccountTypes(List<AccountServiceType> accountTypes) {
        this.accountTypes = accountTypes;
    }

    public AccountServiceSelector authType(AccountServiceAuthType authType) {
        this.authType = authType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public AccountServiceAuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AccountServiceAuthType authType) {
        this.authType = authType;
    }

    public AccountServiceSelector includeTestAccount(AccountServiceIncludeTestAccount includeTestAccount) {
        this.includeTestAccount = includeTestAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public AccountServiceIncludeTestAccount getIncludeTestAccount() {
        return this.includeTestAccount;
    }

    public void setIncludeTestAccount(AccountServiceIncludeTestAccount includeTestAccount) {
        this.includeTestAccount = includeTestAccount;
    }

    public AccountServiceSelector includeManagerAccount(AccountServiceIncludeManagerAccount includeManagerAccount) {
        this.includeManagerAccount = includeManagerAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public AccountServiceIncludeManagerAccount getIncludeManagerAccount() {
        return this.includeManagerAccount;
    }

    public void setIncludeManagerAccount(AccountServiceIncludeManagerAccount includeManagerAccount) {
        this.includeManagerAccount = includeManagerAccount;
    }

    public AccountServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=500L)
    public @Min(value=1L) @Max(value=500L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public AccountServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountServiceSelector accountServiceSelector = (AccountServiceSelector)o;
        return Objects.equals(this.accountIds, accountServiceSelector.accountIds) && Objects.equals(this.accountName, accountServiceSelector.accountName) && Objects.equals(this.accountStatuses, accountServiceSelector.accountStatuses) && Objects.equals(this.accountTypes, accountServiceSelector.accountTypes) && Objects.equals((Object)this.authType, (Object)accountServiceSelector.authType) && Objects.equals((Object)this.includeTestAccount, (Object)accountServiceSelector.includeTestAccount) && Objects.equals((Object)this.includeManagerAccount, (Object)accountServiceSelector.includeManagerAccount) && Objects.equals(this.numberResults, accountServiceSelector.numberResults) && Objects.equals(this.startIndex, accountServiceSelector.startIndex);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountIds, this.accountName, this.accountStatuses, this.accountTypes, this.authType, this.includeTestAccount, this.includeManagerAccount, this.numberResults, this.startIndex});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountServiceSelector {\n");
        sb.append("    accountIds: ").append(this.toIndentedString(this.accountIds)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountStatuses: ").append(this.toIndentedString(this.accountStatuses)).append("\n");
        sb.append("    accountTypes: ").append(this.toIndentedString(this.accountTypes)).append("\n");
        sb.append("    authType: ").append(this.toIndentedString((Object)this.authType)).append("\n");
        sb.append("    includeTestAccount: ").append(this.toIndentedString((Object)this.includeTestAccount)).append("\n");
        sb.append("    includeManagerAccount: ").append(this.toIndentedString((Object)this.includeManagerAccount)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

