/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;
import android.util.Log;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL10;

public class PixelBuffer {
    static final String TAG = "PixelBuffer";
    static final boolean LIST_CONFIGS = false;
    GLSurfaceView.Renderer mRenderer;
    int mWidth;
    int mHeight;
    Bitmap mBitmap;
    EGL10 mEGL;
    EGLDisplay mEGLDisplay;
    EGLConfig[] mEGLConfigs;
    EGLConfig mEGLConfig;
    EGLContext mEGLContext;
    EGLSurface mEGLSurface;
    GL10 mGL;
    String mThreadOwner;

    public PixelBuffer(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        int[] version = new int[2];
        int[] attribList = new int[]{12375, this.mWidth, 12374, this.mHeight, 12344};
        this.mEGL = (EGL10)EGLContext.getEGL();
        this.mEGLDisplay = this.mEGL.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        this.mEGL.eglInitialize(this.mEGLDisplay, version);
        this.mEGLConfig = this.chooseConfig();
        int EGL_CONTEXT_CLIENT_VERSION = 12440;
        int[] attrib_list = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
        this.mEGLContext = this.mEGL.eglCreateContext(this.mEGLDisplay, this.mEGLConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
        this.mEGLSurface = this.mEGL.eglCreatePbufferSurface(this.mEGLDisplay, this.mEGLConfig, attribList);
        this.mEGL.eglMakeCurrent(this.mEGLDisplay, this.mEGLSurface, this.mEGLSurface, this.mEGLContext);
        this.mGL = (GL10)this.mEGLContext.getGL();
        this.mThreadOwner = Thread.currentThread().getName();
    }

    public void setRenderer(GLSurfaceView.Renderer renderer) {
        this.mRenderer = renderer;
        if (!Thread.currentThread().getName().equals(this.mThreadOwner)) {
            Log.e((String)TAG, (String)"setRenderer: This thread does not own the OpenGL context.");
            return;
        }
        this.mRenderer.onSurfaceCreated(this.mGL, this.mEGLConfig);
        this.mRenderer.onSurfaceChanged(this.mGL, this.mWidth, this.mHeight);
    }

    public Bitmap getBitmap() {
        if (this.mRenderer == null) {
            Log.e((String)TAG, (String)"getBitmap: Renderer was not set.");
            return null;
        }
        if (!Thread.currentThread().getName().equals(this.mThreadOwner)) {
            Log.e((String)TAG, (String)"getBitmap: This thread does not own the OpenGL context.");
            return null;
        }
        this.mRenderer.onDrawFrame(this.mGL);
        this.mRenderer.onDrawFrame(this.mGL);
        this.convertToBitmap();
        return this.mBitmap;
    }

    public void destroy() {
        this.mRenderer.onDrawFrame(this.mGL);
        this.mRenderer.onDrawFrame(this.mGL);
        this.mEGL.eglMakeCurrent(this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        this.mEGL.eglDestroySurface(this.mEGLDisplay, this.mEGLSurface);
        this.mEGL.eglDestroyContext(this.mEGLDisplay, this.mEGLContext);
        this.mEGL.eglTerminate(this.mEGLDisplay);
    }

    private EGLConfig chooseConfig() {
        int[] attribList = new int[]{12325, 0, 12326, 0, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344};
        int[] numConfig = new int[1];
        this.mEGL.eglChooseConfig(this.mEGLDisplay, attribList, null, 0, numConfig);
        int configSize = numConfig[0];
        this.mEGLConfigs = new EGLConfig[configSize];
        this.mEGL.eglChooseConfig(this.mEGLDisplay, attribList, this.mEGLConfigs, configSize, numConfig);
        return this.mEGLConfigs[0];
    }

    private void listConfig() {
        Log.i((String)TAG, (String)"Config List {");
        for (EGLConfig config : this.mEGLConfigs) {
            int d = this.getConfigAttrib(config, 12325);
            int s = this.getConfigAttrib(config, 12326);
            int r = this.getConfigAttrib(config, 12324);
            int g = this.getConfigAttrib(config, 12323);
            int b = this.getConfigAttrib(config, 12322);
            int a = this.getConfigAttrib(config, 12321);
            Log.i((String)TAG, (String)("    <d,s,r,g,b,a> = <" + d + "," + s + "," + r + "," + g + "," + b + "," + a + ">"));
        }
        Log.i((String)TAG, (String)"}");
    }

    private int getConfigAttrib(EGLConfig config, int attribute) {
        int[] value = new int[1];
        return this.mEGL.eglGetConfigAttrib(this.mEGLDisplay, config, attribute, value) ? value[0] : 0;
    }

    private void convertToBitmap() {
        int[] iat = new int[this.mWidth * this.mHeight];
        IntBuffer ib = IntBuffer.allocate(this.mWidth * this.mHeight);
        this.mGL.glReadPixels(0, 0, this.mWidth, this.mHeight, 6408, 5121, (Buffer)ib);
        int[] ia = ib.array();
        for (int i = 0; i < this.mHeight; ++i) {
            for (int j = 0; j < this.mWidth; ++j) {
                iat[(this.mHeight - i - 1) * this.mWidth + j] = ia[i * this.mWidth + j];
            }
        }
        this.mBitmap = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mBitmap.copyPixelsFromBuffer((Buffer)IntBuffer.wrap(iat));
    }
}

