/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import groovy.lang.Closure;
import jp.classmethod.aws.gradle.s3.AmazonS3PluginExtension;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class BulkUploadTask
extends ConventionTask {
    private String bucketName;
    private String prefix;
    private FileTree source;
    private Closure<ObjectMetadata> metadataProvider;

    @TaskAction
    public void upload() {
        final String bucketName = this.getBucketName();
        final String prefix = this.getNormalizedPrefix();
        FileTree source = this.getSource();
        AmazonS3PluginExtension ext = (AmazonS3PluginExtension)this.getProject().getExtensions().getByType(AmazonS3PluginExtension.class);
        final AmazonS3 s3 = (AmazonS3)ext.getClient();
        this.getLogger().info("uploading... {} to s3://{}/{}", new Object[]{source, bucketName, prefix});
        source.visit((FileVisitor)new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails element) {
                String key = prefix + element.getRelativePath();
                BulkUploadTask.this.getLogger().info(" => s3://{}/{}", (Object)bucketName, (Object)key);
                Closure<ObjectMetadata> metadataProvider = BulkUploadTask.this.getMetadataProvider();
                s3.putObject(new PutObjectRequest(bucketName, key, element.getFile()).withMetadata(metadataProvider == null ? null : (ObjectMetadata)metadataProvider.call(new Object[]{BulkUploadTask.this.getBucketName(), key, element.getFile()})));
            }
        });
    }

    private String getNormalizedPrefix() {
        String prefix = this.getPrefix();
        if (prefix.startsWith("/")) {
            prefix = prefix.substring(1);
        }
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public FileTree getSource() {
        return this.source;
    }

    public void setSource(FileTree source) {
        this.source = source;
    }

    public Closure<ObjectMetadata> getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(Closure<ObjectMetadata> metadataProvider) {
        this.metadataProvider = metadataProvider;
    }
}

