/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.route53;

import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.model.Change;
import com.amazonaws.services.route53.model.ChangeAction;
import com.amazonaws.services.route53.model.ChangeBatch;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.RRType;
import com.amazonaws.services.route53.model.ResourceRecord;
import com.amazonaws.services.route53.model.ResourceRecordSet;
import jp.classmethod.aws.gradle.route53.AmazonRoute53PluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonRoute53ChangeRecordSetTask
extends ConventionTask {
    private String hostedZoneId;
    private String rrsName;
    private String resourceRecord;

    public AmazonRoute53ChangeRecordSetTask() {
        this.setDescription("Create/Migrate Route53 Record.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void changeResourceRecordSets() {
        String hostedZoneId = this.getHostedZoneId();
        String rrsName = this.getRrsName();
        String resourceRecord = this.getResourceRecord();
        AmazonRoute53PluginExtension ext = (AmazonRoute53PluginExtension)this.getProject().getExtensions().getByType(AmazonRoute53PluginExtension.class);
        AmazonRoute53 route53 = (AmazonRoute53)ext.getClient();
        route53.changeResourceRecordSets(new ChangeResourceRecordSetsRequest().withHostedZoneId(hostedZoneId).withChangeBatch(new ChangeBatch().withChanges(new Change[]{new Change(ChangeAction.CREATE, new ResourceRecordSet(rrsName, RRType.CNAME).withResourceRecords(new ResourceRecord[]{new ResourceRecord(resourceRecord)}))})));
        this.getLogger().info("change {} requested", (Object)hostedZoneId);
    }

    public String getHostedZoneId() {
        return this.hostedZoneId;
    }

    public void setHostedZoneId(String hostedZoneId) {
        this.hostedZoneId = hostedZoneId;
    }

    public String getRrsName() {
        return this.rrsName;
    }

    public void setRrsName(String rrsName) {
        this.rrsName = rrsName;
    }

    public String getResourceRecord() {
        return this.resourceRecord;
    }

    public void setResourceRecord(String resourceRecord) {
        this.resourceRecord = resourceRecord;
    }
}

