/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.rds;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DBCluster;
import com.amazonaws.services.rds.model.RestoreDBClusterToPointInTimeRequest;
import com.amazonaws.services.rds.model.Tag;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jp.classmethod.aws.gradle.rds.AmazonRDSPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonRDSRestoreDbClusterToPointInTimeTask
extends ConventionTask {
    private String dbClusterIdentifier;
    private String sourceDBClusterIdentifier;
    private String dbSubnetGroupName;
    private String kmsKeyId;
    private String optionGroupName;
    private int port;
    private Date restoreToTime;
    private String restoreType;
    private Boolean useLatestRestorableTime;
    private Map<String, String> tags;
    private List<String> vpcSecurityGroupIds;
    private DBCluster dbCluster;

    public AmazonRDSRestoreDbClusterToPointInTimeTask() {
        this.setDescription("Restore DbCluster To Point In Time.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void restoreDbClusterToPointInTime() {
        String dbClusterIdentifier = this.getDbClusterIdentifier();
        if (dbClusterIdentifier == null) {
            throw new GradleException("dbClusterIdentifier is not specified");
        }
        AmazonRDSPluginExtension ext = (AmazonRDSPluginExtension)this.getProject().getExtensions().getByType(AmazonRDSPluginExtension.class);
        AmazonRDS rds = (AmazonRDS)ext.getClient();
        RestoreDBClusterToPointInTimeRequest request = new RestoreDBClusterToPointInTimeRequest().withDBClusterIdentifier(dbClusterIdentifier).withDBSubnetGroupName(this.getDbSubnetGroupName()).withKmsKeyId(this.getKmsKeyId()).withRestoreType(this.getRestoreType()).withRestoreToTime(this.getRestoreToTime()).withSourceDBClusterIdentifier(this.getSourceDBClusterIdentifier()).withUseLatestRestorableTime(this.getUseLatestRestorableTime()).withVpcSecurityGroupIds(this.getVpcSecurityGroupIds()).withTags((Collection)this.getTags().entrySet().stream().map(it -> new Tag().withKey(((String)it.getKey()).toString()).withValue(((String)it.getValue()).toString())).collect(Collectors.toList()));
        if (this.getPort() != 0) {
            request.setPort(Integer.valueOf(this.getPort()));
        }
        this.dbCluster = rds.restoreDBClusterToPointInTime(request);
        this.getLogger().info("Restored an RDS cluster to point in time: {}", (Object)this.dbCluster.getDBClusterIdentifier());
    }

    public String getDbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public void setDbClusterIdentifier(String dbClusterIdentifier) {
        this.dbClusterIdentifier = dbClusterIdentifier;
    }

    public String getSourceDBClusterIdentifier() {
        return this.sourceDBClusterIdentifier;
    }

    public void setSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
        this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
    }

    public String getDbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public void setDbSubnetGroupName(String dbSubnetGroupName) {
        this.dbSubnetGroupName = dbSubnetGroupName;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Date getRestoreToTime() {
        return this.restoreToTime;
    }

    public void setRestoreToTime(Date restoreToTime) {
        this.restoreToTime = restoreToTime;
    }

    public String getRestoreType() {
        return this.restoreType;
    }

    public void setRestoreType(String restoreType) {
        this.restoreType = restoreType;
    }

    public Boolean getUseLatestRestorableTime() {
        return this.useLatestRestorableTime;
    }

    public void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
        this.useLatestRestorableTime = useLatestRestorableTime;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public List<String> getVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public void setVpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
        this.vpcSecurityGroupIds = vpcSecurityGroupIds;
    }

    public DBCluster getDbCluster() {
        return this.dbCluster;
    }
}

