/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.rds;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.RebootDBInstanceRequest;
import jp.classmethod.aws.gradle.rds.AmazonRDSPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonRDSRebootDBInstanceTask
extends ConventionTask {
    private String dbInstanceIdentifier;
    private Boolean forceFailover;
    private DBInstance dbInstance;

    public AmazonRDSRebootDBInstanceTask() {
        this.setDescription("Reboot RDS instance.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void rebootDBInstance() {
        String dbInstanceIdentifier = this.getDbInstanceIdentifier();
        if (dbInstanceIdentifier == null) {
            throw new GradleException("dbInstanceIdentifier is required");
        }
        AmazonRDSPluginExtension ext = (AmazonRDSPluginExtension)this.getProject().getExtensions().getByType(AmazonRDSPluginExtension.class);
        AmazonRDS rds = (AmazonRDS)ext.getClient();
        RebootDBInstanceRequest request = new RebootDBInstanceRequest().withDBInstanceIdentifier(dbInstanceIdentifier).withForceFailover(this.getForceFailover());
        this.dbInstance = rds.rebootDBInstance(request);
        this.getLogger().info("Reboot RDS instance requested: {}", (Object)this.dbInstance.getDBInstanceIdentifier());
    }

    public String getDbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public void setDbInstanceIdentifier(String dbInstanceIdentifier) {
        this.dbInstanceIdentifier = dbInstanceIdentifier;
    }

    public Boolean getForceFailover() {
        return this.forceFailover;
    }

    public void setForceFailover(Boolean forceFailover) {
        this.forceFailover = forceFailover;
    }

    public DBInstance getDbInstance() {
        return this.dbInstance;
    }
}

