/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.rds;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.DBInstanceNotFoundException;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import java.util.Arrays;
import java.util.List;
import jp.classmethod.aws.gradle.rds.AmazonRDSPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonRDSDescribeInstanceTask
extends ConventionTask {
    private String dbInstanceIdentifier;
    private List<String> successStatuses = Arrays.asList("available", "backing-up", "terminated");
    private List<String> waitStatuses = Arrays.asList("creating", "deleting", "modifying", "rebooting", "renaming", "resetting-master-credentials");
    private int loopTimeout = 900;
    private int loopWait = 10;
    private boolean found;
    private String lastStatus;
    private DBInstance dbInstance;

    public AmazonRDSDescribeInstanceTask() {
        this.setDescription("Wait RDS instance for specific status.");
        this.setGroup("AWS");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TaskAction
    public void waitInstanceForStatus() {
        String dbInstanceIdentifier = this.getDbInstanceIdentifier();
        List<String> successStatuses = this.getSuccessStatuses();
        List<String> waitStatuses = this.getWaitStatuses();
        int loopTimeout = this.getLoopTimeout();
        int loopWait = this.getLoopWait();
        if (dbInstanceIdentifier == null) {
            throw new GradleException("dbInstanceIdentifier is not specified");
        }
        AmazonRDSPluginExtension ext = (AmazonRDSPluginExtension)this.getProject().getExtensions().getByType(AmazonRDSPluginExtension.class);
        AmazonRDS rds = (AmazonRDS)ext.getClient();
        long start = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() > start + (long)(loopTimeout * 1000)) {
                throw new GradleException("Timeout");
            }
            try {
                DescribeDBInstancesResult dir = rds.describeDBInstances(new DescribeDBInstancesRequest().withDBInstanceIdentifier(dbInstanceIdentifier));
                this.dbInstance = (DBInstance)dir.getDBInstances().get(0);
                this.found = true;
                this.lastStatus = this.dbInstance.getDBInstanceStatus();
                if (successStatuses.contains(this.lastStatus)) {
                    this.getLogger().info("Description of DB instance {} is now {}.", (Object)dbInstanceIdentifier, (Object)this.lastStatus);
                    return;
                }
                if (!waitStatuses.contains(this.lastStatus)) throw new GradleException("Status of " + dbInstanceIdentifier + " is " + this.lastStatus + ".  It seems to be failed.");
                this.getLogger().info("Description of DB instance {} is {}...", (Object)dbInstanceIdentifier, (Object)this.lastStatus);
                try {
                    Thread.sleep(loopWait * 1000);
                }
                catch (InterruptedException e) {
                    throw new GradleException("Sleep interrupted", (Throwable)e);
                }
            }
            catch (DBInstanceNotFoundException e) {
                throw new GradleException(dbInstanceIdentifier + " is not exists", (Throwable)e);
            }
            catch (AmazonServiceException e) {
                if (!this.found) throw new GradleException("Fail to describe instance: " + dbInstanceIdentifier, (Throwable)e);
                return;
            }
        }
    }

    public String getDbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public void setDbInstanceIdentifier(String dbInstanceIdentifier) {
        this.dbInstanceIdentifier = dbInstanceIdentifier;
    }

    public List<String> getSuccessStatuses() {
        return this.successStatuses;
    }

    public void setSuccessStatuses(List<String> successStatuses) {
        this.successStatuses = successStatuses;
    }

    public List<String> getWaitStatuses() {
        return this.waitStatuses;
    }

    public void setWaitStatuses(List<String> waitStatuses) {
        this.waitStatuses = waitStatuses;
    }

    public int getLoopTimeout() {
        return this.loopTimeout;
    }

    public void setLoopTimeout(int loopTimeout) {
        this.loopTimeout = loopTimeout;
    }

    public int getLoopWait() {
        return this.loopWait;
    }

    public void setLoopWait(int loopWait) {
        this.loopWait = loopWait;
    }

    public boolean isFound() {
        return this.found;
    }

    public String getLastStatus() {
        return this.lastStatus;
    }

    public DBInstance getDbInstance() {
        return this.dbInstance;
    }
}

