/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.lambda;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.PublishVersionRequest;
import com.amazonaws.services.lambda.model.PublishVersionResult;
import jp.classmethod.aws.gradle.lambda.AWSLambdaPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSLambdaPublishVersionTask
extends ConventionTask {
    private String functionName;
    private String codeSha256;
    private String description;
    private PublishVersionResult publishVersionResult;

    @TaskAction
    public void publishVersion() {
        String functionName = this.getFunctionName();
        if (functionName == null) {
            throw new GradleException("functionName is required");
        }
        AWSLambda lambda = this.getAwsLambdaClient();
        PublishVersionRequest request = new PublishVersionRequest().withFunctionName(functionName);
        if (this.getCodeSha256() != null) {
            request.withCodeSha256(this.getCodeSha256());
        }
        if (this.getDescription() != null) {
            request.withDescription(this.getDescription());
        }
        this.publishVersionResult = lambda.publishVersion(request);
        this.getLogger().info("Publish lambda version for {} succeeded with version {}", (Object)functionName, (Object)this.publishVersionResult.getVersion());
    }

    private AWSLambda getAwsLambdaClient() {
        AWSLambdaPluginExtension ext = (AWSLambdaPluginExtension)this.getProject().getExtensions().getByType(AWSLambdaPluginExtension.class);
        return (AWSLambda)ext.getClient();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getCodeSha256() {
        return this.codeSha256;
    }

    public void setCodeSha256(String codeSha256) {
        this.codeSha256 = codeSha256;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PublishVersionResult getPublishVersionResult() {
        return this.publishVersionResult;
    }
}

