/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.identitymanagement;

import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.AttachRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.CreateRoleRequest;
import com.amazonaws.services.identitymanagement.model.CreateRoleResult;
import java.util.ArrayList;
import java.util.List;
import jp.classmethod.aws.gradle.identitymanagement.AmazonIdentityManagementPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonIdentityManagementCreateRoleTask
extends ConventionTask {
    private String path = "/";
    private String roleName;
    private String assumeRolePolicyDocument;
    private List<String> policyArns = new ArrayList<String>();
    private CreateRoleResult createRole;

    public AmazonIdentityManagementCreateRoleTask() {
        this.setDescription("Create Role.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createRole() {
        String roleName = this.getRoleName();
        String assumeRolePolicyDocument = this.getAssumeRolePolicyDocument();
        if (roleName == null) {
            throw new GradleException("roleName is required");
        }
        if (assumeRolePolicyDocument == null) {
            throw new GradleException("assumeRolePolicyDocument is required");
        }
        AmazonIdentityManagementPluginExtension ext = (AmazonIdentityManagementPluginExtension)this.getProject().getExtensions().getByType(AmazonIdentityManagementPluginExtension.class);
        AmazonIdentityManagement iam = (AmazonIdentityManagement)ext.getClient();
        CreateRoleRequest request = new CreateRoleRequest().withRoleName(roleName).withPath(this.getPath()).withAssumeRolePolicyDocument(assumeRolePolicyDocument);
        this.createRole = iam.createRole(request);
        this.getLogger().info("Create Role requested: {}", (Object)this.createRole.getRole().getArn());
        this.policyArns.stream().forEach(policyArn -> {
            iam.attachRolePolicy(new AttachRolePolicyRequest().withRoleName(roleName).withPolicyArn(policyArn));
            this.getLogger().info("Attach Managed policy {} to Role {} requested", policyArn, (Object)roleName);
        });
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getAssumeRolePolicyDocument() {
        return this.assumeRolePolicyDocument;
    }

    public void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
        this.assumeRolePolicyDocument = assumeRolePolicyDocument;
    }

    public List<String> getPolicyArns() {
        return this.policyArns;
    }

    public void setPolicyArns(List<String> policyArns) {
        this.policyArns = policyArns;
    }

    public CreateRoleResult getCreateRole() {
        return this.createRole;
    }
}

