/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.identitymanagement;

import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.AttachRolePolicyRequest;
import java.util.ArrayList;
import java.util.List;
import jp.classmethod.aws.gradle.identitymanagement.AmazonIdentityManagementPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonIdentityManagementAttachRolePolicyTask
extends ConventionTask {
    private String path = "/";
    private String roleName;
    private List<String> policyArns = new ArrayList<String>();

    public AmazonIdentityManagementAttachRolePolicyTask() {
        this.setDescription("Attach managed policies to role.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void attachRolePolicy() {
        String roleName = this.getRoleName();
        if (roleName == null) {
            throw new GradleException("roleName is required");
        }
        AmazonIdentityManagementPluginExtension ext = (AmazonIdentityManagementPluginExtension)this.getProject().getExtensions().getByType(AmazonIdentityManagementPluginExtension.class);
        AmazonIdentityManagement iam = (AmazonIdentityManagement)ext.getClient();
        this.policyArns.stream().forEach(policyArn -> {
            iam.attachRolePolicy(new AttachRolePolicyRequest().withRoleName(roleName).withPolicyArn(policyArn));
            this.getLogger().info("Attach Managed policy {} to Role {} requested", policyArn, (Object)roleName);
        });
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public List<String> getPolicyArns() {
        return this.policyArns;
    }

    public void setPolicyArns(List<String> policyArns) {
        this.policyArns = policyArns;
    }
}

