/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.ChangeSetSummary;
import com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest;
import com.amazonaws.services.cloudformation.model.DescribeChangeSetResult;
import java.util.List;
import java.util.Optional;
import jp.classmethod.aws.gradle.cloudformation.ChangeSetFetcher;
import jp.classmethod.aws.gradle.cloudformation.StatusWaiter;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;

public class ChangeSetStatusWaiter
extends StatusWaiter {
    private final List<String> successStatuses;
    private final List<String> waitStatuses;

    public ChangeSetStatusWaiter(AmazonCloudFormation cfn, String stackName, Logger logger, List<String> stableStatuses, List<String> waitStatuses, int loopTimeout, int loopWait) throws InterruptedException {
        super(cfn, stackName, logger, loopTimeout, loopWait);
        this.successStatuses = stableStatuses;
        this.waitStatuses = waitStatuses;
    }

    @Override
    public StatusWaiter.GetStatusResult getStatus() {
        Optional<ChangeSetSummary> summary = new ChangeSetFetcher(this.cfn).getLatestChangeSetSummary(this.stackName);
        String changeSetName = summary.orElseThrow(() -> new GradleException("ChangeSet for stack " + this.stackName + " was not found.")).getChangeSetName();
        DescribeChangeSetRequest describeChangeSetRequest = new DescribeChangeSetRequest().withChangeSetName(changeSetName).withStackName(this.stackName);
        DescribeChangeSetResult describeChangeSetResult = this.cfn.describeChangeSet(describeChangeSetRequest);
        String status = describeChangeSetResult.getStatus();
        if ("FAILED".equals(status) && describeChangeSetResult.getChanges().isEmpty()) {
            this.logger.info("No updates to be performed.");
            return StatusWaiter.GetStatusResult.SUCCESS;
        }
        if (this.successStatuses.contains(status)) {
            return StatusWaiter.GetStatusResult.SUCCESS;
        }
        if (this.waitStatuses.contains(status)) {
            return StatusWaiter.GetStatusResult.WAITING;
        }
        return StatusWaiter.GetStatusResult.FAILURE;
    }

    @Override
    public String describeSubject() {
        return "change set for stack " + this.stackName;
    }
}

