/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.ChangeSetSummary;
import com.amazonaws.services.cloudformation.model.ListChangeSetsRequest;
import com.amazonaws.services.cloudformation.model.ListChangeSetsResult;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class ChangeSetFetcher {
    private final AmazonCloudFormation cfn;

    public ChangeSetFetcher(AmazonCloudFormation cfn) {
        this.cfn = cfn;
    }

    public Optional<ChangeSetSummary> getLatestChangeSetSummary(String stackName) {
        ListChangeSetsResult changeSetsResult = this.cfn.listChangeSets(new ListChangeSetsRequest().withStackName(stackName));
        List changeSetSummaries = changeSetsResult.getSummaries();
        if (changeSetSummaries.isEmpty()) {
            return Optional.empty();
        }
        changeSetSummaries.sort(Comparator.comparing(ChangeSetSummary::getCreationTime).reversed());
        return Optional.of(changeSetSummaries.get(0));
    }
}

