/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.logging.TopLinkLogRecord;

public class TopLinkSimpleFormatter
extends SimpleFormatter {
    Date dat = new Date();
    private static final String format = "{0,date} {0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    private String lineSeparator = PrivilegedAccessHelper.getLineSeparator();

    public synchronized String format(LogRecord record0) {
        if (!(record0 instanceof TopLinkLogRecord)) {
            return super.format(record0);
        }
        TopLinkLogRecord record = (TopLinkLogRecord)record0;
        StringBuffer sb = new StringBuffer();
        if (record.shouldPrintDate()) {
            this.dat.setTime(record.getMillis());
            this.args[0] = this.dat;
            StringBuffer text = new StringBuffer();
            if (this.formatter == null) {
                this.formatter = new MessageFormat(format);
            }
            this.formatter.format(this.args, text, (FieldPosition)null);
            sb.append(text);
            sb.append(" ");
        }
        if (record.getSourceClassName() != null) {
            sb.append(record.getSourceClassName());
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(" ");
            sb.append(record.getSourceMethodName());
        }
        if (record.getSessionString() != null) {
            sb.append(" ");
            sb.append(record.getSessionString());
        }
        if (record.getConnection() != null) {
            sb.append(" ");
            sb.append(AbstractSessionLog.CONNECTION_STRING + "(" + String.valueOf(System.identityHashCode(record.getConnection())) + ")");
        }
        if (record.shouldPrintThread()) {
            sb.append(" ");
            sb.append(AbstractSessionLog.THREAD_STRING + "(" + String.valueOf(record.getThreadID()) + ")");
        }
        sb.append(this.lineSeparator);
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                if (record.getLevel().intValue() == Level.SEVERE.intValue()) {
                    record.getThrown().printStackTrace(pw);
                } else if (record.getLevel().intValue() <= Level.WARNING.intValue()) {
                    if (record.shouldLogExceptionStackTrace()) {
                        record.getThrown().printStackTrace(pw);
                    } else {
                        pw.write(record.getThrown().toString());
                        pw.write(this.lineSeparator);
                    }
                }
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

