/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.StringFunctionNode;
import oracle.toplink.essentials.internal.parsing.TypeHelper;

public class TrimNode
extends StringFunctionNode {
    private Node trimChar;
    private boolean leading;
    private boolean trailing;
    private boolean both;

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.left != null) {
            this.left.validate(context);
            this.left.validateParameter(context, typeHelper.getStringType());
        }
        if (this.trimChar != null) {
            this.trimChar.validate(context);
            this.trimChar.validateParameter(context, typeHelper.getCharType());
        }
        this.setType(typeHelper.getStringType());
    }

    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getLeft().generateExpression(context);
        if (this.leading) {
            if (this.trimChar != null) {
                Expression trimCharExpr = this.trimChar.generateExpression(context);
                whereClause = whereClause.leftTrim(trimCharExpr);
            } else {
                whereClause = whereClause.leftTrim();
            }
        } else if (this.trailing) {
            if (this.trimChar != null) {
                Expression trimCharExpr = this.trimChar.generateExpression(context);
                whereClause = whereClause.rightTrim(trimCharExpr);
            } else {
                whereClause = whereClause.rightTrim();
            }
        } else if (this.trimChar != null) {
            Expression trimCharExpr = this.trimChar.generateExpression(context);
            whereClause = whereClause.leftTrim(trimCharExpr).rightTrim(trimCharExpr);
        } else {
            whereClause = whereClause.leftTrim().rightTrim();
        }
        return whereClause;
    }

    public void setTrimChar(Node trimChar) {
        this.trimChar = trimChar;
    }

    public boolean isLeading() {
        return this.leading;
    }

    public void setLeading(boolean newLeading) {
        this.leading = newLeading;
    }

    public boolean isTrailing() {
        return this.trailing;
    }

    public void setTrailing(boolean newTrailing) {
        this.trailing = newTrailing;
    }

    public boolean isBoth() {
        return this.both;
    }

    public void setBoth(boolean newBoth) {
        this.both = newBoth;
    }
}

