/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import java.util.HashSet;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.EntityMappingsXMLProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLAccessor
extends MetadataAccessor {
    protected Node m_node;
    protected XMLHelper m_helper;
    protected String m_attributeName;

    public XMLAccessor(MetadataAccessibleObject accessibleObject, EntityMappingsXMLProcessor processor, XMLDescriptor xmlDmd, Node node) {
        this.setNeedsProcessing(true);
        this.m_node = node;
        this.m_metadataProcessor = processor;
        this.m_metadataDescriptor = xmlDmd;
        this.m_metadataAccessibleObject = accessibleObject;
        this.m_helper = ((EntityMappingsXMLProcessor)this.m_metadataProcessor).getHelper();
        this.m_isRelationship = null;
    }

    public Node getAttributeNode() {
        return this.m_node;
    }

    public NodeList getAttributeOverrideNodes() {
        return this.m_helper.getNodes(this.m_node, "attribute-override");
    }

    public NodeList getCascade() {
        return this.m_helper.getNodes(this.m_node, "cascade", "child::*");
    }

    public Object[] getCascadeTypes() {
        HashSet<String> cascadeVals = new HashSet<String>();
        if (this.hasCascade()) {
            NodeList cascadeNodes = this.getCascade();
            int nodeCount = cascadeNodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                cascadeVals.add(cascadeNodes.item(i).getLocalName());
            }
        }
        return cascadeVals.toArray();
    }

    public Node getColumnNode() {
        return this.m_helper.getNode(this.m_node, "column");
    }

    public Object getElement() {
        return this.m_node;
    }

    public Node getEnumeratedNode() {
        return this.m_helper.getNode(this.m_node, new String[]{"enumerated", "text()"});
    }

    public String getFetchType() {
        String fetchVal = this.isManyToOne() || this.isOneToOne() || this.isBasic() ? "EAGER" : "LAZY";
        Node fetchNode = this.m_helper.getNode(this.m_node, "@fetch");
        if (fetchNode != null) {
            fetchVal = fetchNode.getNodeValue();
        }
        return fetchVal;
    }

    public Node getFetchNode() {
        return this.m_helper.getNode(this.m_node, "@fetch");
    }

    public Node getGeneratedValueNode() {
        return this.m_helper.getNode(this.m_node, "generated-value");
    }

    public Class getJavaClass() {
        return this.getMetadataDescriptor().getJavaClass();
    }

    public Node getJoinTableNode() {
        return this.m_helper.getNode(this.m_node, "join-table");
    }

    public Node getLobNode() {
        return this.m_helper.getNode(this.m_node, new String[]{"lob", "text()"});
    }

    public Node getMapKeyNode() {
        return this.m_helper.getNode(this.m_node, "map-key");
    }

    public String getMappedBy() {
        if (!this.hasMappedBy()) {
            return "";
        }
        return this.getMappedByNode().getNodeValue();
    }

    public Node getMappedByNode() {
        return this.m_helper.getNode(this.m_node, "@mapped-by");
    }

    public XMLDescriptor getMetadataDescriptor() {
        return (XMLDescriptor)this.m_metadataDescriptor;
    }

    public String getMapKey() {
        String mapKey = "";
        Node mapKeyNode = this.getMapKeyNode();
        if (mapKeyNode != null && mapKeyNode.getNodeValue() != null) {
            mapKey = mapKeyNode.getNodeValue();
        }
        return mapKey;
    }

    public String getOrderBy() {
        return this.getOrderByNode().getNodeValue();
    }

    public Node getOrderByNode() {
        return this.m_helper.getNode(this.m_node, new String[]{"order-by", "text()"});
    }

    public Node getSequenceGeneratorNode() {
        return this.m_helper.getNode(this.m_node, "sequence-generator");
    }

    public Node getTableGeneratorNode() {
        return this.m_helper.getNode(this.m_node, "table-generator");
    }

    public Class getTargetEntity() {
        Node targetNode = this.getTargetEntityNode();
        if (targetNode == null) {
            return this.getReferenceClass();
        }
        return this.m_helper.getClassForName(targetNode.getNodeValue());
    }

    public Node getTargetEntityNode() {
        return this.m_helper.getNode(this.m_node, "@target-entity");
    }

    public Node getTemporalNode() {
        return this.m_helper.getNode(this.m_node, new String[]{"temporal", "text()"});
    }

    public String getTemporalType() {
        return this.getTemporalNode().getNodeValue();
    }

    public boolean hasCascade() {
        return this.getCascade() != null && this.getCascade().getLength() > 0;
    }

    public boolean hasColumn() {
        return this.getColumnNode() != null;
    }

    public boolean hasEnumerated() {
        return this.getEnumeratedNode() != null;
    }

    public boolean hasFetch() {
        return this.getFetchNode() != null;
    }

    public boolean hasJoinColumn() {
        NodeList joinColumnNodes = this.m_helper.getNodes(this.m_node, "join-column");
        return joinColumnNodes != null && joinColumnNodes.getLength() == 1;
    }

    public boolean hasJoinColumns() {
        NodeList joinColumnNodes = this.m_helper.getNodes(this.m_node, "join-column");
        return joinColumnNodes != null && joinColumnNodes.getLength() > 1;
    }

    public boolean hasMappedBy() {
        return this.getMappedByNode() != null;
    }

    public boolean hasOrderBy() {
        Node orderByNode = this.getOrderByNode();
        return orderByNode != null && orderByNode.getNodeValue() != null;
    }

    public boolean hasPrimaryKeyJoinColumn() {
        NodeList joinColumnNodes = this.m_helper.getNodes(this.m_node, "primary-key-join-column");
        return joinColumnNodes != null && joinColumnNodes.getLength() == 1;
    }

    public boolean hasPrimaryKeyJoinColumns() {
        NodeList joinColumnNodes = this.m_helper.getNodes(this.m_node, "primary-key-join-column");
        return joinColumnNodes != null && joinColumnNodes.getLength() > 1;
    }

    public boolean hasSequenceGenerator() {
        return this.getSequenceGeneratorNode() != null;
    }

    public boolean hasSqlResultSetMapping() {
        return this.m_helper.getNode(this.m_node, "sql-result-set-mapping") != null;
    }

    public boolean hasTableGenerator() {
        return this.getTableGeneratorNode() != null;
    }

    public boolean hasTemporal() {
        return this.getTemporalNode() != null;
    }

    public boolean isBasic() {
        return this.m_node.getLocalName().equals("basic");
    }

    public boolean isEmbedded() {
        Node embeddedNode = this.m_helper.getNode(this.m_node, "embedded");
        Node embeddedIdNode = this.m_helper.getNode(this.m_node, "embedded-id");
        Node referenceClassNode = this.m_helper.locateEmbeddableNode(this.getReferenceClass());
        return embeddedNode != null || referenceClassNode != null && embeddedIdNode == null;
    }

    public boolean isEmbeddedId() {
        return this.m_helper.getNode(this.m_node, "embedded-id") != null;
    }

    public boolean isId() {
        return this.m_node.getLocalName().equals("id");
    }

    public boolean isLob() {
        return this.getLobNode() != null;
    }

    public boolean isManyToMany() {
        if (this.m_node.getLocalName().equals("many-to-many")) {
            if (MetadataHelper.isSupportedCollectionClass(this.getRawClass())) {
                return true;
            }
            throw ValidationException.invalidCollectionTypeForRelationship(this.getRawClass(), this.m_attributeName);
        }
        return false;
    }

    public boolean isManyToOne() {
        return this.m_node.getLocalName().equals("many-to-one");
    }

    public boolean isOneToMany() {
        if (this.m_node.getLocalName().equals("one-to-many")) {
            if (MetadataHelper.isSupportedCollectionClass(this.getRawClass())) {
                return true;
            }
            throw ValidationException.invalidCollectionTypeForRelationship(this.getRawClass(), this.m_attributeName);
        }
        return false;
    }

    public boolean isOneToOne() {
        return this.m_node.getLocalName().equals("one-to-one");
    }

    public boolean isOptional() {
        boolean optional = true;
        Node optionalNode = this.m_helper.getNode(this.m_node, "@optional");
        if (optionalNode != null) {
            optional = Boolean.getBoolean(optionalNode.getNodeValue());
        }
        return optional;
    }

    public boolean isTargetEntityDefinedInDocument() {
        return this.m_helper.locateNode(this.getTargetEntity()) != null;
    }

    public boolean isVersion() {
        return this.m_helper.getNode(this.m_node, "version") != null;
    }

    public void store() {
        this.getMetadataDescriptor().addAccessor(this);
    }

    public boolean usesIndirection() {
        return this.getFetchType().equals("LAZY");
    }
}

