/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.base;

import java.util.HashMap;
import java.util.Map;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;

public class QueryHintsHandler {
    public static void verify(Map hints, String queryName, AbstractSession session) {
        if (hints == null) {
            return;
        }
        for (Map.Entry entry : hints.entrySet()) {
            String hintName = (String)entry.getKey();
            QueryHintsHandler.verify(hintName, entry.getValue(), queryName, session);
        }
    }

    public static void verify(String hintName, Object hintValue, String queryName, AbstractSession session) {
        Hint.verify(hintName, QueryHintsHandler.shouldUseDefault(hintValue), hintValue, queryName, session);
    }

    public static void apply(Map hints, DatabaseQuery query) {
        if (hints == null) {
            return;
        }
        for (Map.Entry entry : hints.entrySet()) {
            String hintName = (String)entry.getKey();
            QueryHintsHandler.apply(hintName, entry.getValue(), query);
        }
    }

    public static void apply(String hintName, Object hintValue, DatabaseQuery query) {
        Hint.apply(hintName, QueryHintsHandler.shouldUseDefault(hintValue), hintValue, query);
    }

    protected static boolean shouldUseDefault(Object hintValue) {
        return hintValue != null && hintValue instanceof String && ((String)hintValue).length() == 0;
    }

    protected static class RefreshHint
    extends Hint {
        RefreshHint() {
            super("toplink.refresh", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        void applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            if (query.isObjectLevelReadQuery()) {
                ((ObjectLevelReadQuery)query).setShouldRefreshIdentityMapResult((Boolean)valueToApply);
            }
        }
    }

    protected static class PessimisticLockHint
    extends Hint {
        PessimisticLockHint() {
            super("toplink.pessimistic-lock", "NoLock");
            this.valueArray = new Object[][]{{"NoLock", (short)0}, {"Lock", (short)1}, {"LockNoWait", (short)2}};
        }

        void applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            if (query.isObjectLevelReadQuery()) {
                ((ObjectLevelReadQuery)query).setLockMode((Short)valueToApply);
            }
        }
    }

    protected static class CacheUsageHint
    extends Hint {
        CacheUsageHint() {
            super("toplink.cache-usage", "UseEntityDefault");
            this.valueArray = new Object[][]{{"UseEntityDefault", -1}, {"DoNotCheckCache", 0}, {"CheckCacheByExactPrimaryKey", 1}, {"CheckCacheByPrimaryKey", 2}, {"CheckCacheThenDatabase", 3}, {"CheckCacheOnly", 4}, {"ConformResultsInUnitOfWork", 5}};
        }

        void applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            if (query.isObjectLevelReadQuery()) {
                ((ObjectLevelReadQuery)query).setCacheUsage((Integer)valueToApply);
            }
        }
    }

    protected static class BindParametersHint
    extends Hint {
        BindParametersHint() {
            super("toplink.jdbc.bind-parameters", "PersistenceUnitDefault");
            this.valueArray = new Object[][]{{"PersistenceUnitDefault", null}, {"True", Boolean.TRUE}, {"False", Boolean.FALSE}};
        }

        void applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            if (valueToApply == null) {
                query.ignoreBindAllParameters();
            } else {
                query.setShouldBindAllParameters((Boolean)valueToApply);
            }
        }
    }

    protected static abstract class Hint {
        static HashMap mainMap = new HashMap();
        Object[] valueArray;
        HashMap valueMap;
        String name;
        String defaultValue;
        Object defaultValueToApply;
        boolean valueToApplyMayBeNull;

        Hint(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        abstract void applyToDatabaseQuery(Object var1, DatabaseQuery var2);

        static void verify(String hintName, boolean shouldUseDefault, Object hintValue, String queryName, AbstractSession session) {
            Hint hint = (Hint)mainMap.get(hintName);
            if (hint == null) {
                if (session != null) {
                    session.log(1, "query", "unknown_query_hint", new Object[]{Hint.getPrintValue(queryName), hintName});
                }
                return;
            }
            hint.verify(hintValue, shouldUseDefault, queryName, session);
        }

        void verify(Object hintValue, boolean shouldUseDefault, String queryName, AbstractSession session) {
            if (shouldUseDefault) {
                hintValue = this.defaultValue;
            }
            if (session != null) {
                session.log(1, "query", "query_hint", new Object[]{Hint.getPrintValue(queryName), this.name, Hint.getPrintValue(hintValue)});
            }
            if (!shouldUseDefault && this.valueMap != null && !this.valueMap.containsKey(Hint.getUpperCaseString(hintValue))) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-query-hint-value", new Object[]{Hint.getPrintValue(queryName), this.name, Hint.getPrintValue(hintValue)}));
            }
        }

        static void apply(String hintName, boolean shouldUseDefault, Object hintValue, DatabaseQuery query) {
            Hint hint = (Hint)mainMap.get(hintName);
            if (hint == null) {
                return;
            }
            hint.apply(hintValue, shouldUseDefault, query);
        }

        void apply(Object hintValue, boolean shouldUseDefault, DatabaseQuery query) {
            String key;
            Object valueToApply = hintValue;
            if (shouldUseDefault) {
                valueToApply = this.defaultValueToApply;
            } else if (this.valueMap != null && (valueToApply = this.valueMap.get(key = Hint.getUpperCaseString(hintValue))) == null) {
                boolean wrongKey = true;
                if (this.valueToApplyMayBeNull) {
                    boolean bl = wrongKey = !this.valueMap.containsKey(key);
                }
                if (wrongKey) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-query-hint-value", new Object[]{Hint.getQueryId(query), this.name, Hint.getPrintValue(hintValue)}));
                }
            }
            this.applyToDatabaseQuery(valueToApply, query);
        }

        static String getQueryId(DatabaseQuery query) {
            String queryId = query.getName();
            if (queryId == null) {
                queryId = query.getEJBQLString();
            }
            return Hint.getPrintValue(queryId);
        }

        static String getPrintValue(Object hintValue) {
            return hintValue != null ? hintValue.toString() : "null";
        }

        static String getUpperCaseString(Object hintValue) {
            return hintValue != null ? hintValue.toString().toUpperCase() : null;
        }

        void initialize() {
            if (this.valueArray != null) {
                this.valueMap = new HashMap(this.valueArray.length);
                if (this.valueArray instanceof Object[][]) {
                    Object[][] valueArray2 = (Object[][])this.valueArray;
                    for (int i = 0; i < valueArray2.length; ++i) {
                        this.valueMap.put(Hint.getUpperCaseString(valueArray2[i][0]), valueArray2[i][1]);
                        if (valueArray2[i][1] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                } else {
                    for (int i = 0; i < this.valueArray.length; ++i) {
                        this.valueMap.put(Hint.getUpperCaseString(this.valueArray[i]), this.valueArray[i]);
                        if (this.valueArray[i] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                }
                this.defaultValueToApply = this.valueMap.get(this.defaultValue.toUpperCase());
            }
        }

        static void addHint(Hint hint) {
            hint.initialize();
            mainMap.put(hint.name, hint);
        }

        static {
            Hint.addHint(new BindParametersHint());
            Hint.addHint(new CacheUsageHint());
            Hint.addHint(new PessimisticLockHint());
            Hint.addHint(new RefreshHint());
        }
    }
}

