/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.EnumSet;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedClassForName;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.converters.ObjectTypeConverter;
import oracle.toplink.essentials.sessions.Session;

public class EnumTypeConverter
extends ObjectTypeConverter {
    private Class m_enumClass;
    private String m_enumClassName;
    private boolean m_usesOrdinalValues;

    public EnumTypeConverter(DatabaseMapping mapping, String enumClassName, boolean usesOrdinalValues) {
        super(mapping);
        this.m_enumClassName = enumClassName;
        this.m_usesOrdinalValues = usesOrdinalValues;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        block5: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.m_enumClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.m_enumClassName, true, classLoader));
                        break block5;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.m_enumClassName, exception.getException());
                    }
                }
                this.m_enumClass = PrivilegedAccessHelper.getClassForName(this.m_enumClassName, true, classLoader);
            }
            catch (ClassNotFoundException exception) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.m_enumClassName, exception);
            }
        }
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        for (Enum theEnum : EnumSet.allOf(this.m_enumClass)) {
            if (this.m_usesOrdinalValues) {
                this.addConversionValue(theEnum.ordinal(), theEnum);
                continue;
            }
            this.addConversionValue(theEnum.name(), theEnum);
        }
        super.initialize(mapping, session);
    }

    public boolean usesOrdinalValues() {
        return this.m_usesOrdinalValues;
    }
}

