/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.expressions.SQLDeleteStatement;
import oracle.toplink.essentials.internal.expressions.SQLSelectStatement;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.indirection.TransparentIndirectionPolicy;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.queryframework.DirectMapContainerPolicy;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ChangeRecord;
import oracle.toplink.essentials.internal.sessions.DirectMapChangeRecord;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DirectCollectionMapping;
import oracle.toplink.essentials.mappings.converters.Converter;
import oracle.toplink.essentials.mappings.converters.TypeConversionConverter;
import oracle.toplink.essentials.queryframework.DataReadQuery;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;
import oracle.toplink.essentials.sessions.DatabaseRecord;

public class DirectMapMapping
extends DirectCollectionMapping {
    protected DatabaseField directKeyField;
    protected Converter keyConverter;

    public DirectMapMapping() {
        this.selectionQuery = new DataReadQuery();
        this.containerPolicy = new DirectMapContainerPolicy(ClassConstants.Hashtable_Class);
    }

    public Converter getKeyConverter() {
        return this.keyConverter;
    }

    public void setKeyConverter(Converter keyConverter) {
        this.keyConverter = keyConverter;
    }

    public void addToCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        collectionChangeRecord.addAdditionChange(newKey, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildCloneForPartObject(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        DirectMapContainerPolicy containerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        if (attributeValue == null) {
            return containerPolicy.containerInstance(1);
        }
        Object clonedAttributeValue = containerPolicy.containerInstance(containerPolicy.sizeFor(attributeValue));
        Object temporaryCollection = null;
        Object object = attributeValue;
        synchronized (object) {
            temporaryCollection = containerPolicy.cloneFor(attributeValue);
        }
        Object keysIterator = containerPolicy.iteratorFor(temporaryCollection);
        while (containerPolicy.hasNext(keysIterator)) {
            Object key = containerPolicy.next(keysIterator, unitOfWork);
            Object cloneKey = this.buildKeyClone(key, unitOfWork, isExisting);
            Object cloneValue = this.buildElementClone(containerPolicy.valueFromKey(key, temporaryCollection), unitOfWork, isExisting);
            containerPolicy.addInto(cloneKey, cloneValue, clonedAttributeValue, unitOfWork);
        }
        return clonedAttributeValue;
    }

    protected Object buildKeyClone(Object element, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        Object cloneValue = element;
        if (this.getKeyConverter() != null && this.getKeyConverter().isMutable()) {
            cloneValue = this.getKeyConverter().convertDataValueToObjectValue(this.getKeyConverter().convertObjectValueToDataValue(cloneValue, unitOfWork), unitOfWork);
        }
        return cloneValue;
    }

    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        DirectMapContainerPolicy cp = (DirectMapContainerPolicy)this.getContainerPolicy();
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        Map cloneObjectCollection = (Map)this.getRealCollectionAttributeValueFromObject(clone, session);
        HashMap originalKeyValues = new HashMap(10);
        HashMap cloneKeyValues = new HashMap(10);
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backUp);
            if (backUpAttribute == null && cloneAttribute == null) {
                return null;
            }
            Map backUpCollection = (Map)this.getRealCollectionAttributeValueFromObject(backUp, session);
            Object backUpIter = cp.iteratorFor(backUpCollection);
            while (cp.hasNext(backUpIter)) {
                Object key = cp.next(backUpIter, session);
                originalKeyValues.put(key, backUpCollection.get(key));
            }
        }
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object firstObject = cp.next(cloneIter, session);
            Object firstValue = cloneObjectCollection.get(firstObject);
            Object backupValue = originalKeyValues.get(firstObject);
            if (!originalKeyValues.containsKey(firstObject)) {
                cloneKeyValues.put(firstObject, cloneObjectCollection.get(firstObject));
                continue;
            }
            if (backupValue == null && firstValue != null || !backupValue.equals(firstValue)) {
                cloneKeyValues.put(firstObject, cloneObjectCollection.get(firstObject));
                continue;
            }
            originalKeyValues.remove(firstObject);
        }
        if (cloneKeyValues.isEmpty() && originalKeyValues.isEmpty() && !owner.isNew()) {
            return null;
        }
        DirectMapChangeRecord changeRecord = new DirectMapChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.addAdditionChange(cloneKeyValues);
        changeRecord.addRemoveChange(originalKeyValues);
        return changeRecord;
    }

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstObjectMap = this.getRealCollectionAttributeValueFromObject(firstObject, session);
        Object secondObjectMap = this.getRealCollectionAttributeValueFromObject(secondObject, session);
        DirectMapContainerPolicy mapContainerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        return mapContainerPolicy.compareContainers(firstObjectMap, secondObjectMap);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.keyConverter != null && this.keyConverter instanceof TypeConversionConverter) {
            ((TypeConversionConverter)this.keyConverter).convertClassNamesToClasses(classLoader);
        }
    }

    public DatabaseField getDirectKeyField() {
        return this.directKeyField;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        this.initializeDirectKeyField(session);
        this.initializeContainerPolicy(session);
        if (this.getKeyConverter() != null) {
            this.getKeyConverter().initialize(this, session);
        }
        if (this.getValueConverter() != null) {
            this.getValueConverter().initialize(this, session);
        }
    }

    protected void initializeContainerPolicy(AbstractSession session) {
        ((DirectMapContainerPolicy)this.getContainerPolicy()).setKeyField(this.getDirectKeyField());
        ((DirectMapContainerPolicy)this.getContainerPolicy()).setValueField(this.getDirectField());
        ((DirectMapContainerPolicy)this.getContainerPolicy()).setKeyConverter(this.getKeyConverter());
        ((DirectMapContainerPolicy)this.getContainerPolicy()).setValueConverter(this.getValueConverter());
    }

    protected void initializeDeleteQuery(AbstractSession session) {
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression directKeyExp = ((Expression)builder).getField(this.getDirectKeyField()).equal(builder.getParameter(this.getDirectKeyField()));
        Expression expression = null;
        SQLDeleteStatement statement = new SQLDeleteStatement();
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = (DatabaseField)this.getReferenceKeyFields().elementAt(index);
            DatabaseField sourceKey = (DatabaseField)this.getSourceKeyFields().elementAt(index);
            Expression subExp1 = ((Expression)builder).getField(referenceKey);
            Expression subExp2 = builder.getParameter(sourceKey);
            Expression subExpression = subExp1.equal(subExp2);
            expression = subExpression.and(expression);
        }
        expression = expression.and(directKeyExp);
        statement.setWhereClause(expression);
        statement.setTable(this.getReferenceTable());
        this.getDeleteQuery().setSQLStatement(statement);
    }

    protected void initializeDirectKeyField(AbstractSession session) throws DescriptorException {
        if (this.getDirectKeyField() == null) {
            throw DescriptorException.directFieldNameNotSet(this);
        }
        this.getDirectKeyField().setTable(this.getReferenceTable());
        this.getDirectKeyField().setIndex(1);
    }

    protected void initializeInsertQuery(AbstractSession session) {
        super.initializeInsertQuery(session);
        this.getInsertQuery().getModifyRow().put(this.getDirectKeyField(), (Object)null);
    }

    protected void initializeSelectionStatement(AbstractSession session) {
        SQLSelectStatement statement = new SQLSelectStatement();
        statement.addTable(this.getReferenceTable());
        statement.addField((DatabaseField)this.getDirectField().clone());
        statement.addField((DatabaseField)this.getDirectKeyField().clone());
        statement.setWhereClause(this.getSelectionCriteria());
        statement.normalize(session, null);
        this.getSelectionQuery().setSQLStatement(statement);
    }

    public boolean isDirectMapMapping() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        DirectMapContainerPolicy containerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        Map valueOfTarget = null;
        AbstractSession session = mergeManager.getSession();
        HashMap addObjects = ((DirectMapChangeRecord)changeRecord).getAddObjects();
        HashMap removeObjects = ((DirectMapChangeRecord)changeRecord).getRemoveObjects();
        valueOfTarget = this.isAttributeValueInstantiated(target) && !changeRecord.getOwner().isNew() ? (Map)this.getRealCollectionAttributeValueFromObject(target, session) : (Map)containerPolicy.containerInstance(addObjects.size());
        if (!this.isAttributeValueInstantiated(target)) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            Object valueOfSource = this.getRealCollectionAttributeValueFromObject(source, session);
            Object iterator = containerPolicy.iteratorFor(valueOfSource);
            while (containerPolicy.hasNext(iterator)) {
                Object key = containerPolicy.next(iterator, session);
                containerPolicy.addInto(key, ((Map)valueOfSource).get(key), valueOfTarget, session);
            }
        } else {
            Map map = valueOfTarget;
            synchronized (map) {
                for (Object keyToRemove : removeObjects.keySet()) {
                    containerPolicy.removeFrom(keyToRemove, null, valueOfTarget, session);
                }
                for (Object keyToAdd : addObjects.keySet()) {
                    Object nextItem = addObjects.get(keyToAdd);
                    if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                        if (containerPolicy.contains(nextItem, valueOfTarget, session)) continue;
                        containerPolicy.addInto(keyToAdd, nextItem, valueOfTarget, session);
                        continue;
                    }
                    containerPolicy.addInto(keyToAdd, nextItem, valueOfTarget, session);
                }
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(target) : !this.isAttributeValueInstantiated(source)) {
            return;
        }
        Map valueOfSource = (Map)this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
        DirectMapContainerPolicy containerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        Object valueOfTarget = this.getRealCollectionAttributeValueFromObject(target, mergeManager.getSession());
        Object newContainer = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource));
        boolean fireChangeEvents = false;
        valueOfTarget = newContainer;
        Object sourceValuesIterator = containerPolicy.iteratorFor(valueOfSource);
        while (containerPolicy.hasNext(sourceValuesIterator)) {
            Object sourceKey = containerPolicy.next(sourceValuesIterator, mergeManager.getSession());
            containerPolicy.addInto(sourceKey, valueOfSource.get(sourceKey), valueOfTarget, mergeManager.getSession());
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    public void postInsert(WriteObjectQuery query) throws DatabaseException {
        DatabaseRecord databaseRow = new DatabaseRecord();
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        DirectMapContainerPolicy containerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        if (containerPolicy.isEmpty(objects)) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getSession());
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = (DatabaseField)this.getReferenceKeyFields().elementAt(index);
            DatabaseField sourceKey = (DatabaseField)this.getSourceKeyFields().elementAt(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            databaseRow.put(referenceKey, sourceKeyValue);
        }
        Object keyIter = containerPolicy.iteratorFor(objects);
        while (containerPolicy.hasNext(keyIter)) {
            Object key = containerPolicy.next(keyIter, query.getSession());
            Object value = containerPolicy.valueFromKey(key, objects);
            if (this.getKeyConverter() != null) {
                key = this.getKeyConverter().convertObjectValueToDataValue(key, query.getSession());
            }
            if (this.getValueConverter() != null) {
                value = this.getValueConverter().convertObjectValueToDataValue(value, query.getSession());
            }
            databaseRow.put(this.getDirectKeyField(), key);
            databaseRow.put(this.getDirectField(), value);
            if (query.shouldCascadeOnlyDependentParts()) {
                Object[] event = new Object[]{"insert", this.getInsertQuery(), databaseRow.clone()};
                query.getSession().getCommitManager().addDataModificationEvent(this, event);
                continue;
            }
            query.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRow);
        }
    }

    protected void postUpdateWithChangeSet(WriteObjectQuery writeQuery) throws DatabaseException {
        AbstractRecord thisRow;
        ObjectChangeSet changeSet = writeQuery.getObjectChangeSet();
        DirectMapChangeRecord changeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            return;
        }
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = (DatabaseField)this.getReferenceKeyFields().elementAt(index);
            DatabaseField sourceKey = (DatabaseField)this.getSourceKeyFields().elementAt(index);
            Object sourceKeyValue = writeQuery.getTranslationRow().get(sourceKey);
            writeQuery.getTranslationRow().put(referenceKey, sourceKeyValue);
        }
        for (Object key : changeRecord.getRemoveObjects().keySet()) {
            thisRow = (AbstractRecord)writeQuery.getTranslationRow().clone();
            if (this.getKeyConverter() != null) {
                key = this.getKeyConverter().convertObjectValueToDataValue(key, writeQuery.getSession());
            }
            thisRow.add(this.getDirectKeyField(), key);
            Object[] event = new Object[]{"delete", this.getDeleteQuery(), thisRow};
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
        }
        for (Object key : changeRecord.getAddObjects().keySet()) {
            thisRow = (AbstractRecord)writeQuery.getTranslationRow().clone();
            Object value = changeRecord.getAddObjects().get(key);
            if (this.getKeyConverter() != null) {
                key = this.getKeyConverter().convertObjectValueToDataValue(key, writeQuery.getSession());
            }
            if (this.getValueConverter() != null) {
                value = this.getValueConverter().convertObjectValueToDataValue(value, writeQuery.getSession());
            }
            thisRow.add(this.getDirectKeyField(), key);
            thisRow.add(this.getDirectField(), value);
            Object[] event = new Object[]{"insert", this.getInsertQuery(), thisRow};
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
        }
    }

    public void removeFromCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        collectionChangeRecord.addRemoveChange(newKey, newValue);
    }

    public void setDirectKeyField(DatabaseField keyField) {
        this.directKeyField = keyField;
    }

    public void setDirectKeyFieldName(String fieldName) {
        this.setDirectKeyField(new DatabaseField(fieldName));
    }

    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        if (collectionChangeRecord.getOriginalCollection() == null) {
            collectionChangeRecord.setOriginalCollection(oldValue);
        }
        collectionChangeRecord.setLatestCollection(newValue);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
    }

    public void useMapClass(Class concreteClass) {
        if (!Helper.classImplementsInterface(concreteClass, ClassConstants.Map_Class)) {
            throw DescriptorException.illegalContainerClass(concreteClass);
        }
        DirectMapContainerPolicy policy = new DirectMapContainerPolicy(concreteClass);
        this.setContainerPolicy(policy);
    }

    public void useTransparentMap() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useMapClass(ClassConstants.IndirectMap_Class);
    }

    public void setKeyClass(Class keyClass) {
        TypeConversionConverter converter = new TypeConversionConverter(this);
        converter.setObjectClass(keyClass);
        this.setKeyConverter(converter);
    }

    public Class getKeyClass() {
        if (!(this.getKeyConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getKeyConverter()).getObjectClass();
    }

    public void setValueClass(Class valueClass) {
        TypeConversionConverter converter = new TypeConversionConverter(this);
        converter.setObjectClass(valueClass);
        this.setValueConverter(converter);
    }

    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object objectToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            collectionChangeRecord.getAddObjects().put(referenceKey, objectToAdd);
            changeSet.addChange(collectionChangeRecord);
        } else if (collectionChangeRecord.getRemoveObjects().containsKey(referenceKey)) {
            collectionChangeRecord.getRemoveObjects().remove(referenceKey);
        } else {
            collectionChangeRecord.getAddObjects().put(referenceKey, objectToAdd);
        }
    }

    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object objectToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            collectionChangeRecord.getRemoveObjects().put(referenceKey, objectToRemove);
            changeSet.addChange(collectionChangeRecord);
        } else if (collectionChangeRecord.getAddObjects().containsKey(referenceKey)) {
            collectionChangeRecord.getAddObjects().remove(referenceKey);
        } else {
            collectionChangeRecord.getRemoveObjects().put(referenceKey, objectToRemove);
        }
    }

    public Class getValueClass() {
        if (!(this.getValueConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getValueConverter()).getObjectClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractResultFromBatchQuery(DatabaseQuery query, AbstractRecord databaseRow, AbstractSession session, AbstractRecord argumentRow) {
        Hashtable referenceDataByKey = null;
        ContainerPolicy mappingContainerPolicy = this.getContainerPolicy();
        DatabaseQuery databaseQuery = query;
        synchronized (databaseQuery) {
            referenceDataByKey = (Hashtable)query.getProperty("batched objects");
            mappingContainerPolicy = this.getContainerPolicy();
            if (referenceDataByKey == null) {
                Vector rows = (Vector)session.executeQuery(query, argumentRow);
                referenceDataByKey = new Hashtable();
                Enumeration rowsEnum = rows.elements();
                while (rowsEnum.hasMoreElements()) {
                    AbstractRecord referenceRow = (AbstractRecord)rowsEnum.nextElement();
                    Object referenceKey = referenceRow.get(this.getDirectKeyField());
                    Object referenceValue = referenceRow.get(this.getDirectField());
                    CacheKey eachCacheKey = new CacheKey(this.extractKeyFromReferenceRow(referenceRow, session));
                    Object container = referenceDataByKey.get(eachCacheKey);
                    if (container == null) {
                        container = mappingContainerPolicy.containerInstance();
                        referenceDataByKey.put(eachCacheKey, container);
                    }
                    if (this.getKeyConverter() != null) {
                        referenceKey = this.getKeyConverter().convertDataValueToObjectValue(referenceKey, query.getSession());
                    }
                    if (this.getValueConverter() != null) {
                        referenceValue = this.getValueConverter().convertDataValueToObjectValue(referenceValue, query.getSession());
                    }
                    mappingContainerPolicy.addInto(referenceKey, referenceValue, container, query.getSession());
                }
                query.setProperty("batched objects", referenceDataByKey);
            }
        }
        Object result = referenceDataByKey.get(new CacheKey(this.extractPrimaryKeyFromRow(databaseRow, session)));
        if (result == null) {
            return mappingContainerPolicy.containerInstance();
        }
        return result;
    }
}

