/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Map;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataMethod;

public abstract class MetadataAccessor {
    protected Boolean m_isRelationship;
    protected boolean m_needsProcessing;
    protected MetadataProcessor m_metadataProcessor;
    protected MetadataDescriptor m_metadataDescriptor;
    protected MetadataAccessibleObject m_metadataAccessibleObject;

    public String getAttributeName() {
        return this.m_metadataAccessibleObject.getAttributeName();
    }

    public abstract Object[] getCascadeTypes();

    public abstract Object getElement();

    public AnnotatedElement getAnnotatedElement() {
        return this.m_metadataAccessibleObject.getAnnotatedElement();
    }

    public abstract MetadataDescriptor getMetadataDescriptor();

    public Class getJavaClass() {
        return this.m_metadataDescriptor.getJavaClass();
    }

    public String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public abstract String getMapKey();

    public abstract String getMappedBy();

    public String getName() {
        return this.m_metadataAccessibleObject.getName();
    }

    public abstract String getOrderBy();

    public Class getRawClass() {
        return this.m_metadataAccessibleObject.getRawClass();
    }

    public Class getReferenceClass() {
        return this.m_metadataAccessibleObject.getReferenceClass();
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    public MetadataDescriptor getReferenceMetadataDescriptor() {
        return this.m_metadataProcessor.getMetadataDescriptor(this.getReferenceClass());
    }

    public Type getRelationType() {
        return this.m_metadataAccessibleObject.getRelationType();
    }

    public String getSetMethodName() {
        return ((MetadataMethod)this.m_metadataAccessibleObject).getSetMethodName();
    }

    public abstract Class getTargetEntity();

    public abstract String getTemporalType();

    public String getUpperCaseAttributeName() {
        return this.getAttributeName().toUpperCase();
    }

    public abstract boolean hasColumn();

    public abstract boolean hasEnumerated();

    public abstract boolean hasJoinColumn();

    public abstract boolean hasJoinColumns();

    public abstract boolean hasOrderBy();

    public abstract boolean hasPrimaryKeyJoinColumn();

    public abstract boolean hasPrimaryKeyJoinColumns();

    public abstract boolean hasSqlResultSetMapping();

    public abstract boolean hasTemporal();

    public abstract boolean isEmbedded();

    public abstract boolean isEmbeddedId();

    public boolean isEnumerated() {
        return this.hasEnumerated() || MetadataHelper.isValidEnumeratedType(this.getReferenceClass());
    }

    public abstract boolean isLob();

    public abstract boolean isManyToMany();

    public abstract boolean isManyToOne();

    public boolean isMapCollectionAccessor() {
        return this.getRawClass().equals(Map.class);
    }

    public abstract boolean isOneToMany();

    public abstract boolean isOneToOne();

    public boolean isOneToOnePrimaryKeyRelationship() {
        return this.isOneToOne() && (this.hasPrimaryKeyJoinColumns() || this.hasPrimaryKeyJoinColumn());
    }

    public abstract boolean isOptional();

    public boolean isRelationship() {
        if (this.m_isRelationship == null) {
            this.m_isRelationship = new Boolean(this.isManyToOne() || this.isManyToMany() || this.isOneToMany() || this.isOneToOne());
        }
        return this.m_isRelationship;
    }

    public boolean isSerialized() {
        return MetadataHelper.isValidSerializedType(this.getReferenceClass());
    }

    public boolean isTemporal() {
        if (MetadataHelper.isValidTemporalType(this.getReferenceClass()) && !this.hasTemporal()) {
            this.m_metadataProcessor.getValidator().throwNoTemporalTypeSpecified(this.getJavaClass(), this.getAttributeName());
        }
        return this.hasTemporal();
    }

    public abstract boolean isVersion();

    public boolean needsProcessing() {
        return this.m_needsProcessing;
    }

    public void process() {
        this.m_metadataProcessor.processRelationshipAccessor(this);
    }

    public void setNeedsProcessing(boolean value) {
        this.m_needsProcessing = value;
    }

    public void setReferenceClass(Class potentialReferenceClass, String context) {
        if (potentialReferenceClass == Void.TYPE) {
            this.m_metadataProcessor.getLogger().logConfigMessage(context, this.getAnnotatedElement(), (Object)this.getReferenceClass());
        } else {
            this.m_metadataAccessibleObject.setReferenceClass(potentialReferenceClass);
        }
    }

    public abstract void store();

    public abstract boolean usesIndirection();
}

