/*
 * Decompiled with CFR 0.152.
 */
package javax.json.bind.spi;

import java.util.Iterator;
import java.util.ServiceLoader;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbException;

public abstract class JsonbProvider {
    private static final String DEFAULT_PROVIDER = "org.eclipse.yasson.JsonBindingProvider";

    public static JsonbProvider provider() {
        ServiceLoader<JsonbProvider> loader = ServiceLoader.load(JsonbProvider.class);
        Iterator<JsonbProvider> it = loader.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        try {
            Class<?> clazz = Class.forName(DEFAULT_PROVIDER);
            return (JsonbProvider)clazz.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new JsonbException("JSON Binding provider org.eclipse.yasson.JsonBindingProvider not found", x);
        }
        catch (Exception x) {
            throw new JsonbException("JSON Binding provider org.eclipse.yasson.JsonBindingProvider could not be instantiated: " + x, x);
        }
    }

    public static JsonbProvider provider(String providerName) {
        if (providerName == null) {
            throw new IllegalArgumentException();
        }
        ServiceLoader<JsonbProvider> loader = ServiceLoader.load(JsonbProvider.class);
        for (JsonbProvider provider : loader) {
            if (!providerName.equals(provider.getClass().getName())) continue;
            return provider;
        }
        throw new JsonbException("JSON Binding provider " + providerName + " not found", new ClassNotFoundException(providerName));
    }

    public abstract JsonbBuilder create();
}

