/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.concurrent.TimeUnit;
import javax.cache.CacheLoader;
import javax.cache.CacheWriter;
import javax.cache.ExpiryPolicy;
import javax.cache.Factory;
import javax.cache.event.CacheEntryListenerRegistration;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;

public interface Configuration<K, V> {
    public boolean isReadThrough();

    public boolean isWriteThrough();

    public boolean isStoreByValue();

    public boolean isStatisticsEnabled();

    public boolean isManagementEnabled();

    public boolean isTransactionsEnabled();

    public IsolationLevel getTransactionIsolationLevel();

    public Mode getTransactionMode();

    public Iterable<CacheEntryListenerRegistration<? super K, ? super V>> getCacheEntryListenerRegistrations();

    public Factory<CacheLoader<K, V>> getCacheLoaderFactory();

    public Factory<CacheWriter<? super K, ? super V>> getCacheWriterFactory();

    public Factory<ExpiryPolicy<? super K, ? super V>> getExpiryPolicyFactory();

    public static class Duration {
        public static final Duration ETERNAL = new Duration();
        public static final Duration ZERO = new Duration(TimeUnit.SECONDS, 0L);
        private final TimeUnit timeUnit;
        private final long durationAmount;

        private Duration() {
            this.timeUnit = null;
            this.durationAmount = 0L;
        }

        public Duration(TimeUnit timeUnit, long durationAmount) {
            if (timeUnit == null) {
                throw new NullPointerException();
            }
            switch (timeUnit) {
                case NANOSECONDS: 
                case MICROSECONDS: {
                    throw new IllegalArgumentException("Must specify a TimeUnit of milliseconds or higher.");
                }
            }
            this.timeUnit = timeUnit;
            if (durationAmount < 0L) {
                throw new IllegalArgumentException("Cannot specify a negative durationAmount.");
            }
            this.durationAmount = durationAmount;
        }

        public Duration(long startTime, long endTime) {
            if (startTime == Long.MAX_VALUE || endTime == Long.MAX_VALUE) {
                this.timeUnit = null;
                this.durationAmount = 0L;
            } else {
                this.timeUnit = TimeUnit.MILLISECONDS;
                this.durationAmount = endTime - startTime;
            }
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public long getDurationAmount() {
            return this.durationAmount;
        }

        public boolean isEternal() {
            return this.timeUnit == null && this.durationAmount == 0L;
        }

        public boolean isZero() {
            return this.timeUnit != null && this.durationAmount == 0L;
        }

        public long getAdjustedTime(long time) {
            if (this.isEternal()) {
                return Long.MAX_VALUE;
            }
            return time + this.timeUnit.toMillis(this.durationAmount);
        }

        public boolean equals(Object o) {
            long time2;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Duration duration = (Duration)o;
            long time1 = this.timeUnit.toMillis(this.durationAmount);
            return time1 == (time2 = duration.timeUnit.toMillis(duration.durationAmount));
        }

        public int hashCode() {
            return Long.valueOf(this.timeUnit.toMillis(this.durationAmount)).hashCode();
        }
    }
}

