/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.ArrayList;
import javax.cache.CacheLoader;
import javax.cache.CacheWriter;
import javax.cache.Configuration;
import javax.cache.ExpiryPolicy;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerRegistration;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;

public class MutableConfiguration<K, V>
implements Configuration<K, V> {
    protected ArrayList<CacheEntryListenerRegistration<? super K, ? super V>> cacheEntryListenerRegistrations = new ArrayList();
    protected CacheLoader<K, ? extends V> cacheLoader;
    protected CacheWriter<? super K, ? super V> cacheWriter;
    protected ExpiryPolicy<? super K, ? super V> expiryPolicy;
    protected boolean isReadThrough;
    protected boolean isWriteThrough;
    protected boolean isStatisticsEnabled;
    protected boolean isStoreByValue;
    protected boolean isTransactionsEnabled;
    protected IsolationLevel txnIsolationLevel;
    protected Mode txnMode;

    public MutableConfiguration() {
        this.cacheLoader = null;
        this.cacheWriter = null;
        this.expiryPolicy = new ExpiryPolicy.Default<K, V>();
        this.isReadThrough = false;
        this.isWriteThrough = false;
        this.isStatisticsEnabled = false;
        this.isStoreByValue = true;
        this.isTransactionsEnabled = false;
        this.txnIsolationLevel = IsolationLevel.NONE;
        this.txnMode = Mode.NONE;
    }

    public MutableConfiguration(Iterable<CacheEntryListenerRegistration<? super K, ? super V>> cacheEntryListenerRegistrations, CacheLoader<K, ? extends V> cacheLoader, CacheWriter<? super K, ? super V> cacheWriter, ExpiryPolicy<? super K, ? super V> expiryPolicy, boolean isReadThrough, boolean isWriteThrough, boolean isStatisticsEnabled, boolean isStoreByValue, boolean isTransactionsEnabled, IsolationLevel txnIsolationLevel, Mode txnMode) {
        for (CacheEntryListenerRegistration<K, V> r : cacheEntryListenerRegistrations) {
            SimpleCacheEntryListenerRegistration<? super K, ? super V> registration = new SimpleCacheEntryListenerRegistration<K, V>(r.getCacheEntryListener(), r.getCacheEntryFilter(), r.isOldValueRequired(), r.isSynchronous());
            this.cacheEntryListenerRegistrations.add(registration);
        }
        this.cacheLoader = cacheLoader;
        this.cacheWriter = cacheWriter;
        this.expiryPolicy = expiryPolicy;
        this.isReadThrough = isReadThrough;
        this.isWriteThrough = isWriteThrough;
        this.isStatisticsEnabled = isStatisticsEnabled;
        this.isStoreByValue = isStoreByValue;
        this.isTransactionsEnabled = isTransactionsEnabled;
        this.txnIsolationLevel = txnIsolationLevel;
        this.txnMode = txnMode;
    }

    public MutableConfiguration(Configuration<K, V> configuration) {
        this(configuration.getCacheEntryListenerRegistrations(), configuration.getCacheLoader(), configuration.getCacheWriter(), configuration.getExpiryPolicy(), configuration.isReadThrough(), configuration.isWriteThrough(), configuration.isStatisticsEnabled(), configuration.isStoreByValue(), configuration.isTransactionsEnabled(), configuration.getTransactionIsolationLevel(), configuration.getTransactionMode());
    }

    @Override
    public Iterable<CacheEntryListenerRegistration<? super K, ? super V>> getCacheEntryListenerRegistrations() {
        return this.cacheEntryListenerRegistrations;
    }

    public MutableConfiguration<K, V> registerCacheEntryListener(CacheEntryListener<? super K, ? super V> cacheEntryListener, boolean requireOldValue, CacheEntryEventFilter<? super K, ? super V> cacheEntryEventFilter, boolean synchronous) {
        if (cacheEntryListener == null) {
            throw new NullPointerException("CacheEntryListener can't be null");
        }
        SimpleCacheEntryListenerRegistration<? super K, ? super V> registration = new SimpleCacheEntryListenerRegistration<K, V>(cacheEntryListener, cacheEntryEventFilter, requireOldValue, synchronous);
        boolean alreadyExists = false;
        for (CacheEntryListenerRegistration<K, V> r : this.cacheEntryListenerRegistrations) {
            if (!r.equals(registration)) continue;
            alreadyExists = true;
        }
        if (!alreadyExists) {
            this.cacheEntryListenerRegistrations.add(registration);
        }
        return this;
    }

    @Override
    public CacheLoader<K, ? extends V> getCacheLoader() {
        return this.cacheLoader;
    }

    public MutableConfiguration<K, V> setCacheLoader(CacheLoader<K, ? extends V> loader) {
        this.cacheLoader = loader;
        return this;
    }

    @Override
    public CacheWriter<? super K, ? super V> getCacheWriter() {
        return this.cacheWriter;
    }

    public MutableConfiguration<K, V> setCacheWriter(CacheWriter<? super K, ? super V> writer) {
        this.cacheWriter = writer;
        return this;
    }

    @Override
    public ExpiryPolicy<? super K, ? super V> getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public MutableConfiguration<K, V> setExpiryPolicy(ExpiryPolicy<? super K, ? super V> policy) {
        this.expiryPolicy = policy == null ? new ExpiryPolicy.Default<K, V>() : policy;
        return this;
    }

    @Override
    public IsolationLevel getTransactionIsolationLevel() {
        return this.txnIsolationLevel;
    }

    public MutableConfiguration<K, V> setTransactions(IsolationLevel level, Mode mode) {
        this.txnIsolationLevel = level;
        this.txnMode = mode;
        return this;
    }

    @Override
    public Mode getTransactionMode() {
        return this.txnMode;
    }

    public MutableConfiguration<K, V> setTransactionMode(Mode mode) {
        this.txnMode = mode;
        return this;
    }

    @Override
    public boolean isReadThrough() {
        return this.isReadThrough;
    }

    public MutableConfiguration<K, V> setReadThrough(boolean isReadThrough) {
        this.isReadThrough = isReadThrough;
        return this;
    }

    @Override
    public boolean isWriteThrough() {
        return this.isWriteThrough;
    }

    public MutableConfiguration<K, V> setWriteThrough(boolean isWriteThrough) {
        this.isWriteThrough = isWriteThrough;
        return this;
    }

    @Override
    public boolean isStoreByValue() {
        return this.isStoreByValue;
    }

    public MutableConfiguration<K, V> setStoreByValue(boolean isStoreByValue) {
        this.isStoreByValue = isStoreByValue;
        return this;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.isStatisticsEnabled = enabled;
    }

    @Override
    public boolean isTransactionsEnabled() {
        return this.isTransactionsEnabled;
    }

    public MutableConfiguration<K, V> setTransactionsEnabled(boolean isTransactionsEnabled) {
        this.isTransactionsEnabled = isTransactionsEnabled;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheEntryListenerRegistrations == null ? 0 : this.cacheEntryListenerRegistrations.hashCode());
        result = 31 * result + (this.cacheLoader == null ? 0 : this.cacheLoader.hashCode());
        result = 31 * result + (this.cacheWriter == null ? 0 : this.cacheWriter.hashCode());
        result = 31 * result + (this.expiryPolicy == null ? 0 : this.expiryPolicy.hashCode());
        result = 31 * result + (this.isReadThrough ? 1231 : 1237);
        result = 31 * result + (this.isStatisticsEnabled ? 1231 : 1237);
        result = 31 * result + (this.isStoreByValue ? 1231 : 1237);
        result = 31 * result + (this.isWriteThrough ? 1231 : 1237);
        result = 31 * result + (this.txnIsolationLevel == null ? 0 : this.txnIsolationLevel.hashCode());
        result = 31 * result + (this.txnMode == null ? 0 : this.txnMode.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof MutableConfiguration)) {
            return false;
        }
        MutableConfiguration other = (MutableConfiguration)object;
        if (this.cacheEntryListenerRegistrations == null ? other.cacheEntryListenerRegistrations != null : !this.cacheEntryListenerRegistrations.equals(other.cacheEntryListenerRegistrations)) {
            return false;
        }
        if (this.cacheLoader == null ? other.cacheLoader != null : !this.cacheLoader.equals(other.cacheLoader)) {
            return false;
        }
        if (this.cacheWriter == null ? other.cacheWriter != null : !this.cacheWriter.equals(other.cacheWriter)) {
            return false;
        }
        if (this.expiryPolicy == null ? other.expiryPolicy != null : !this.expiryPolicy.equals(other.expiryPolicy)) {
            return false;
        }
        if (this.isReadThrough != other.isReadThrough) {
            return false;
        }
        if (this.isStatisticsEnabled != other.isStatisticsEnabled) {
            return false;
        }
        if (this.isStoreByValue != other.isStoreByValue) {
            return false;
        }
        if (this.isWriteThrough != other.isWriteThrough) {
            return false;
        }
        if (this.isTransactionsEnabled != other.isTransactionsEnabled) {
            return false;
        }
        if (this.txnIsolationLevel != other.txnIsolationLevel) {
            return false;
        }
        return this.txnMode == other.txnMode;
    }

    static class SimpleCacheEntryListenerRegistration<K, V>
    implements CacheEntryListenerRegistration<K, V> {
        private CacheEntryListener<? super K, ? super V> listener;
        private CacheEntryEventFilter<? super K, ? super V> filter;
        private boolean isOldValueRequired;
        private boolean isSynchronous;

        public SimpleCacheEntryListenerRegistration(CacheEntryListener<? super K, ? super V> listener, CacheEntryEventFilter<? super K, ? super V> filter, boolean isOldValueRequired, boolean isSynchronous) {
            this.listener = listener;
            this.filter = filter;
            this.isOldValueRequired = isOldValueRequired;
            this.isSynchronous = isSynchronous;
        }

        @Override
        public CacheEntryEventFilter<? super K, ? super V> getCacheEntryFilter() {
            return this.filter;
        }

        @Override
        public CacheEntryListener<? super K, ? super V> getCacheEntryListener() {
            return this.listener;
        }

        @Override
        public boolean isOldValueRequired() {
            return this.isOldValueRequired;
        }

        @Override
        public boolean isSynchronous() {
            return this.isSynchronous;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
            result = 31 * result + (this.isOldValueRequired ? 1231 : 1237);
            result = 31 * result + (this.isSynchronous ? 1231 : 1237);
            result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
            return result;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof SimpleCacheEntryListenerRegistration)) {
                return false;
            }
            SimpleCacheEntryListenerRegistration other = (SimpleCacheEntryListenerRegistration)object;
            if (this.filter == null ? other.filter != null : !this.filter.equals(other.filter)) {
                return false;
            }
            if (this.isOldValueRequired != other.isOldValueRequired) {
                return false;
            }
            if (this.isSynchronous != other.isSynchronous) {
                return false;
            }
            return !(this.listener == null ? other.listener != null : !this.listener.equals(other.listener));
        }
    }
}

