/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import javax.cache.CacheManager;
import javax.cache.OptionalFeature;
import javax.cache.spi.AnnotationProvider;
import javax.cache.spi.CachingProvider;

public final class Caching {
    public static final String DEFAULT_CACHE_MANAGER_NAME = "__default__";

    private Caching() {
    }

    public static CacheManager getCacheManager() {
        return Caching.getCacheManager(DEFAULT_CACHE_MANAGER_NAME);
    }

    public static CacheManager getCacheManager(ClassLoader classLoader) {
        return Caching.getCacheManager(classLoader, DEFAULT_CACHE_MANAGER_NAME);
    }

    public static CacheManager getCacheManager(String name) {
        return CachingSingleton.INSTANCE.getCacheManager(name);
    }

    public static CacheManager getCacheManager(ClassLoader classLoader, String name) {
        return CachingSingleton.INSTANCE.getCacheManager(classLoader, name);
    }

    public static boolean close() {
        return CachingSingleton.INSTANCE.close();
    }

    public static boolean close(ClassLoader classLoader) {
        return CachingSingleton.INSTANCE.close(classLoader);
    }

    public static boolean close(ClassLoader classLoader, String name) {
        return CachingSingleton.INSTANCE.close(classLoader, name);
    }

    public static boolean isSupported(OptionalFeature optionalFeature) {
        switch (optionalFeature) {
            case ANNOTATIONS: {
                AnnotationProvider annotationProvider = ServiceFactoryHolder.INSTANCE.getAnnotationProvider();
                return annotationProvider != null && annotationProvider.isSupported(optionalFeature);
            }
        }
        return ServiceFactoryHolder.INSTANCE.getServiceFactory().isSupported(optionalFeature);
    }

    private static final class CachingSingleton {
        public static final CachingSingleton INSTANCE = new CachingSingleton(ServiceFactoryHolder.INSTANCE.getServiceFactory());
        private final HashMap<ClassLoader, HashMap<String, CacheManager>> cacheManagers = new HashMap();
        private final CachingProvider cachingProvider;

        private CachingSingleton(CachingProvider cachingProvider) {
            this.cachingProvider = cachingProvider;
        }

        public CacheManager getCacheManager(String name) {
            ClassLoader cl = this.cachingProvider.getDefaultClassLoader();
            return this.getCacheManager(cl, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CacheManager getCacheManager(ClassLoader classLoader, String name) {
            if (classLoader == null) {
                throw new NullPointerException("classLoader");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            HashMap<ClassLoader, HashMap<String, CacheManager>> hashMap = this.cacheManagers;
            synchronized (hashMap) {
                CacheManager cacheManager;
                HashMap<String, CacheManager> map = this.cacheManagers.get(classLoader);
                if (map == null) {
                    map = new HashMap();
                    this.cacheManagers.put(classLoader, map);
                }
                if ((cacheManager = map.get(name)) == null) {
                    cacheManager = this.cachingProvider.createCacheManager(classLoader, name);
                    map.put(name, cacheManager);
                }
                return cacheManager;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean close() {
            Iterator<HashMap<String, CacheManager>> iterator;
            HashMap<ClassLoader, HashMap<String, CacheManager>> hashMap = this.cacheManagers;
            synchronized (hashMap) {
                iterator = new ArrayList<HashMap<String, CacheManager>>(this.cacheManagers.values()).iterator();
                this.cacheManagers.clear();
            }
            boolean hasElements = iterator.hasNext();
            while (iterator.hasNext()) {
                HashMap<String, CacheManager> cacheManagerMap = iterator.next();
                iterator.remove();
                this.shutdown(cacheManagerMap);
            }
            return hasElements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean close(ClassLoader classLoader) {
            HashMap<String, CacheManager> cacheManagerMap;
            HashMap<ClassLoader, HashMap<String, CacheManager>> hashMap = this.cacheManagers;
            synchronized (hashMap) {
                cacheManagerMap = this.cacheManagers.remove(classLoader);
            }
            if (cacheManagerMap != null) {
                this.shutdown(cacheManagerMap);
            }
            return cacheManagerMap != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean close(ClassLoader classLoader, String name) {
            CacheManager cacheManager;
            HashMap<ClassLoader, HashMap<String, CacheManager>> hashMap = this.cacheManagers;
            synchronized (hashMap) {
                HashMap<String, CacheManager> cacheManagerMap = this.cacheManagers.get(classLoader);
                cacheManager = cacheManagerMap.remove(name);
                if (cacheManagerMap.isEmpty()) {
                    this.cacheManagers.remove(classLoader);
                }
            }
            if (cacheManager != null) {
                this.shutdown(cacheManager);
            }
            return cacheManager != null;
        }

        private void shutdown(Map<String, CacheManager> cacheManagerMap) {
            Iterator<CacheManager> iterator = cacheManagerMap.values().iterator();
            while (iterator.hasNext()) {
                CacheManager cacheManager = iterator.next();
                iterator.remove();
                this.shutdown(cacheManager);
            }
        }

        private void shutdown(CacheManager cacheManager) {
            try {
                cacheManager.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static enum ServiceFactoryHolder {
        INSTANCE;

        private final CachingProvider serviceFactory;
        private final AnnotationProvider annotationProvider;

        private ServiceFactoryHolder() {
            ServiceLoader<CachingProvider> serviceLoader = ServiceLoader.load(CachingProvider.class);
            Iterator<CachingProvider> it = serviceLoader.iterator();
            this.serviceFactory = it.hasNext() ? it.next() : null;
            ServiceLoader<AnnotationProvider> annoationLoader = ServiceLoader.load(AnnotationProvider.class);
            Iterator<AnnotationProvider> annoationLoaderItr = annoationLoader.iterator();
            this.annotationProvider = annoationLoaderItr.hasNext() ? annoationLoaderItr.next() : null;
        }

        public CachingProvider getServiceFactory() {
            if (this.serviceFactory == null) {
                throw new IllegalStateException("No CachingProvider found in classpath.");
            }
            return this.serviceFactory;
        }

        public AnnotationProvider getAnnotationProvider() {
            return this.annotationProvider;
        }
    }
}

