/*
 * Decompiled with CFR 0.152.
 */
package javax.batch.runtime;

import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;

public class BatchRuntime {
    private static final String sourceClass = BatchRuntime.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);

    public static JobOperator getJobOperator() {
        JobOperator operator = null;
        ServiceLoader<JobOperator> loader = ServiceLoader.load(JobOperator.class);
        for (JobOperator provider : loader) {
            if (provider == null) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Loaded BatchContainerServiceProvider with className = " + provider.getClass().getCanonicalName());
            }
            operator = provider;
            break;
        }
        if (operator == null && logger.isLoggable(Level.WARNING)) {
            logger.warning("The ServiceLoader was unable to find an implemenation for JobOperator. Check classpath for META-INF/services/javax.batch.operations.JobOperator file.");
        }
        return operator;
    }
}

