/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;

class SecuritySupport {
    private SecuritySupport() {
    }

    public static URL[] getResources(ClassLoader cl, String name) {
        URL[] ret = null;
        try {
            ArrayList<URL> v = new ArrayList<URL>();
            Enumeration<URL> e = cl.getResources(name);
            while (e != null && e.hasMoreElements()) {
                URL url = e.nextElement();
                if (url == null) continue;
                v.add(url);
            }
            if (v.size() > 0) {
                ret = new URL[v.size()];
                ret = v.toArray(ret);
            }
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        return ret;
    }

    public static URL[] getSystemResources(String name) {
        URL[] ret = null;
        try {
            ArrayList<URL> v = new ArrayList<URL>();
            Enumeration<URL> e = ClassLoader.getSystemResources(name);
            while (e != null && e.hasMoreElements()) {
                URL url = e.nextElement();
                if (url == null) continue;
                v.add(url);
            }
            if (v.size() > 0) {
                ret = new URL[v.size()];
                ret = v.toArray(ret);
            }
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        return ret;
    }
}

