/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.io;

import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectBigArrayBigList;
import it.unimi.dsi.fastutil.objects.ObjectBigList;
import it.unimi.dsi.fastutil.objects.ObjectIterables;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.SafelyCloseable;
import it.unimi.dsi.lang.MutableString;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FileLinesMutableStringIterable
implements Iterable<MutableString>,
Size64 {
    private final String filename;
    private final Charset encoding;
    private final Constructor<? extends InputStream> decompressor;
    private long size = -1L;

    public FileLinesMutableStringIterable(String filename) {
        this(filename, -1L);
    }

    public FileLinesMutableStringIterable(String filename, long size) {
        this(filename, size, Charset.defaultCharset());
    }

    public FileLinesMutableStringIterable(String filename, Charset encoding) {
        this(filename, -1L, encoding);
    }

    public FileLinesMutableStringIterable(String filename, long size, Charset encoding) {
        this.filename = filename;
        this.encoding = encoding;
        this.decompressor = null;
        this.size = size;
    }

    public FileLinesMutableStringIterable(String filename, String encoding) {
        this(filename, -1L, encoding);
    }

    public FileLinesMutableStringIterable(String filename, long size, String encoding) {
        this.filename = filename;
        this.encoding = Charset.forName(encoding);
        this.decompressor = null;
        this.size = size;
    }

    public FileLinesMutableStringIterable(String filename, Class<? extends InputStream> decompressor) throws NoSuchMethodException, SecurityException {
        this(filename, -1L, Charset.defaultCharset(), decompressor);
    }

    public FileLinesMutableStringIterable(String filename, long size, Class<? extends InputStream> decompressor) throws NoSuchMethodException, SecurityException {
        this(filename, size, Charset.defaultCharset(), decompressor);
    }

    public FileLinesMutableStringIterable(String filename, Charset encoding, Class<? extends InputStream> decompressor) throws NoSuchMethodException, SecurityException {
        this(filename, -1L, encoding, decompressor);
    }

    public FileLinesMutableStringIterable(String filename, String encoding, Class<? extends InputStream> decompressor) throws NoSuchMethodException, SecurityException {
        this(filename, -1L, Charset.forName(encoding), decompressor);
    }

    public FileLinesMutableStringIterable(String filename, long size, Charset encoding, Class<? extends InputStream> decompressor) throws NoSuchMethodException, SecurityException {
        this.filename = filename;
        this.encoding = encoding;
        this.decompressor = decompressor != null ? decompressor.getConstructor(InputStream.class) : null;
        this.size = size;
    }

    public FileLinesIterator iterator() {
        try {
            FileInputStream inputStream = this.decompressor == null ? new FileInputStream(this.filename) : this.decompressor.newInstance(new FileInputStream(this.filename));
            return new FileLinesIterator(new FastBufferedReader(new InputStreamReader((InputStream)inputStream, this.encoding)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static FileLinesIterator iterator(InputStream inputStream, Charset encoding) {
        return FileLinesMutableStringIterable.iterator(inputStream, encoding, null);
    }

    public static FileLinesIterator iterator(InputStream inputStream, Charset encoding, Class<? extends InputStream> decompressor) {
        try {
            if (decompressor != null) {
                inputStream = decompressor.getConstructor(InputStream.class).newInstance(inputStream);
            }
            return new FileLinesIterator(new FastBufferedReader(new InputStreamReader(inputStream, encoding)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized long size64() {
        if (this.size == -1L) {
            this.size = ObjectIterables.size((Iterable)this);
        }
        return this.size;
    }

    public ObjectList<String> allLines() {
        ObjectArrayList result = new ObjectArrayList();
        for (MutableString s : this) {
            result.add((Object)s.toString());
        }
        return result;
    }

    public ObjectBigList<String> allLinesBig() {
        ObjectBigArrayBigList result = new ObjectBigArrayBigList();
        for (MutableString s : this) {
            result.add((Object)s.toString());
        }
        return result;
    }

    public static final class FileLinesIterator
    implements Iterator<MutableString>,
    SafelyCloseable {
        private final MutableString s = new MutableString();
        private FastBufferedReader fbr;
        private MutableString next;
        private boolean toAdvance = true;

        private FileLinesIterator(FastBufferedReader fbr) {
            this.fbr = fbr;
        }

        @Override
        public boolean hasNext() {
            if (this.toAdvance) {
                try {
                    this.next = this.fbr.readLine(this.s);
                    if (this.next == null) {
                        this.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.toAdvance = false;
            }
            return this.next != null;
        }

        @Override
        public MutableString next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.s;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void close() {
            if (this.fbr == null) {
                return;
            }
            try {
                this.fbr.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.fbr = null;
            }
        }

        protected synchronized void finalize() throws Throwable {
            try {
                if (this.fbr != null) {
                    this.close();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

