/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.test;

import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;

public class LeastSignificantBitSpeedTest {
    private static final int[] LEAST_SIGNIFICANT_BIT = new int[]{-1, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
    private static final byte[] LSB_TABLE = new byte[]{0, 1, 56, 2, 57, 49, 28, 3, 61, 58, 42, 50, 38, 29, 17, 4, 62, 47, 59, 36, 45, 43, 51, 22, 53, 39, 33, 30, 24, 18, 12, 5, 63, 55, 48, 27, 60, 41, 37, 16, 46, 35, 44, 21, 52, 32, 23, 11, 54, 26, 40, 15, 34, 20, 31, 10, 25, 14, 19, 9, 13, 8, 7, 6};

    public static int leastSignificantBit(long value) {
        if (value == 0L) {
            return -1;
        }
        if ((value & 0xFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 0 & 0xFFL)] + 0;
        }
        if ((value & 0xFFFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 8 & 0xFFL)] + 8;
        }
        if ((value & 0xFFFFFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 16 & 0xFFL)] + 16;
        }
        if ((value & 0xFFFFFFFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 24 & 0xFFL)] + 24;
        }
        if ((value & 0xFFFFFFFFFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 32 & 0xFFL)] + 32;
        }
        if ((value & 0xFFFFFFFFFFFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 40 & 0xFFL)] + 40;
        }
        if ((value & 0xFFFFFFFFFFFFFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 48 & 0xFFL)] + 48;
        }
        return LEAST_SIGNIFICANT_BIT[(int)(value >>> 56 & 0xFFL)] + 56;
    }

    public static int javaLsb(long value) {
        return value == 0L ? -1 : Long.numberOfTrailingZeros(value);
    }

    private static int deBrujin(long x) {
        return LSB_TABLE[(int)((x & -x) * 285870213051353865L >>> 58)];
    }

    public static void main(String[] a) {
        int n = Integer.parseInt(a[0]);
        XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator(1L);
        int x = 42;
        long[] value = new long[n];
        int i = n;
        while (i-- != 0) {
            value[i] = r.nextLong();
        }
        int k = 10;
        while (k-- != 0) {
            System.out.print("Java: ");
            long start = System.nanoTime();
            int i2 = n;
            while (i2-- != 0) {
                x ^= LeastSignificantBitSpeedTest.javaLsb(value[i2]);
            }
            long elapsed = System.nanoTime() - start;
            System.out.println("elapsed " + elapsed + ", " + (double)elapsed / (double)n + " ns/call");
            System.out.print("Test-based: ");
            start = System.nanoTime();
            i2 = n;
            while (i2-- != 0) {
                x ^= LeastSignificantBitSpeedTest.leastSignificantBit(value[i2]);
            }
            elapsed = System.nanoTime() - start;
            System.out.println("elapsed " + elapsed + ", " + (double)elapsed / (double)n + " ns/call");
            System.out.print("De Brujin: ");
            start = System.nanoTime();
            i2 = n;
            while (i2-- != 0) {
                x ^= LeastSignificantBitSpeedTest.deBrujin(value[i2]);
            }
            elapsed = System.nanoTime() - start;
            System.out.println("elapsed " + elapsed + ", " + (double)elapsed / (double)n + " ns/call");
        }
        if (x == 0) {
            System.out.println(0);
        }
    }
}

