/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.compression;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.compression.PrefixCoder;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanIterators;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;
import java.io.Serializable;

public class CodeWordCoder
implements PrefixCoder,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final BitVector[] codeWord;

    public CodeWordCoder(BitVector[] codeWord) {
        this.codeWord = codeWord;
    }

    @Override
    public BooleanIterator encode(int symbol) {
        return this.codeWord[symbol].iterator();
    }

    @Override
    public int encode(int symbol, OutputBitStream obs) throws IOException {
        BitVector w = this.codeWord[symbol];
        int length = (int)w.length();
        for (int i = 0; i < length; ++i) {
            obs.writeBit(w.getBoolean(i));
        }
        return length;
    }

    @Override
    public int flush(OutputBitStream unused) {
        return 0;
    }

    @Override
    public BooleanIterator flush() {
        return BooleanIterators.EMPTY_ITERATOR;
    }

    @Override
    public BitVector[] codeWords() {
        return this.codeWord;
    }
}

