/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.SplitMix64Random;
import it.unimi.dsi.util.StringMap;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;

public class StringMapSpeedTest {
    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(StringMapSpeedTest.class.getName(), "Test the speed of a string map", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read terms."), new FlaggedOption("n", (StringParser)JSAP.INTSIZE_PARSER, "1000000", false, 'n', "number-of-strings", "The (maximum) number of strings used for random testing."), new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The term file encoding."), new FlaggedOption("save", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 's', "save", "In case of random test, save to this file the strings used."), new Switch("zipped", 'z', "zipped", "The term list is compressed in gzip format."), new Switch("random", 'r', "random", "Do a random test on at most 1 million strings."), new Switch("check", 'c', "check", "Check that the term list is mapped to its ordinal position."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised function."), new UnflaggedOption("termFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "Read terms from this file.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String termFile = jsapResult.getString("termFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean check = jsapResult.getBoolean("check");
        boolean random = jsapResult.getBoolean("random");
        String save = jsapResult.getString("save");
        int maxStrings = jsapResult.getInt("n");
        if (save != null && !random) {
            throw new IllegalArgumentException("You can save test string only for random tests");
        }
        StringMap function = (StringMap)BinIO.loadObject((CharSequence)functionName);
        FileLinesCollection flc = new FileLinesCollection(termFile, encoding.name(), zipped);
        if (random) {
            ObjectList<MutableString> fll = new FileLinesCollection(termFile, encoding.name()).allLines();
            int size = fll.size();
            int n = Math.min(maxStrings, size);
            MutableString[] test = new MutableString[n];
            int step = size / n;
            for (int i = 0; i < n; ++i) {
                test[i] = (MutableString)fll.get(i * step);
            }
            Collections.shuffle(Arrays.asList(test));
            if (save != null) {
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(save)), encoding));
                for (MutableString s : test) {
                    s.println(pw);
                }
                pw.close();
            }
            System.out.println("== From string to integer ==");
            long total = 0L;
            int k = 13;
            while (k-- != 0) {
                long time = -System.nanoTime();
                for (int i = 0; i < n; ++i) {
                    function.getLong(test[i]);
                    if (i % 100000 != 0) continue;
                    System.out.print('.');
                }
                System.out.println();
                time += System.nanoTime();
                if (k < 10) {
                    total += time;
                }
                System.out.println((double)time / 1.0E9 + "s, " + time / (long)n + " ns/item");
            }
            System.out.println("Average: " + Util.format((double)total / 1.0E9) + "s, " + Util.format(total / (long)(10 * n)) + " ns/item");
            System.out.println("== From integer to string ==");
            total = 0L;
            ObjectList list = function.list();
            int[] index = new int[n];
            int i = n - 1;
            while (i-- != 0) {
                index[i] = index[i + 1] + step;
            }
            IntArrays.shuffle((int[])index, (Random)new SplitMix64Random());
            int k2 = 13;
            while (k2-- != 0) {
                long time = -System.nanoTime();
                for (int i2 = 0; i2 < n; ++i2) {
                    list.get(index[i2]);
                    if (i2 % 100000 != 0) continue;
                    System.out.print('.');
                }
                System.out.println();
                time += System.nanoTime();
                if (k2 < 10) {
                    total += time;
                }
                System.out.println(Util.format((double)time / 1.0E9) + "s, " + Util.format((double)time / (double)n) + " ns/item");
            }
            System.out.println("Average: " + Util.format((double)total / 1.0E10) + "s, " + Util.format(total / (long)(10 * n)) + " ns/item");
        } else {
            int size = 0;
            long total = 0L;
            int k = 13;
            while (k-- != 0) {
                FileLinesCollection.FileLinesIterator i = flc.iterator();
                long time = -System.nanoTime();
                int j = 0;
                while (i.hasNext()) {
                    long index = function.getLong(i.next());
                    if (check && index != (long)j) {
                        throw new AssertionError((Object)(index + " != " + j));
                    }
                    if (j++ % 10000 != 0) continue;
                    System.err.print('.');
                }
                size = j;
                System.err.println();
                time += System.nanoTime();
                if (k < 10) {
                    total += time;
                }
                System.err.println(Util.format((double)total / 1.0E9) + "s, " + Util.format((double)total / 1.0E9 / (double)j) + " ns/item");
            }
            System.out.println("Average: " + Util.format((double)total / 1.0E10) + "s, " + Util.format(total / (long)(10 * size)) + " ns/item");
        }
    }
}

