/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.AbstractBitVector;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.lang.MutableString;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class TransformationStrategies {
    private static final TransformationStrategy<BitVector> IDENTITY = new TransformationStrategy<BitVector>(){
        private static final long serialVersionUID = 1L;

        @Override
        public BitVector toBitVector(BitVector v) {
            return v;
        }

        @Override
        public long length(BitVector v) {
            return v.length();
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<BitVector> copy() {
            return this;
        }

        public Object readResolve() {
            return IDENTITY;
        }
    };
    private static final TransformationStrategy<CharSequence> RAW_UTF32 = new RawUtf32TransformationStrategy();
    private static final TransformationStrategy<CharSequence> UTF32 = new Utf32TransformationStrategy(false);
    private static final TransformationStrategy<CharSequence> PREFIX_FREE_UTF32 = new Utf32TransformationStrategy(true);
    private static final TransformationStrategy<CharSequence> RAW_UTF16 = new RawUtf16TransformationStrategy();
    private static final TransformationStrategy<CharSequence> UTF16 = new Utf16TransformationStrategy(false);
    private static final TransformationStrategy<CharSequence> PREFIX_FREE_UTF16 = new Utf16TransformationStrategy(true);
    private static final TransformationStrategy<CharSequence> RAW_ISO = new RawISOTransformationStrategy();
    private static final TransformationStrategy<CharSequence> ISO = new ISOTransformationStrategy(false);
    private static final TransformationStrategy<CharSequence> PREFIX_FREE_ISO = new ISOTransformationStrategy(true);
    private static final TransformationStrategy<byte[]> RAW_BYTE_ARRAY = new RawByteArrayTransformationStrategy();
    private static final TransformationStrategy<byte[]> BYTE_ARRAY = new ByteArrayTransformationStrategy();
    private static final TransformationStrategy<? extends BitVector> PREFIX_FREE = new PrefixFreeTransformationStrategy();
    private static final FixedLongTransformationStrategy FIXED_LONG = new FixedLongTransformationStrategy(true);
    private static final FixedLongTransformationStrategy RAW_FIXED_LONG = new FixedLongTransformationStrategy(false);

    private static final long reverseBytes(long word) {
        word = (word & 0x5555555555555555L) << 1 | word >>> 1 & 0x5555555555555555L;
        word = (word & 0x3333333333333333L) << 2 | word >>> 2 & 0x3333333333333333L;
        return (word & 0xF0F0F0F0F0F0F0FL) << 4 | word >>> 4 & 0xF0F0F0F0F0F0F0FL;
    }

    private static final long reverseChars(long word) {
        word = (word & 0x5555555555555555L) << 1 | word >>> 1 & 0x5555555555555555L;
        word = (word & 0x3333333333333333L) << 2 | word >>> 2 & 0x3333333333333333L;
        word = (word & 0xF0F0F0F0F0F0F0FL) << 4 | word >>> 4 & 0xF0F0F0F0F0F0F0FL;
        return (word & 0xFF00FF00FF00FFL) << 8 | word >>> 8 & 0xFF00FF00FF00FFL;
    }

    public static <T extends BitVector> TransformationStrategy<T> identity() {
        return IDENTITY;
    }

    public static <T extends CharSequence> TransformationStrategy<T> rawUtf32() {
        return RAW_UTF32;
    }

    public static <T extends CharSequence> TransformationStrategy<T> utf32() {
        return UTF32;
    }

    public static <T extends CharSequence> TransformationStrategy<T> prefixFreeUtf32() {
        return PREFIX_FREE_UTF32;
    }

    public static <T extends CharSequence> TransformationStrategy<T> rawUtf16() {
        return RAW_UTF16;
    }

    public static <T extends CharSequence> TransformationStrategy<T> utf16() {
        return UTF16;
    }

    public static <T extends CharSequence> TransformationStrategy<T> prefixFreeUtf16() {
        return PREFIX_FREE_UTF16;
    }

    public static <T extends CharSequence> TransformationStrategy<T> rawIso() {
        return RAW_ISO;
    }

    public static <T extends CharSequence> TransformationStrategy<T> iso() {
        return ISO;
    }

    public static <T extends CharSequence> TransformationStrategy<T> prefixFreeIso() {
        return PREFIX_FREE_ISO;
    }

    public static TransformationStrategy<byte[]> rawByteArray() {
        return RAW_BYTE_ARRAY;
    }

    public static TransformationStrategy<byte[]> byteArray() {
        return BYTE_ARRAY;
    }

    public static <T> Iterator<BitVector> wrap(Iterator<T> iterator, TransformationStrategy<? super T> transformationStrategy) {
        return transformationStrategy == IDENTITY ? iterator : new IteratorWrapper<T>(iterator, transformationStrategy);
    }

    public static <T> Iterable<BitVector> wrap(Iterable<T> iterable, TransformationStrategy<? super T> transformationStrategy) {
        return transformationStrategy == IDENTITY ? iterable : new IterableWrapper<T>(iterable, transformationStrategy);
    }

    public static <T> List<BitVector> wrap(List<T> list, TransformationStrategy<? super T> transformationStrategy) {
        return transformationStrategy == IDENTITY ? list : new ListWrapper<T>(list, transformationStrategy);
    }

    public static <T extends BitVector> TransformationStrategy<T> prefixFree() {
        return PREFIX_FREE;
    }

    public static TransformationStrategy<Long> fixedLong() {
        return FIXED_LONG;
    }

    public static TransformationStrategy<Long> rawFixedLong() {
        return RAW_FIXED_LONG;
    }

    private static class FixedLongTransformationStrategy
    implements TransformationStrategy<Long>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final boolean lexicographical;

        public FixedLongTransformationStrategy(boolean lexicographical) {
            this.lexicographical = lexicographical;
        }

        @Override
        public BitVector toBitVector(Long v) {
            return new FixedLongBitVector(this.lexicographical ? Long.reverse(v) : v);
        }

        @Override
        public long length(Long v) {
            return 64L;
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<Long> copy() {
            return this;
        }

        private Object readResolve() {
            return FIXED_LONG;
        }

        private static class FixedLongBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final long v;

            public FixedLongBitVector(long v) {
                this.v = v;
            }

            @Override
            public boolean getBoolean(long index) {
                if (index >= 64L) {
                    throw new IndexOutOfBoundsException();
                }
                return (this.v & 1L << (int)index) != 0L;
            }

            @Override
            public long getLong(long from, long to) {
                if (from == 0L && to == 64L) {
                    return this.v;
                }
                return this.v >> (int)from & (1L << (int)(to - from)) - 1L;
            }

            @Override
            public long length() {
                return 64L;
            }
        }
    }

    private static class PrefixFreeTransformationStrategy
    implements TransformationStrategy<BitVector>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PrefixFreeTransformationStrategy() {
        }

        @Override
        public BitVector toBitVector(BitVector v) {
            return new PrefixFreeBitVector(v);
        }

        @Override
        public long length(BitVector v) {
            return v.length() * 2L + 1L;
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<BitVector> copy() {
            return this;
        }

        private Object readResolve() {
            return PREFIX_FREE;
        }

        private static class PrefixFreeBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final BitVector v;
            private final long length;

            public PrefixFreeBitVector(BitVector v) {
                this.v = v;
                this.length = v.length() * 2L + 1L;
            }

            @Override
            public boolean getBoolean(long index) {
                if (index >= this.length) {
                    throw new IndexOutOfBoundsException();
                }
                if (index == this.length - 1L) {
                    return false;
                }
                if (index % 2L == 0L) {
                    return true;
                }
                return this.v.getBoolean(index / 2L);
            }

            @Override
            public long getLong(long from, long to) {
                if (from % 64L == 0L) {
                    if (to == from + 64L) {
                        long word = this.v.getLong(from / 2L, from / 2L + 32L);
                        word = (word | word << 16) & 0xFFFF0000FFFFL;
                        word = (word | word << 8) & 0xFF00FF00FF00FFL;
                        word = (word | word << 4) & 0xF0F0F0F0F0F0F0FL;
                        word = (word | word << 2) & 0x3333333333333333L;
                        word = word << 1 | word << 2 | 0x5555555555555555L;
                        return word;
                    }
                    if (to == this.length) {
                        assert (from < to);
                        long word = this.v.getLong(from / 2L, to / 2L);
                        word = (word | word << 16) & 0xFFFF0000FFFFL;
                        word = (word | word << 8) & 0xFF00FF00FF00FFL;
                        word = (word | word << 4) & 0xF0F0F0F0F0F0F0FL;
                        word = (word | word << 2) & 0x3333333333333333L;
                        return word << 1 | word << 2 | 0x5555555555555555L & (1L << (int)(to - from - 1L)) - 1L;
                    }
                }
                return super.getLong(from, to);
            }

            @Override
            public long length() {
                return this.length;
            }
        }
    }

    private static final class ListWrapper<T>
    extends AbstractObjectList<BitVector> {
        private final TransformationStrategy<? super T> transformationStrategy;
        private final List<T> list;

        public ListWrapper(List<T> list, TransformationStrategy<? super T> transformationStrategy) {
            this.list = list;
            this.transformationStrategy = transformationStrategy;
        }

        public BitVector get(int index) {
            return this.transformationStrategy.toBitVector(this.list.get(index));
        }

        public int size() {
            return this.list.size();
        }
    }

    private static final class IterableWrapper<T>
    implements Iterable<BitVector> {
        private final TransformationStrategy<? super T> transformationStrategy;
        private final Iterable<T> collection;

        public IterableWrapper(Iterable<T> collection, TransformationStrategy<? super T> transformationStrategy) {
            this.collection = collection;
            this.transformationStrategy = transformationStrategy;
        }

        @Override
        public ObjectIterator<BitVector> iterator() {
            return new IteratorWrapper<T>(this.collection.iterator(), this.transformationStrategy.copy());
        }
    }

    private static final class IteratorWrapper<T>
    extends AbstractObjectIterator<BitVector> {
        final Iterator<T> iterator;
        final TransformationStrategy<? super T> transformationStrategy;

        public IteratorWrapper(Iterator<T> iterator, TransformationStrategy<? super T> transformationStrategy) {
            this.iterator = iterator;
            this.transformationStrategy = transformationStrategy;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public BitVector next() {
            return this.transformationStrategy.toBitVector(this.iterator.next());
        }
    }

    private static class ByteArrayTransformationStrategy
    implements TransformationStrategy<byte[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ByteArrayTransformationStrategy() {
        }

        @Override
        public long length(byte[] a) {
            return (long)a.length * 8L;
        }

        @Override
        public BitVector toBitVector(byte[] s) {
            return new ByteArrayBitVector(s);
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<byte[]> copy() {
            return this;
        }

        private Object readResolve() {
            return BYTE_ARRAY;
        }

        private static class ByteArrayBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 0L;
            private final byte[] a;
            private final long length;

            public ByteArrayBitVector(byte[] a) {
                this.a = a;
                this.length = (long)a.length * 8L;
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                return (this.a[(int)(index / 8L)] & 128 >> (int)(index % 8L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 8L);
                if (startBit == 0) {
                    if (to == from + 64L) {
                        int pos = (int)(from / 8L);
                        return TransformationStrategies.reverseBytes(((long)this.a[pos + 7] & 0xFFL) << 56 | ((long)this.a[pos + 6] & 0xFFL) << 48 | ((long)this.a[pos + 5] & 0xFFL) << 40 | ((long)this.a[pos + 4] & 0xFFL) << 32 | ((long)this.a[pos + 3] & 0xFFL) << 24 | (long)((this.a[pos + 2] & 0xFF) << 16) | (long)((this.a[pos + 1] & 0xFF) << 8) | (long)(this.a[pos] & 0xFF));
                    }
                    if (to % 8L == 0L) {
                        int pos = (int)(from / 8L);
                        long word = 0L;
                        switch ((int)((to - from) / 8L)) {
                            case 7: {
                                word |= ((long)this.a[pos + 6] & 0xFFL) << 48;
                            }
                            case 6: {
                                word |= ((long)this.a[pos + 5] & 0xFFL) << 40;
                            }
                            case 5: {
                                word |= ((long)this.a[pos + 4] & 0xFFL) << 32;
                            }
                            case 4: {
                                word |= ((long)this.a[pos + 3] & 0xFFL) << 24;
                            }
                            case 3: {
                                word |= (long)((this.a[pos + 2] & 0xFF) << 16);
                            }
                            case 2: {
                                word |= (long)((this.a[pos + 1] & 0xFF) << 8);
                            }
                            case 1: {
                                word |= (long)(this.a[pos] & 0xFF);
                            }
                        }
                        return TransformationStrategies.reverseBytes(word);
                    }
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }
    }

    private static class RawByteArrayTransformationStrategy
    implements TransformationStrategy<byte[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private RawByteArrayTransformationStrategy() {
        }

        @Override
        public long length(byte[] a) {
            return (long)a.length * 8L;
        }

        @Override
        public BitVector toBitVector(byte[] s) {
            return new RawByteArrayBitVector(s);
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<byte[]> copy() {
            return this;
        }

        private Object readResolve() {
            return RAW_BYTE_ARRAY;
        }

        private static class RawByteArrayBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 0L;
            private final byte[] a;
            private final long length;

            public RawByteArrayBitVector(byte[] a) {
                this.a = a;
                this.length = (long)a.length * 8L;
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                return (this.a[(int)(index / 8L)] & 1 << (int)(index % 8L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 8L);
                if (startBit == 0) {
                    if (to == from + 64L) {
                        int pos = (int)(from / 8L);
                        return ((long)this.a[pos + 7] & 0xFFL) << 56 | ((long)this.a[pos + 6] & 0xFFL) << 48 | ((long)this.a[pos + 5] & 0xFFL) << 40 | ((long)this.a[pos + 4] & 0xFFL) << 32 | ((long)this.a[pos + 3] & 0xFFL) << 24 | (long)((this.a[pos + 2] & 0xFF) << 16) | (long)((this.a[pos + 1] & 0xFF) << 8) | (long)(this.a[pos] & 0xFF);
                    }
                    if (to % 8L == 0L) {
                        int pos = (int)(from / 8L);
                        long word = 0L;
                        switch ((int)((to - from) / 8L)) {
                            case 7: {
                                word |= ((long)this.a[pos + 6] & 0xFFL) << 48;
                            }
                            case 6: {
                                word |= ((long)this.a[pos + 5] & 0xFFL) << 40;
                            }
                            case 5: {
                                word |= ((long)this.a[pos + 4] & 0xFFL) << 32;
                            }
                            case 4: {
                                word |= ((long)this.a[pos + 3] & 0xFFL) << 24;
                            }
                            case 3: {
                                word |= (long)((this.a[pos + 2] & 0xFF) << 16);
                            }
                            case 2: {
                                word |= (long)((this.a[pos + 1] & 0xFF) << 8);
                            }
                            case 1: {
                                word |= (long)(this.a[pos] & 0xFF);
                            }
                        }
                        return word;
                    }
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }
    }

    private static class ISOTransformationStrategy
    implements TransformationStrategy<CharSequence>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean prefixFree;

        protected ISOTransformationStrategy(boolean prefixFree) {
            this.prefixFree = prefixFree;
        }

        @Override
        public long length(CharSequence s) {
            return (long)(s.length() + (this.prefixFree ? 1 : 0)) * 8L;
        }

        @Override
        public BitVector toBitVector(CharSequence s) {
            return s instanceof MutableString ? new ISOMutableStringBitVector((MutableString)s, this.prefixFree) : new ISOCharSequenceBitVector(s, this.prefixFree);
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<CharSequence> copy() {
            return this;
        }

        private Object readResolve() {
            return this.prefixFree ? PREFIX_FREE_ISO : ISO;
        }

        private static class ISOMutableStringBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final char[] a;
            private final long length;
            private final long actualEnd;

            public ISOMutableStringBitVector(MutableString s, boolean prefixFree) {
                this.a = s.array();
                this.actualEnd = (long)s.length() * 8L;
                this.length = this.actualEnd + (long)(prefixFree ? 8 : 0);
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                if (index >= this.actualEnd) {
                    return false;
                }
                int byteIndex = (int)(index / 8L);
                return (this.a[byteIndex] & 128 >>> (int)(index % 8L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 8L);
                if (startBit == 0) {
                    int pos = (int)(from / 8L);
                    if (to == from + 64L) {
                        return TransformationStrategies.reverseBytes((to > this.actualEnd ? 0L : (long)this.a[pos + 7] & 0xFFL) << 56 | ((long)this.a[pos + 6] & 0xFFL) << 48 | ((long)this.a[pos + 5] & 0xFFL) << 40 | ((long)this.a[pos + 4] & 0xFFL) << 32 | ((long)this.a[pos + 3] & 0xFFL) << 24 | (long)((this.a[pos + 2] & 0xFF) << 16) | (long)((this.a[pos + 1] & 0xFF) << 8) | (long)(this.a[pos] & 0xFF));
                    }
                    if (to % 8L == 0L) {
                        long word = 0L;
                        switch ((int)((Math.min(this.actualEnd, to) - Math.min(this.actualEnd, from)) / 8L)) {
                            case 7: {
                                word |= ((long)this.a[pos + 6] & 0xFFL) << 48;
                            }
                            case 6: {
                                word |= ((long)this.a[pos + 5] & 0xFFL) << 40;
                            }
                            case 5: {
                                word |= ((long)this.a[pos + 4] & 0xFFL) << 32;
                            }
                            case 4: {
                                word |= ((long)this.a[pos + 3] & 0xFFL) << 24;
                            }
                            case 3: {
                                word |= (long)((this.a[pos + 2] & 0xFF) << 16);
                            }
                            case 2: {
                                word |= (long)((this.a[pos + 1] & 0xFF) << 8);
                            }
                            case 1: {
                                word |= (long)(this.a[pos] & 0xFF);
                            }
                        }
                        return TransformationStrategies.reverseBytes(word);
                    }
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }

        private static class ISOCharSequenceBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final CharSequence s;
            private final long length;
            private final long actualEnd;

            public ISOCharSequenceBitVector(CharSequence s, boolean prefixFree) {
                this.s = s;
                this.actualEnd = (long)s.length() * 8L;
                this.length = this.actualEnd + (long)(prefixFree ? 8 : 0);
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                if (index >= this.actualEnd) {
                    return false;
                }
                int byteIndex = (int)(index / 8L);
                return (this.s.charAt(byteIndex) & 128 >>> (int)(index % 8L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 8L);
                if (startBit == 0) {
                    int pos = (int)(from / 8L);
                    if (to == from + 64L) {
                        return TransformationStrategies.reverseBytes((to > this.actualEnd ? 0L : (long)this.s.charAt(pos + 7) & 0xFFL) << 56 | ((long)this.s.charAt(pos + 6) & 0xFFL) << 48 | ((long)this.s.charAt(pos + 5) & 0xFFL) << 40 | ((long)this.s.charAt(pos + 4) & 0xFFL) << 32 | ((long)this.s.charAt(pos + 3) & 0xFFL) << 24 | (long)((this.s.charAt(pos + 2) & 0xFF) << 16) | (long)((this.s.charAt(pos + 1) & 0xFF) << 8) | (long)(this.s.charAt(pos) & 0xFF));
                    }
                    if (to % 8L == 0L) {
                        long word = 0L;
                        switch ((int)((Math.min(to, this.actualEnd) - Math.min(from, this.actualEnd)) / 8L)) {
                            case 7: {
                                word |= ((long)this.s.charAt(pos + 6) & 0xFFL) << 48;
                            }
                            case 6: {
                                word |= ((long)this.s.charAt(pos + 5) & 0xFFL) << 40;
                            }
                            case 5: {
                                word |= ((long)this.s.charAt(pos + 4) & 0xFFL) << 32;
                            }
                            case 4: {
                                word |= ((long)this.s.charAt(pos + 3) & 0xFFL) << 24;
                            }
                            case 3: {
                                word |= (long)((this.s.charAt(pos + 2) & 0xFF) << 16);
                            }
                            case 2: {
                                word |= (long)((this.s.charAt(pos + 1) & 0xFF) << 8);
                            }
                            case 1: {
                                word |= (long)(this.s.charAt(pos) & 0xFF);
                            }
                        }
                        return TransformationStrategies.reverseBytes(word);
                    }
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }
    }

    private static class RawISOTransformationStrategy
    implements TransformationStrategy<CharSequence>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private RawISOTransformationStrategy() {
        }

        @Override
        public long length(CharSequence s) {
            return (long)s.length() * 8L;
        }

        @Override
        public BitVector toBitVector(CharSequence s) {
            return s instanceof MutableString ? new RawISOMutableStringBitVector((MutableString)s) : new RawISOCharSequenceBitVector(s);
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<CharSequence> copy() {
            return this;
        }

        private Object readResolve() {
            return RAW_ISO;
        }

        private static class RawISOMutableStringBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final char[] a;
            private final long length;

            public RawISOMutableStringBitVector(MutableString s) {
                this.a = s.array();
                this.length = (long)s.length() * 8L;
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                int byteIndex = (int)(index / 8L);
                return (this.a[byteIndex] & 1 << (int)(index % 8L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 8L);
                if (startBit == 0) {
                    int pos = (int)(from / 8L);
                    if (to == from + 64L) {
                        return ((long)this.a[pos + 7] & 0xFFL) << 56 | ((long)this.a[pos + 6] & 0xFFL) << 48 | ((long)this.a[pos + 5] & 0xFFL) << 40 | ((long)this.a[pos + 4] & 0xFFL) << 32 | ((long)this.a[pos + 3] & 0xFFL) << 24 | (long)((this.a[pos + 2] & 0xFF) << 16) | (long)((this.a[pos + 1] & 0xFF) << 8) | (long)(this.a[pos] & 0xFF);
                    }
                    if (to % 8L == 0L) {
                        long word = 0L;
                        switch ((int)((to - from) / 8L)) {
                            case 7: {
                                word |= ((long)this.a[pos + 6] & 0xFFL) << 48;
                            }
                            case 6: {
                                word |= ((long)this.a[pos + 5] & 0xFFL) << 40;
                            }
                            case 5: {
                                word |= ((long)this.a[pos + 4] & 0xFFL) << 32;
                            }
                            case 4: {
                                word |= ((long)this.a[pos + 3] & 0xFFL) << 24;
                            }
                            case 3: {
                                word |= (long)((this.a[pos + 2] & 0xFF) << 16);
                            }
                            case 2: {
                                word |= (long)((this.a[pos + 1] & 0xFF) << 8);
                            }
                            case 1: {
                                word |= (long)(this.a[pos] & 0xFF);
                            }
                        }
                        return word;
                    }
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }

        private static class RawISOCharSequenceBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final CharSequence s;
            private final long length;

            public RawISOCharSequenceBitVector(CharSequence s) {
                this.s = s;
                this.length = (long)s.length() * 8L;
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                int byteIndex = (int)(index / 8L);
                return (this.s.charAt(byteIndex) & 1 << (int)(index % 8L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 8L);
                if (startBit == 0) {
                    int pos = (int)(from / 8L);
                    if (to == from + 64L) {
                        return ((long)this.s.charAt(pos + 7) & 0xFFL) << 56 | ((long)this.s.charAt(pos + 6) & 0xFFL) << 48 | ((long)this.s.charAt(pos + 5) & 0xFFL) << 40 | ((long)this.s.charAt(pos + 4) & 0xFFL) << 32 | ((long)this.s.charAt(pos + 3) & 0xFFL) << 24 | (long)((this.s.charAt(pos + 2) & 0xFF) << 16) | (long)((this.s.charAt(pos + 1) & 0xFF) << 8) | (long)(this.s.charAt(pos) & 0xFF);
                    }
                    if (to % 8L == 0L) {
                        long word = 0L;
                        switch ((int)((to - from) / 8L)) {
                            case 7: {
                                word |= ((long)this.s.charAt(pos + 6) & 0xFFL) << 48;
                            }
                            case 6: {
                                word |= ((long)this.s.charAt(pos + 5) & 0xFFL) << 40;
                            }
                            case 5: {
                                word |= ((long)this.s.charAt(pos + 4) & 0xFFL) << 32;
                            }
                            case 4: {
                                word |= ((long)this.s.charAt(pos + 3) & 0xFFL) << 24;
                            }
                            case 3: {
                                word |= (long)((this.s.charAt(pos + 2) & 0xFF) << 16);
                            }
                            case 2: {
                                word |= (long)((this.s.charAt(pos + 1) & 0xFF) << 8);
                            }
                            case 1: {
                                word |= (long)(this.s.charAt(pos) & 0xFF);
                            }
                        }
                        return word;
                    }
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }
    }

    private static class Utf16TransformationStrategy
    implements TransformationStrategy<CharSequence>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean prefixFree;

        protected Utf16TransformationStrategy(boolean prefixFree) {
            this.prefixFree = prefixFree;
        }

        @Override
        public long length(CharSequence s) {
            return (long)(s.length() + (this.prefixFree ? 1 : 0)) * 16L;
        }

        @Override
        public BitVector toBitVector(CharSequence s) {
            return s instanceof MutableString ? new Utf16MutableStringBitVector((MutableString)s, this.prefixFree) : new Utf16CharSequenceBitVector(s, this.prefixFree);
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<CharSequence> copy() {
            return this;
        }

        private Object readResolve() {
            return this.prefixFree ? PREFIX_FREE_UTF16 : UTF16;
        }

        private static class Utf16MutableStringBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final char[] a;
            private final long length;
            private final long actualEnd;

            public Utf16MutableStringBitVector(MutableString s, boolean prefixFree) {
                this.a = s.array();
                this.actualEnd = (long)s.length() * 16L;
                this.length = this.actualEnd + (long)(prefixFree ? 16 : 0);
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                if (index >= this.actualEnd) {
                    return false;
                }
                int charIndex = (int)(index / 16L);
                return (this.a[charIndex] & 32768 >>> (int)(index % 16L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 16L);
                if (startBit == 0) {
                    int pos = (int)(from / 16L);
                    if (to == from + 64L) {
                        return TransformationStrategies.reverseChars((to > this.actualEnd ? 0L : (long)this.a[pos + 3]) << 48 | (long)this.a[pos + 2] << 32 | (long)this.a[pos + 1] << 16 | (long)this.a[pos]);
                    }
                    if (to % 16L == 0L) {
                        long word = 0L;
                        switch ((int)((Math.min(to, this.actualEnd) - Math.min(from, this.actualEnd)) / 16L)) {
                            case 3: {
                                word |= (long)this.a[pos + 2] << 32;
                            }
                            case 2: {
                                word |= (long)this.a[pos + 1] << 16;
                            }
                            case 1: {
                                word |= (long)this.a[pos];
                            }
                        }
                        return TransformationStrategies.reverseChars(word);
                    }
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }

        private static class Utf16CharSequenceBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final CharSequence s;
            private final long length;
            private final long actualEnd;

            public Utf16CharSequenceBitVector(CharSequence s, boolean prefixFree) {
                this.s = s;
                this.actualEnd = (long)s.length() * 16L;
                this.length = this.actualEnd + (long)(prefixFree ? 16 : 0);
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                if (index >= this.actualEnd) {
                    return false;
                }
                int charIndex = (int)(index / 16L);
                return (this.s.charAt(charIndex) & 32768 >>> (int)(index % 16L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 16L);
                if (startBit == 0) {
                    int pos = (int)(from / 16L);
                    if (to == from + 64L) {
                        return TransformationStrategies.reverseChars((to > this.actualEnd ? 0L : (long)this.s.charAt(pos + 3)) << 48 | (long)this.s.charAt(pos + 2) << 32 | (long)this.s.charAt(pos + 1) << 16 | (long)this.s.charAt(pos));
                    }
                    if (to % 16L == 0L) {
                        long word = 0L;
                        switch ((int)((Math.min(to, this.actualEnd) - Math.min(from, this.actualEnd)) / 16L)) {
                            case 3: {
                                word |= (long)this.s.charAt(pos + 2) << 32;
                            }
                            case 2: {
                                word |= (long)this.s.charAt(pos + 1) << 16;
                            }
                            case 1: {
                                word |= (long)this.s.charAt(pos);
                            }
                        }
                        return TransformationStrategies.reverseChars(word);
                    }
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }
    }

    private static class RawUtf16TransformationStrategy
    implements TransformationStrategy<CharSequence>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private RawUtf16TransformationStrategy() {
        }

        @Override
        public long length(CharSequence s) {
            return (long)s.length() * 16L;
        }

        @Override
        public BitVector toBitVector(CharSequence s) {
            return s instanceof MutableString ? new RawUtf16MutableStringBitVector((MutableString)s) : new RawUtf16CharSequenceBitVector(s);
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<CharSequence> copy() {
            return this;
        }

        private Object readResolve() {
            return RAW_UTF16;
        }

        private static class RawUtf16CharSequenceBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final CharSequence s;
            private final long length;

            public RawUtf16CharSequenceBitVector(CharSequence s) {
                this.s = s;
                this.length = (long)s.length() * 16L;
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                int charIndex = (int)(index / 16L);
                return (this.s.charAt(charIndex) & 1 << (int)(index % 16L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 16L);
                if (startBit == 0) {
                    int pos = (int)(from / 16L);
                    if (to == from + 64L) {
                        return (long)this.s.charAt(pos + 3) << 48 | (long)this.s.charAt(pos + 2) << 32 | (long)this.s.charAt(pos + 1) << 16 | (long)this.s.charAt(pos);
                    }
                    if (to % 16L == 0L) {
                        long word = 0L;
                        switch ((int)((to - from) / 16L)) {
                            case 3: {
                                word |= (long)this.s.charAt(pos + 2) << 32;
                            }
                            case 2: {
                                word |= (long)this.s.charAt(pos + 1) << 16;
                            }
                            case 1: {
                                word |= (long)this.s.charAt(pos + 0);
                            }
                        }
                        return word;
                    }
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }

        private static class RawUtf16MutableStringBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final char[] a;
            private final long length;

            public RawUtf16MutableStringBitVector(MutableString s) {
                this.a = s.array();
                this.length = (long)s.length() * 16L;
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                int charIndex = (int)(index / 16L);
                return (this.a[charIndex] & 1 << (int)(index % 16L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 16L);
                if (startBit == 0) {
                    int pos = (int)(from / 16L);
                    if (to == from + 64L) {
                        return (long)this.a[pos + 3] << 48 | (long)this.a[pos + 2] << 32 | (long)this.a[pos + 1] << 16 | (long)this.a[pos];
                    }
                    if (to % 16L == 0L) {
                        long word = 0L;
                        switch ((int)((to - from) / 16L)) {
                            case 3: {
                                word |= (long)this.a[pos + 2] << 32;
                            }
                            case 2: {
                                word |= (long)this.a[pos + 1] << 16;
                            }
                            case 1: {
                                word |= (long)this.a[pos + 0];
                            }
                        }
                        return word;
                    }
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }
    }

    private static class Utf32TransformationStrategy
    implements TransformationStrategy<CharSequence>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean prefixFree;

        protected Utf32TransformationStrategy(boolean prefixFree) {
            this.prefixFree = prefixFree;
        }

        @Override
        public long length(CharSequence cs) {
            return this.length(cs.toString());
        }

        @Override
        private long length(String s) {
            return (long)(s.codePointCount(0, s.length()) + (this.prefixFree ? 1 : 0)) * 32L;
        }

        @Override
        public BitVector toBitVector(CharSequence cs) {
            int cp;
            String s = cs.toString();
            int length = s.length();
            LongArrayBitVector bitVector = LongArrayBitVector.getInstance(this.length(s));
            for (int i = 0; i < length; i += Character.charCount(cp)) {
                cp = s.codePointAt(i);
                bitVector.append((long)Integer.reverse(cp) & 0xFFFFFFFFL, 32);
            }
            if (this.prefixFree) {
                bitVector.append(0L, 32);
            }
            return bitVector;
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<CharSequence> copy() {
            return this;
        }

        private Object readResolve() {
            return this.prefixFree ? PREFIX_FREE_UTF32 : UTF32;
        }
    }

    private static class RawUtf32TransformationStrategy
    implements TransformationStrategy<CharSequence>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private RawUtf32TransformationStrategy() {
        }

        @Override
        public long length(CharSequence cs) {
            return this.length(cs.toString());
        }

        @Override
        private long length(String s) {
            return (long)s.codePointCount(0, s.length()) * 32L;
        }

        @Override
        public BitVector toBitVector(CharSequence cs) {
            int cp;
            String s = cs.toString();
            int length = s.length();
            LongArrayBitVector bitVector = LongArrayBitVector.getInstance(this.length(s));
            for (int i = 0; i < length; i += Character.charCount(cp)) {
                cp = s.codePointAt(i);
                bitVector.append(cp, 32);
            }
            return bitVector;
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<CharSequence> copy() {
            return this;
        }

        private Object readResolve() {
            return RAW_UTF32;
        }
    }
}

