/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

public final class Fast {
    private static final boolean ASSERTS = false;
    public static final long ONES_STEP_4 = 0x1111111111111111L;
    public static final long ONES_STEP_8 = 0x101010101010101L;
    public static final long MSBS_STEP_8 = -9187201950435737472L;
    public static final long INCR_STEP_8 = -9205322385119247871L;
    private static final long MU0 = 0x5555555555555555L;
    private static final long MU1 = 0x3333333333333333L;
    private static final long MU2 = 0xF0F0F0F0F0F0F0FL;
    private static final long MU3 = 0xFF00FF00FF00FFL;
    private static final long MU4 = 0xFFFF0000FFFFL;
    private static final long MU5 = 0xFFFFFFFFL;
    public static final int[] BYTELSB = new int[]{-1, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
    public static final int[] BYTEMSB = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] LSB_TABLE = new byte[]{0, 1, 56, 2, 57, 49, 28, 3, 61, 58, 42, 50, 38, 29, 17, 4, 62, 47, 59, 36, 45, 43, 51, 22, 53, 39, 33, 30, 24, 18, 12, 5, 63, 55, 48, 27, 60, 41, 37, 16, 46, 35, 44, 21, 52, 32, 23, 11, 54, 26, 40, 15, 34, 20, 31, 10, 25, 14, 19, 9, 13, 8, 7, 6};

    private Fast() {
    }

    public static int int2nat(int x) {
        return x >= 0 ? x << 1 : -((x << 1) + 1);
    }

    public static int nat2int(int x) {
        return x % 2 == 0 ? x >> 1 : -(x >> 1) - 1;
    }

    public static long int2nat(long x) {
        return x >= 0L ? x << 1 : -((x << 1) + 1L);
    }

    public static long nat2int(long x) {
        return x % 2L == 0L ? x >> 1 : -(x >> 1) - 1L;
    }

    public static double log2(double x) {
        return Math.log(x) / 0.6931471805599453;
    }

    public static int ceilLog2(int x) {
        if (x <= 2) {
            return x - 1;
        }
        return 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public static int ceilLog2(long x) {
        if (x <= 2L) {
            return (int)(x - 1L);
        }
        return 64 - Long.numberOfLeadingZeros(x - 1L);
    }

    public static int approximateLog2(double x) {
        long bits = Double.doubleToRawLongBits(x);
        return (int)(bits >>> 52 & 0x7FFL) - 1023 + ((bits >>> 48 & 0xFL) > 6L ? 1 : 0);
    }

    public static double pow2(int exponent) {
        if (exponent < 0) {
            return 1.0 / (double)(1L << -exponent);
        }
        return 1L << exponent;
    }

    public static int length(int x) {
        return x == 0 ? 1 : Fast.mostSignificantBit(x) + 1;
    }

    public static int length(long x) {
        return x == 0L ? 1 : Fast.mostSignificantBit(x) + 1;
    }

    @Deprecated
    public static int count(long x) {
        long byteSums = x - ((x & 0xAAAAAAAAAAAAAAAAL) >>> 1);
        byteSums = (byteSums & 0x3333333333333333L) + (byteSums >>> 2 & 0x3333333333333333L);
        byteSums = byteSums + (byteSums >>> 4) & 0xF0F0F0F0F0F0F0FL;
        return (int)(byteSums * 0x101010101010101L >>> 56);
    }

    public static int select(long x, int rank) {
        long byteSums = x - ((x & 0xAAAAAAAAAAAAAAAAL) >>> 1);
        byteSums = (byteSums & 0x3333333333333333L) + (byteSums >>> 2 & 0x3333333333333333L);
        byteSums = byteSums + (byteSums >>> 4) & 0xF0F0F0F0F0F0F0FL;
        long rankStep8 = (long)rank * 0x101010101010101L;
        long byteOffset = (((rankStep8 | 0x8080808080808080L) - (byteSums *= 0x101010101010101L) & 0x8080808080808080L) >>> 7) * 0x101010101010101L >>> 53 & 0xFFFFFFFFFFFFFFF8L;
        int byteRank = (int)((long)rank - (byteSums << 8 >>> (int)byteOffset & 0xFFL));
        long spreadBits = (x >>> (int)byteOffset & 0xFFL) * 0x101010101010101L & 0x8040201008040201L;
        long bitSums = (((spreadBits | (spreadBits | 0x8080808080808080L) - 0x101010101010101L) & 0x8080808080808080L) >>> 7) * 0x101010101010101L;
        long byteRankStep8 = (long)byteRank * 0x101010101010101L;
        return (int)(byteOffset + ((((byteRankStep8 | 0x8080808080808080L) - bitSums & 0x8080808080808080L) >>> 7) * 0x101010101010101L >>> 56));
    }

    public static int mostSignificantBit(long x) {
        return 63 - Long.numberOfLeadingZeros(x);
    }

    private static int diffMsb(long x, long y) {
        return (x ^ y) > (x & y) ? 1 : 0;
    }

    private static int mostSignificantBit2(long x) {
        return Fast.diffMsb(x, x & 0x5555555555555555L) + (Fast.diffMsb(x, x & 0x3333333333333333L) << 1) + (Fast.diffMsb(x, x & 0xF0F0F0F0F0F0F0FL) << 2) + (Fast.diffMsb(x, x & 0xFF00FF00FF00FFL) << 3) + (Fast.diffMsb(x, x & 0xFFFF0000FFFFL) << 4) + (Fast.diffMsb(x, x & 0xFFFFFFFFL) << 5);
    }

    public static int mostSignificantBit(int x) {
        return 31 - Integer.numberOfLeadingZeros(x);
    }

    @Deprecated
    public static int leastSignificantBit(long x) {
        if (x == 0L) {
            return -1;
        }
        if ((x & 0xFFL) != 0L) {
            return BYTELSB[(int)(x & 0xFFL)];
        }
        if ((x & 0xFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 8 & 0xFFL)] + 8;
        }
        if ((x & 0xFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 16 & 0xFFL)] + 16;
        }
        if ((x & 0xFFFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 24 & 0xFFL)] + 24;
        }
        if ((x & 0xFFFFFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 32 & 0xFFL)] + 32;
        }
        if ((x & 0xFFFFFFFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 40 & 0xFFL)] + 40;
        }
        if ((x & 0xFFFFFFFFFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 48 & 0xFFL)] + 48;
        }
        return BYTELSB[(int)(x >>> 56 & 0xFFL)] + 56;
    }

    public static long reverseBytes(long l) {
        l = (l & 0x5555555555555555L) << 1 | l >>> 1 & 0x5555555555555555L;
        l = (l & 0x3333333333333333L) << 2 | l >>> 2 & 0x3333333333333333L;
        return (l & 0xF0F0F0F0F0F0F0FL) << 4 | l >>> 4 & 0xF0F0F0F0F0F0F0FL;
    }

    private static int multLookupLeastSignificantBit(long x) {
        return LSB_TABLE[(int)((x & -x) * 285870213051353865L >>> 58)];
    }

    private static int msbBasedLeastSignificantBit(long x) {
        return Fast.mostSignificantBit(x & -x);
    }

    public static void main(String[] a) {
        long n = Long.parseLong(a[0]);
        long incr = Long.MAX_VALUE / (n / 2L);
        int k = 10;
        while (k-- != 0) {
            System.out.print("Broadword msb (Brodal): ");
            long start = System.currentTimeMillis();
            long i = n;
            long v = 0L;
            while (i-- != 0L) {
                Fast.mostSignificantBit(v += incr);
            }
            long elapsed = System.currentTimeMillis() - start;
            System.out.println("elapsed " + elapsed + ", " + 1000000.0 * (double)elapsed / (double)n + " ns/call");
            System.out.print("Broadword msb (Knuth): ");
            start = System.currentTimeMillis();
            i = n;
            v = 0L;
            while (i-- != 0L) {
                Fast.mostSignificantBit2(v += incr);
            }
            elapsed = System.currentTimeMillis() - start;
            System.out.println("elapsed " + elapsed + ", " + 1000000.0 * (double)elapsed / (double)n + " ns/call");
            System.out.print("java.lang msb: ");
            start = System.currentTimeMillis();
            i = n;
            v = 0L;
            while (i-- != 0L) {
                Long.numberOfLeadingZeros(v += incr);
            }
            elapsed = System.currentTimeMillis() - start;
            System.out.println("elapsed " + elapsed + ", " + 1000000.0 * (double)elapsed / (double)n + " ns/call");
            System.out.print("MSB-based lsb: ");
            start = System.currentTimeMillis();
            i = n;
            v = 0L;
            while (i-- != 0L) {
                Fast.msbBasedLeastSignificantBit(v += incr);
            }
            elapsed = System.currentTimeMillis() - start;
            System.out.println("elapsed " + elapsed + ", " + 1000000.0 * (double)elapsed / (double)n + " ns/call");
            System.out.print("Multiplication/lookup lsb: ");
            start = System.currentTimeMillis();
            i = n;
            v = 0L;
            while (i-- != 0L) {
                Fast.multLookupLeastSignificantBit(v += incr);
            }
            elapsed = System.currentTimeMillis() - start;
            System.out.println("elapsed " + elapsed + ", " + 1000000.0 * (double)elapsed / (double)n + " ns/call");
            System.out.print("Byte-by-byte lsb: ");
            start = System.currentTimeMillis();
            i = n;
            v = 0L;
            while (i-- != 0L) {
                Fast.leastSignificantBit(v += incr);
            }
            elapsed = System.currentTimeMillis() - start;
            System.out.println("elapsed " + elapsed + ", " + 1000000.0 * (double)elapsed / (double)n + " ns/call");
            System.out.print("java.lang lsb: ");
            start = System.currentTimeMillis();
            i = n;
            v = 0L;
            while (i-- != 0L) {
                Long.numberOfTrailingZeros(v += incr);
            }
            elapsed = System.currentTimeMillis() - start;
            System.out.println("elapsed " + elapsed + ", " + 1000000.0 * (double)elapsed / (double)n + " ns/call");
        }
    }
}

