/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.logging;

import it.unimi.dsi.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class ProgressLogger {
    public static final long ONE_SECOND = 1000L;
    public static final long TEN_SECONDS = 10000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long TEN_MINUTES = 600000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long DEFAULT_LOG_INTERVAL = 10000L;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final Pattern[] PLURAL = new Pattern[]{Pattern.compile("s$"), Pattern.compile("(s|si|u)s$"), Pattern.compile("(n)ews$"), Pattern.compile("([ti])a$"), Pattern.compile("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$"), Pattern.compile("(^analy)ses$"), Pattern.compile("(^analy)sis$"), Pattern.compile("([^f])ves$"), Pattern.compile("(hive)s$"), Pattern.compile("(tive)s$"), Pattern.compile("([lr])ves$"), Pattern.compile("([^aeiouy]|qu)ies$"), Pattern.compile("(s)eries$"), Pattern.compile("(m)ovies$"), Pattern.compile("(x|ch|ss|sh)es$"), Pattern.compile("([m|l])ice$"), Pattern.compile("(bus)es$"), Pattern.compile("(o)es$"), Pattern.compile("(shoe)s$"), Pattern.compile("(cris|ax|test)is$"), Pattern.compile("(cris|ax|test)es$"), Pattern.compile("(octop|vir)i$"), Pattern.compile("(octop|vir)us$"), Pattern.compile("(alias|status)es$"), Pattern.compile("(alias|status)$"), Pattern.compile("^(ox)en"), Pattern.compile("(vert|ind)ices$"), Pattern.compile("(matr)ices$"), Pattern.compile("(quiz)zes$"), Pattern.compile("^people$"), Pattern.compile("^men$"), Pattern.compile("^women$"), Pattern.compile("^children$"), Pattern.compile("^sexes$"), Pattern.compile("^moves$"), Pattern.compile("^stadiums$")};
    private static final String[] SINGULAR = new String[]{"", "$1s", "$1ews", "$1um", "$1$2sis", "$1sis", "$1sis", "$1fe", "$1", "$1", "$1f", "$1y", "$1eries", "$1ovie", "$1", "$1ouse", "$1", "$1", "$1", "$1is", "$1is", "$1us", "$1us", "$1", "$1", "$1", "$1ex", "$1ix", "$1", "person", "man", "woman", "child", "sex", "move", "stadium"};
    public final int LIGHT_UPDATE_MASK = 1023;
    public final Logger logger;
    public Level priority = Level.INFO;
    public long logInterval;
    public Object info;
    public long count;
    public long expectedUpdates;
    public String itemsName;
    public boolean displayFreeMemory;
    private String itemName;
    private String referenceItemsName;
    private long start;
    private long stop;
    private long lastLog;

    public ProgressLogger() {
        this(Logger.getRootLogger());
    }

    public ProgressLogger(Logger logger) {
        this(logger, 10000L);
    }

    public ProgressLogger(Logger logger, String itemsName) {
        this(logger, 10000L, itemsName);
    }

    public ProgressLogger(Logger logger, long logInterval) {
        this(logger, logInterval, "items");
    }

    public ProgressLogger(Logger logger, long logInterval, String itemsName) {
        this.logger = logger;
        this.logInterval = logInterval;
        this.itemsName = itemsName;
        this.expectedUpdates = -1L;
    }

    private final String itemName() {
        if (this.referenceItemsName == this.itemsName) {
            return this.itemName;
        }
        this.referenceItemsName = this.itemsName;
        int i = PLURAL.length;
        while (i-- != 0) {
            Matcher matcher = PLURAL[i].matcher(this.itemsName);
            if (!matcher.find()) continue;
            this.itemName = matcher.replaceFirst(SINGULAR[i]);
            return this.itemName;
        }
        this.itemName = this.itemsName;
        return this.itemName;
    }

    public void update() {
        this.update(1L);
    }

    public void update(long count) {
        this.count += count;
        long time = System.currentTimeMillis();
        if (time - this.lastLog >= this.logInterval) {
            this.updateInternal(time);
        }
    }

    public void updateAndDisplay() {
        this.updateAndDisplay(1L);
    }

    public void set(long count) {
        this.count = count;
        long time = System.currentTimeMillis();
        if (time - this.lastLog >= this.logInterval) {
            this.updateInternal(time);
        }
    }

    public void setAndDisplay(long count) {
        this.count = count;
        this.updateInternal(System.currentTimeMillis());
    }

    public void updateAndDisplay(long count) {
        this.count += count;
        this.updateInternal(System.currentTimeMillis());
    }

    private String freeMemory() {
        return this.displayFreeMemory ? "; used/avail/free/total/max mem: " + Util.formatSize(RUNTIME.totalMemory() - RUNTIME.freeMemory()) + "/" + Util.formatSize(RUNTIME.freeMemory() + (RUNTIME.maxMemory() - RUNTIME.totalMemory())) + "/" + Util.formatSize(RUNTIME.freeMemory()) + "/" + Util.formatSize(RUNTIME.totalMemory()) + "/" + Util.formatSize(RUNTIME.maxMemory()) : "";
    }

    private String itemsPerTimeInterval(long currentTime) {
        double secondsPerItem = (double)this.count * 1000.0 / (double)(currentTime - this.start);
        if (secondsPerItem >= 1.0) {
            return Util.format(secondsPerItem) + " " + this.itemsName + "/s";
        }
        if (secondsPerItem * 60.0 >= 1.0) {
            return Util.format(secondsPerItem * 60.0) + " " + this.itemsName + "/m";
        }
        if (secondsPerItem * 3600.0 >= 1.0) {
            return Util.format(secondsPerItem * 3600.0) + " " + this.itemsName + "/h";
        }
        return Util.format(secondsPerItem * 86400.0) + " " + this.itemsName + "/d";
    }

    private String timePerItem(long currentTime) {
        double secondsPerItem = (double)(currentTime - this.start) / ((double)this.count * 1000.0);
        if (secondsPerItem >= 86400.0) {
            return Util.format(secondsPerItem / 86400.0) + " d/" + this.itemName();
        }
        if (secondsPerItem >= 3600.0) {
            return Util.format(secondsPerItem / 3600.0) + " h/" + this.itemName();
        }
        if (secondsPerItem >= 60.0) {
            return Util.format(secondsPerItem / 60.0) + " m/" + this.itemName();
        }
        if (secondsPerItem >= 1.0) {
            return Util.format(secondsPerItem) + " s/" + this.itemName();
        }
        if (secondsPerItem >= 0.001) {
            return Util.format(secondsPerItem * 1000.0) + " ms/" + this.itemName();
        }
        if (secondsPerItem >= 1.0E-6) {
            return Util.format(secondsPerItem * 1000000.0) + " \u00b5s/" + this.itemName();
        }
        return Util.format(secondsPerItem * 1.0E9) + " ns/" + this.itemName();
    }

    private void updateInternal(long currentTime) {
        long millisToEnd = Math.round((double)(this.expectedUpdates - this.count) * ((double)(currentTime - this.start) / ((double)this.count + 1.0)));
        if (this.logger.isEnabledFor((Priority)this.priority)) {
            this.logger.log((Priority)this.priority, (Object)(Util.format(this.count) + " " + this.itemsName + ", " + this.millis2hms(this.millis()) + ", " + this.itemsPerTimeInterval(currentTime) + ", " + this.timePerItem(currentTime) + (this.expectedUpdates > 0L ? "; " + Util.format(100L * this.count / this.expectedUpdates) + "% done, " + this.millis2hms(millisToEnd) + " to end" : "") + this.freeMemory() + (this.info != null ? "; " + this.info : "")));
        }
        this.lastLog = currentTime;
    }

    public final void lightUpdate() {
        long time;
        if ((++this.count & 0x3FFL) == 0L && (time = System.currentTimeMillis()) - this.lastLog >= this.logInterval) {
            this.updateInternal(time);
        }
    }

    public void start(CharSequence message) {
        if (message != null) {
            this.logger.log((Priority)this.priority, (Object)message);
        }
        this.start = this.lastLog = System.currentTimeMillis();
        this.count = 0L;
        this.stop = -1L;
    }

    public void start() {
        this.start(null);
    }

    public void stop(CharSequence message) {
        if (this.stop != -1L) {
            return;
        }
        if (message != null) {
            this.logger.log((Priority)this.priority, (Object)message);
        }
        this.stop = System.currentTimeMillis();
        this.expectedUpdates = -1L;
    }

    public void stop() {
        this.stop(null);
    }

    public void done() {
        this.stop("Completed.");
        this.logger.log((Priority)this.priority, (Object)this);
    }

    public void done(long count) {
        this.count = count;
        this.stop("Completed.");
        this.logger.log((Priority)this.priority, (Object)this);
    }

    public long millis() {
        if (this.stop != -1L) {
            return this.stop - this.start;
        }
        return System.currentTimeMillis() - this.start;
    }

    private String millis2hms(long t) {
        if (t < 1000L) {
            return t + "ms";
        }
        long s = t / 1000L % 60L;
        long m = t / 1000L / 60L % 60L;
        long h = t / 3600000L;
        if (h == 0L && m == 0L) {
            return s + "s";
        }
        if (h == 0L) {
            return m + "m " + s + "s";
        }
        return h + "h " + m + "m " + s + "s";
    }

    public String toString() {
        long t = (this.stop != -1L ? this.stop : System.currentTimeMillis()) - this.start + 1L;
        if (t <= 0L) {
            return "Illegal progress logger state";
        }
        return "Elapsed: " + this.millis2hms(t) + (this.count != 0L ? " [" + Util.format(this.count) + " " + this.itemsName + ", " + this.itemsPerTimeInterval(this.stop) + ", " + this.timePerItem(this.stop) + "]" : "") + this.freeMemory();
    }
}

