/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.stat;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Iterator;

public class SummaryStats
implements Size64 {
    private double a;
    private double q;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private long size;

    public void add(double x) {
        double oldA = this.a;
        this.a += (x - this.a) / (double)(++this.size);
        this.q += (x - this.a) * (x - oldA);
        this.min = Math.min(this.min, x);
        this.max = Math.max(this.max, x);
    }

    @Deprecated
    public void add(double[] a) {
        for (double x : a) {
            this.add(x);
        }
    }

    public void addAll(double[] a) {
        for (double x : a) {
            this.add(x);
        }
    }

    public void addAll(DoubleList l) {
        Iterator i$ = l.iterator();
        while (i$.hasNext()) {
            double x = (Double)i$.next();
            this.add(x);
        }
    }

    public double mean() {
        return this.a;
    }

    public double sum() {
        return this.a * (double)this.size;
    }

    public double sampleVariance() {
        return this.q / (double)(this.size - 1L);
    }

    public double variance() {
        return this.q / (double)this.size;
    }

    public double sampleStandardDeviation() {
        return Math.sqrt(this.sampleVariance());
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public double sampleRelativeStandardDeviation() {
        return Math.sqrt(this.sampleVariance()) / this.mean();
    }

    public double relativeStandardDeviation() {
        return Math.sqrt(this.variance()) / this.mean();
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public long size64() {
        return this.size;
    }

    @Deprecated
    public int size() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "[min: " + this.min + " max: " + this.max + " \u03bc: " + Util.format(this.mean()) + " \u03c3: " + Util.format(this.sampleStandardDeviation()) + " (" + Util.format(100.0 * this.sampleRelativeStandardDeviation()) + " %)]";
    }
}

