/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.security.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.owasp.esapi.ESAPI;

public class XssSanitizerUtil {
    private static List<Pattern> XSS_INPUT_PATTERNS = new ArrayList<Pattern>();

    public static String stripXSS(String value) {
        try {
            if (value != null) {
                value = ESAPI.encoder().canonicalize(value);
                value = value.replaceAll("\u0000", "");
                for (Pattern xssInputPattern : XSS_INPUT_PATTERNS) {
                    value = xssInputPattern.matcher(value).replaceAll("");
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Could not strip XSS from value = " + value + " | ex = " + ex.getMessage());
        }
        return value;
    }

    static {
        XSS_INPUT_PATTERNS.add(Pattern.compile("<script>(.*?)</script>", 2));
        XSS_INPUT_PATTERNS.add(Pattern.compile("<iframe(.*?)>(.*?)</iframe>", 2));
        XSS_INPUT_PATTERNS.add(Pattern.compile("<input(.*?)>(.*?)</input>", 2));
        XSS_INPUT_PATTERNS.add(Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("src[\r\n]*=[\r\n]*([^>]+)", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("</script>", 2));
        XSS_INPUT_PATTERNS.add(Pattern.compile("<script(.*?)>", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("<input(.*?)>", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("eval\\((.*?)\\)", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("expression\\((.*?)\\)", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("javascript:", 2));
        XSS_INPUT_PATTERNS.add(Pattern.compile("vbscript:", 2));
        XSS_INPUT_PATTERNS.add(Pattern.compile("onload(.*?)=", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("onfocus(.*?)=", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("<(.*?)form(.*?)>(.*?)</(.*?)form(.*?)>", 42));
    }
}

