/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.security.jaas;

import it.mice.voila.runtime.security.UserDetailImpl;
import it.mice.voila.runtime.security.UserProfileGrantedAuthorityImpl;
import java.util.ArrayList;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;

public class JaasAuthenticationProviderAdapter
implements AuthenticationProvider {
    private AuthenticationProvider jaasAuthenticationProvider;

    public AuthenticationProvider getJaasAuthenticationProvider() {
        return this.jaasAuthenticationProvider;
    }

    public void setJaasAuthenticationProvider(AuthenticationProvider jaasAuthenticationProvider) {
        this.jaasAuthenticationProvider = jaasAuthenticationProvider;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication result = this.getJaasAuthenticationProvider().authenticate(authentication);
        if (result != null) {
            ArrayList<GrantedAuthority> auths = new ArrayList<GrantedAuthority>();
            for (GrantedAuthority grantedAuthority : result.getAuthorities()) {
                UserProfileGrantedAuthorityImpl authImpl = new UserProfileGrantedAuthorityImpl(null, grantedAuthority.getAuthority(), null, null, null, null, null);
                auths.add(authImpl);
            }
            UserDetailImpl userDetail = new UserDetailImpl(result.getPrincipal().toString(), result.getCredentials().toString(), true, true, true, true, auths, null);
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)userDetail, result.getCredentials(), auths);
            return auth;
        }
        return result;
    }

    public boolean supports(Class<? extends Object> authentication) {
        return this.getJaasAuthenticationProvider().supports(authentication);
    }
}

