/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.security;

import it.mice.voila.runtime.security.ApplicationHolder;
import it.mice.voila.runtime.security.OperationConfigAttribute;
import it.mice.voila.runtime.security.OperationPerProfileConfigAttribute;
import it.mice.voila.runtime.security.UserDetailImpl;
import it.mice.voila.runtime.security.UserProfileGrantedAuthorityImpl;
import it.mice.voila.runtime.util.VelocityContextUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;

public abstract class AbstractVoter {
    private static final Log logger = LogFactory.getLog(AbstractVoter.class);
    private VelocityEngine velocityEngine;
    private ApplicationHolder applicationHolder;
    private Map velocityContextProperties;
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public ApplicationHolder getApplicationHolder() {
        return this.applicationHolder;
    }

    public void setApplicationHolder(ApplicationHolder applicationHolder) {
        this.applicationHolder = applicationHolder;
    }

    public Map getVelocityContextProperties() {
        return this.velocityContextProperties;
    }

    public void setVelocityContextProperties(Map velocityContextProperties) {
        this.velocityContextProperties = velocityContextProperties;
    }

    public AuthenticationTrustResolver getAuthenticationTrustResolver() {
        return this.authenticationTrustResolver;
    }

    protected String evaluateVelocityTemplate(Object object, String template, StringBuffer propertySetters, Authentication authentication, UserProfileGrantedAuthorityImpl currentRole, boolean authRule) {
        if (template == null || template.equals("")) {
            return null;
        }
        propertySetters.append("#if( ").append(template).append(" )\r\ntrue#else\r\nfalse#end");
        String desc = "Authorization";
        if (!authRule) {
            desc = "Association";
        }
        try {
            VelocityContext context = new VelocityContext(VelocityContextUtils.getVelocityContextToolsMap());
            if (object != null) {
                context.put("ctx", object);
            }
            context.put("user", authentication.getPrincipal());
            context.put("roles", (Object)authentication.getAuthorities());
            context.put("currentRole", (Object)currentRole);
            this.populateVelocityContext(context);
            String logString = "AuthRule";
            StringWriter sw = new StringWriter();
            if (this.getVelocityEngine().evaluate((Context)context, (Writer)sw, logString, propertySetters.toString())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Template value:\n" + propertySetters + "\nWas converted to:" + sw.toString()));
                }
                return sw.toString();
            }
            logger.error((Object)("Failed to parse Velocity content for " + desc + " Rule field template:" + propertySetters + ". Check content into column '" + desc + " Rule' of the table for  " + object + ". Probably the content is not a valid Velocity script language."));
            logger.error((Object)("Error description:" + logString));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to parse Velocity content for " + desc + " Rule field template:\n" + propertySetters + "\n. Check content into column '" + desc + " Rule' of the table for  " + object + ". Probably the content is not a valid Velocity script language. Error:" + e.getLocalizedMessage()));
        }
        return null;
    }

    private void populateVelocityContext(VelocityContext context) {
        if (this.getVelocityContextProperties() != null) {
            for (Map.Entry entry : this.getVelocityContextProperties().entrySet()) {
                context.put(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    protected StringBuffer preparePropertySetters(UserProfileGrantedAuthorityImpl gai, Authentication authentication, OperationConfigAttribute castedAttribute, OperationPerProfileConfigAttribute operationPerProfileConfigAttribute) {
        StringBuffer propertySetters = new StringBuffer("");
        propertySetters.append(this.getApplicationHolder() != null ? this.getApplicationHolder().getApplicationProps() : "");
        propertySetters.append(gai.getProfileProps());
        propertySetters.append(((UserDetailImpl)authentication.getPrincipal()).getUserProperties());
        propertySetters.append(gai.getProfilePerUserProps());
        if (castedAttribute != null && castedAttribute.getOperationProps() != null) {
            propertySetters.append(castedAttribute.getOperationProps());
        }
        if (operationPerProfileConfigAttribute != null) {
            propertySetters.append(operationPerProfileConfigAttribute.getOperationProps());
        }
        return propertySetters;
    }

    protected Object extractContext(Object object) {
        try {
            Object ctx = ((MethodInvocation)object).getArguments()[0];
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }
}

