/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.security;

import it.mice.voila.runtime.security.ReloadableMethodSecurityMetadataSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.util.AntPathRequestMatcher;
import org.springframework.security.web.util.RequestMatcher;

public abstract class AbstractFilterSecurityInterceptorPostProcessor
implements BeanPostProcessor {
    private static Log logger = LogFactory.getLog(ReloadableMethodSecurityMetadataSource.class);
    private String applicationId;
    private Map<String, String> urlsBefore = new HashMap<String, String>();
    private Map<String, String> urlsAfter = new HashMap<String, String>();
    private FilterSecurityInterceptor filterSecurityInterceptor;

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public Map<String, String> getUrlsBefore() {
        return this.urlsBefore;
    }

    public void setUrlsBefore(Map<String, String> urlsBefore) {
        this.urlsBefore = urlsBefore;
    }

    public Map<String, String> getUrlsAfter() {
        return this.urlsAfter;
    }

    public void setUrlsAfter(Map<String, String> urlsAfter) {
        this.urlsAfter = urlsAfter;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public FilterSecurityInterceptor getFilterSecurityInterceptor() {
        return this.filterSecurityInterceptor;
    }

    public void setFilterSecurityInterceptor(FilterSecurityInterceptor filterSecurityInterceptor) {
        this.filterSecurityInterceptor = filterSecurityInterceptor;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof FilterSecurityInterceptor) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Post-processing bean: " + beanName));
            }
            LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap = this.getRequestMapFromSiteMap();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Found existing configuration, now iterating.");
                for (ConfigAttribute attribute : ((FilterSecurityInterceptor)bean).getSecurityMetadataSource().getAllConfigAttributes()) {
                    logger.debug((Object)("*** Attribute: " + attribute.getAttribute()));
                }
            }
            ((FilterSecurityInterceptor)bean).setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)new DefaultFilterInvocationSecurityMetadataSource(requestMap));
            this.setFilterSecurityInterceptor((FilterSecurityInterceptor)bean);
        }
        return bean;
    }

    public void reloadInformation() {
        try {
            this.postProcessBeforeInitialization(this.getFilterSecurityInterceptor(), this.getFilterSecurityInterceptor().toString());
            this.getFilterSecurityInterceptor().afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> getRequestMapFromSiteMap() {
        LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap = new LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>>();
        for (Map.Entry<String, String> entry : this.urlsBefore.entrySet()) {
            requestMap.put((RequestMatcher)new AntPathRequestMatcher(entry.getKey()), SecurityConfig.createList((String[])new String[]{entry.getValue()}));
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Reloading objectDefinitionSource from data base");
        }
        this.populateRequestMapFromSiteMap(requestMap);
        for (Map.Entry<String, String> entry : this.urlsAfter.entrySet()) {
            requestMap.put((RequestMatcher)new AntPathRequestMatcher(entry.getKey()), SecurityConfig.createList((String[])new String[]{entry.getValue()}));
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Reloading objectDefinitionSource from Database completed");
        }
        return requestMap;
    }

    protected abstract void populateRequestMapFromSiteMap(Map<RequestMatcher, Collection<ConfigAttribute>> var1);
}

