package it.mice.voila.runtime.security.encoders;

import org.springframework.security.authentication.encoding.PasswordEncoder;

public interface PasswordDecoder extends PasswordEncoder {

    /**
     * <p>Encodes the specified raw password with an implementation specific algorithm.</p>
     *  <P>This will generally be a one-way message digest such as MD5 or SHA, but may also be a plaintext
     * variant which does no encoding at all, but rather returns the same password it was fed. The latter is useful to
     * plug in when the original password must be stored as-is.</p>
     *  <p>The specified salt will potentially be used by the implementation to "salt" the initial value before
     * encoding. A salt is usually a user-specific value which is added to the password before the digest is computed.
     * This means that computation of digests for common dictionary words will be different than those in the backend
     * store, because the dictionary word digests will not reflect the addition of the salt. If a per-user salt is
     * used (rather than a system-wide salt), it also means users with the same password will have different digest
     * encoded passwords in the backend store.</p>
     *  <P>If a salt value is provided, the same salt value must be use when calling the  {@link
     * #isPasswordValid(String, String, Object)} method. Note that a specific implementation may choose to ignore the
     * salt value (via <code>null</code>), or provide its own.</p>
     *
     * @param encPass the password to decode
     * @param salt optionally used by the implementation to "salt" the raw password before encoding. A
     *        <code>null</code> value is legal.
     *
     * @return encoded password
     */
    String decodePassword(String encPass, Object salt);
}
