package it.mice.voila.runtime.security.encoders;

import java.util.Random;

public class DefaultPasswordGenerator implements PasswordGenerator {
	private String saltChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890@#!?";

	private int passwordMinLength = 8;
	private int passwordMaxLength = 8;
	private Random rnd = new Random();

	public String getSaltChars() {
		return saltChars;
	}

	public void setSaltChars(String saltChars) {
		this.saltChars = saltChars;
	}

	public int getPasswordMinLength() {
		return passwordMinLength;
	}

	public void setPasswordMinLength(int passwordLength) {
		this.passwordMinLength = passwordLength;
	}

	public int getPasswordMaxLength() {
		return passwordMaxLength;
	}

	public void setPasswordMaxLength(int passwordMaxLength) {
		this.passwordMaxLength = passwordMaxLength;
	}

	public String generate(Object input) {
		int len = rnd.nextInt(getPasswordMaxLength() - getPasswordMinLength() + 1) + getPasswordMinLength(); 
        StringBuilder salt = new StringBuilder();
        while (salt.length() < len) {
            int index = (int) (rnd.nextFloat() * saltChars.length());
            salt.append(saltChars.charAt(index));
        }
        String saltStr = salt.toString();
        return saltStr;
	}
}
