/*
 * Decompiled with CFR 0.152.
 */
package it.mice.voila.runtime.jasper;

import it.mice.voila.runtime.springmvc.util.SpringMvcUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.context.support.MessageSourceResourceBundle;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.ui.jasperreports.JasperReportsUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.theme.SessionThemeResolver;

public class JasperReportDefinition
extends ApplicationObjectSupport {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String DEFAULT_FORMAT_KEY = "format";
    private String formatKey = "format";
    @Autowired(required=false)
    private MessageSource messageSource = null;
    private Map<String, Class<? extends JRExporter>> formatMappings;
    private boolean debug = false;
    private String url;
    private String reportDataKey;
    private Properties subReportUrls;
    private Properties templateUrls;
    private String[] subReportDataKeys;
    private Map<?, ?> exporterParameters = new HashMap();
    private Map<JRExporterParameter, Object> convertedExporterParameters;
    private DataSource jdbcDataSource;
    private JasperReport report;
    private Map<String, JasperReport> subReports;
    private Map<String, JRTemplate> templates;
    private static String DEFAULT_ICC_PROFILE = "AdobeRGB1998.icc";

    public JasperReportDefinition() {
        HashMap<String, Class<? extends JRExporter>> mappings = new HashMap<String, Class<? extends JRExporter>>(5);
        mappings.put("csv", JRCsvExporter.class);
        mappings.put("html", JRHtmlExporter.class);
        mappings.put("pdf", JRPdfExporter.class);
        mappings.put("xls", JRXlsExporter.class);
        mappings.put("rtf", JRRtfExporter.class);
        this.setFormatMappings(mappings);
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setReportDataKey(String reportDataKey) {
        this.reportDataKey = reportDataKey;
    }

    public void setSubReportUrls(Properties subReports) {
        this.subReportUrls = subReports;
    }

    public void setTemplateUrls(Properties templateUrls) {
        this.templateUrls = templateUrls;
    }

    public void setSubReportDataKeys(String[] subReportDataKeys) {
        this.subReportDataKeys = subReportDataKeys;
    }

    public void setExporterParameters(Map<?, ?> parameters) {
        this.exporterParameters = parameters;
    }

    public Map<?, ?> getExporterParameters() {
        return this.exporterParameters;
    }

    public void setConvertedExporterParameters(Map<JRExporterParameter, Object> convertedExporterParameters) {
        this.convertedExporterParameters = convertedExporterParameters;
    }

    public Map<JRExporterParameter, Object> getConvertedExporterParameters() {
        return this.convertedExporterParameters;
    }

    public void setJdbcDataSource(DataSource jdbcDataSource) {
        this.jdbcDataSource = jdbcDataSource;
    }

    protected DataSource getJdbcDataSource() {
        return this.jdbcDataSource;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFormatKey() {
        return this.formatKey;
    }

    public void setFormatKey(String formatKey) {
        this.formatKey = formatKey;
    }

    public Map<String, Class<? extends JRExporter>> getFormatMappings() {
        return this.formatMappings;
    }

    public void setFormatMappings(Map<String, Class<? extends JRExporter>> mappings) {
        this.formatMappings = mappings;
    }

    public Map<String, JasperReport> getSubReports() {
        return this.subReports;
    }

    public void setSubReports(Map<String, JasperReport> subReports) {
        this.subReports = subReports;
    }

    public String getReportDataKey() {
        return this.reportDataKey;
    }

    public Properties getSubReportUrls() {
        return this.subReportUrls;
    }

    public String[] getSubReportDataKeys() {
        return this.subReportDataKeys;
    }

    protected JasperReport getReport() {
        return this.report;
    }

    public void setReport(JasperReport report) {
        this.report = report;
    }

    public void renderToOutputStream(Map<String, Object> model, OutputStream output) {
        this.renderToOutputStream(model, output, null, this.messageSource);
    }

    public void renderToOutputStream(Map<String, Object> model, OutputStream output, Locale locale, MessageSource aMessageSource) {
        try {
            JasperPrint filledReport = this.preparePrintReport(model, locale, aMessageSource);
            this.renderReport(filledReport, model, output);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JasperPrint preparePrintReport(Map<String, Object> model, Locale locale, MessageSource aMessageSource) {
        JasperPrint filledReport;
        if (this.isDebug()) {
            this.initContext();
        }
        if (this.subReports != null) {
            model.put("SubReports", this.subReports);
            model.putAll(this.subReports);
            if (this.subReportDataKeys != null) {
                for (String key : this.subReportDataKeys) {
                    model.put(key, this.convertReportData(model.get(key)));
                }
            }
        }
        this.exposeLocalizationContext(model, locale, aMessageSource);
        try {
            filledReport = this.fillReport(model);
            this.postProcessReport(filledReport, model);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return filledReport;
    }

    protected void exposeLocalizationContext(Map<String, Object> model, Locale locale, MessageSource aMessageSource) {
        String themeName;
        if (locale != null && !model.containsKey("REPORT_LOCALE")) {
            model.put("REPORT_LOCALE", locale);
        }
        if (aMessageSource == null) {
            return;
        }
        JasperReport report = this.getReport();
        if (!(report != null && report.getResourceBundle() != null || model.containsKey("REPORT_RESOURCE_BUNDLE"))) {
            model.put("REPORT_RESOURCE_BUNDLE", new MessageSourceResourceBundle(aMessageSource, locale));
        }
        if (this.templates != null && this.templates.size() > 0 && SpringMvcUtil.getSession() != null && SpringMvcUtil.getSession().getAttribute(SessionThemeResolver.THEME_SESSION_ATTRIBUTE_NAME) != null && this.templates.containsKey(themeName = (String)SpringMvcUtil.getSession().getAttribute(SessionThemeResolver.THEME_SESSION_ATTRIBUTE_NAME))) {
            ArrayList<JRTemplate> template = new ArrayList<JRTemplate>();
            template.add(this.templates.get(themeName));
            model.put("REPORT_TEMPLATES", template);
        }
    }

    protected JasperPrint fillReport(Map<String, Object> model) throws Exception {
        JRDataSourceProvider provider;
        JasperReport report = this.getReport();
        if (report == null) {
            throw new IllegalStateException("No main report defined for 'fillReport' - specify a 'url' on this view or override 'getReport()' or 'fillReport(Map)'");
        }
        JRDataSource jrDataSource = null;
        DataSource jdbcDataSourceToUse = null;
        if (this.reportDataKey != null) {
            Object reportDataValue = model.get(this.reportDataKey);
            if (reportDataValue instanceof DataSource) {
                jdbcDataSourceToUse = (DataSource)reportDataValue;
            } else {
                jrDataSource = this.convertReportData(reportDataValue);
            }
        }
        Collection<Object> values = model.values();
        if (jrDataSource == null) {
            jrDataSource = (JRDataSource)CollectionUtils.findValueOfType(values, JRDataSource.class);
        }
        if (jrDataSource == null && (provider = (JRDataSourceProvider)CollectionUtils.findValueOfType(values, JRDataSourceProvider.class)) != null) {
            jrDataSource = this.createReport(provider);
        }
        if (jrDataSource == null) {
            jrDataSource = this.getReportData(model);
        }
        if (jdbcDataSourceToUse == null) {
            jdbcDataSourceToUse = (DataSource)CollectionUtils.findValueOfType(values, DataSource.class);
        }
        if (jdbcDataSourceToUse == null) {
            jdbcDataSourceToUse = this.jdbcDataSource;
        }
        return this.doFillReport(report, model, jdbcDataSourceToUse, jrDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JasperPrint doFillReport(JasperReport report, Map<String, Object> model, DataSource jdbcDataSourceToUse, JRDataSource jrDataSource) throws Exception {
        Connection con = null;
        try {
            if (jrDataSource != null) {
                if (jdbcDataSourceToUse != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Filling report with JRDataSource [" + jrDataSource + "] and put DataSource connection as REPORT_CONNECTION parameter"));
                    }
                    con = jdbcDataSourceToUse.getConnection();
                    model.put("REPORT_CONNECTION", con);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Filling report with JRDataSource [" + jrDataSource + "]"));
                }
                JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)report, model, (JRDataSource)jrDataSource);
                return jasperPrint;
            }
            if (jdbcDataSourceToUse != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Filling report using JDBC DataSource [" + jdbcDataSourceToUse + "]"));
                }
                con = jdbcDataSourceToUse.getConnection();
                JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)report, model, (Connection)con);
                return jasperPrint;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Filling report with plain model");
            }
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)report, model);
            return jasperPrint;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception ex) {
                this.logger.debug((Object)"Could not close JDBC Connection", (Throwable)ex);
            }
        }
    }

    protected JRDataSource getReportData(Map<String, Object> model) {
        Object value = CollectionUtils.findValueOfType(model.values(), (Class[])this.getReportDataTypes());
        return value != null ? this.convertReportData(value) : null;
    }

    protected JRDataSource convertReportData(Object value) throws IllegalArgumentException {
        if (value instanceof JRDataSourceProvider) {
            return this.createReport((JRDataSourceProvider)value);
        }
        return JasperReportsUtils.convertReportData((Object)value);
    }

    protected JRDataSource createReport(JRDataSourceProvider provider) {
        try {
            JasperReport report = this.getReport();
            if (report == null) {
                throw new IllegalStateException("No main report defined for JRDataSourceProvider - specify a 'url' on this view or override 'getReport()'");
            }
            return provider.create(report);
        }
        catch (JRException ex) {
            throw new IllegalArgumentException("Supplied JRDataSourceProvider is invalid", ex);
        }
    }

    protected Class[] getReportDataTypes() {
        return new Class[]{Collection.class, Object[].class};
    }

    protected void postProcessReport(JasperPrint populatedReport, Map<String, Object> model) throws Exception {
    }

    protected void renderReport(JasperPrint populatedReport, Map<String, Object> model, OutputStream outputStream) throws Exception {
        Class<? extends JRExporter> exporterClass;
        String format = this.getFormat(model);
        if (format == null) {
            throw new IllegalArgumentException("No format format found in model");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering report using format mapping key [" + format + "]"));
        }
        if ((exporterClass = this.formatMappings.get(format)) == null) {
            throw new IllegalArgumentException("Format discriminator [" + format + "] is not a configured mapping");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering report using view class [" + exporterClass.getName() + "]"));
        }
        JRExporter exporter = (JRExporter)BeanUtils.instantiateClass(exporterClass);
        if (this.getConvertedExporterParameters() != null) {
            exporter.setParameters(this.getConvertedExporterParameters());
        }
        this.renderReport(populatedReport, model, outputStream, exporter);
    }

    public String getFormat(Map<String, Object> model) {
        String format = (String)model.get(this.formatKey);
        return format;
    }

    protected void renderReport(JasperPrint populatedReport, Map<String, Object> model, OutputStream outputStream, JRExporter exporter) throws JRException {
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)populatedReport);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
        exporter.exportReport();
    }

    protected final void initApplicationContext() throws ApplicationContextException {
        if (!this.isDebug()) {
            this.initContext();
        } else {
            this.logger.warn((Object)("ATTENZIONE ! Report definition " + this.getUrl() + " in debug mode; questo significa che i reports verranno compilati ad ogni richiesta. Vivamente sconsigliato per gli ambienti di esercizio !"));
        }
    }

    private void initContext() {
        Resource resource;
        String path;
        String key;
        Enumeration<?> urls;
        this.report = this.loadReport();
        if (this.subReportUrls != null) {
            if (this.subReportDataKeys != null && this.subReportDataKeys.length > 0 && this.reportDataKey == null) {
                throw new ApplicationContextException("'reportDataKey' for main report is required when specifying a value for 'subReportDataKeys'");
            }
            this.subReports = new HashMap<String, JasperReport>(this.subReportUrls.size());
            urls = this.subReportUrls.propertyNames();
            while (urls.hasMoreElements()) {
                key = (String)urls.nextElement();
                path = this.subReportUrls.getProperty(key);
                resource = this.getResource(path);
                this.subReports.put(key, this.loadReport(resource));
            }
        }
        if (this.templateUrls != null) {
            this.templates = new HashMap<String, JRTemplate>(this.templateUrls.size());
            urls = this.templateUrls.propertyNames();
            while (urls.hasMoreElements()) {
                key = (String)urls.nextElement();
                path = this.templateUrls.getProperty(key);
                resource = this.getResource(path);
                this.templates.put(key, this.loadTemplate(resource));
            }
        }
        this.convertExporterParameters();
        if (!this.convertedExporterParameters.containsKey(JRPdfExporterParameter.PDFA_ICC_PROFILE_PATH)) {
            this.convertedExporterParameters.put((JRExporterParameter)JRPdfExporterParameter.PDFA_ICC_PROFILE_PATH, DEFAULT_ICC_PROFILE);
        }
        this.onInit();
    }

    protected final void convertExporterParameters() {
        this.convertedExporterParameters = new HashMap<JRExporterParameter, Object>();
        if (!CollectionUtils.isEmpty(this.exporterParameters)) {
            for (Map.Entry<?, ?> entry : this.exporterParameters.entrySet()) {
                JRExporterParameter exporterParameter = this.getExporterParameter(entry.getKey());
                this.convertedExporterParameters.put(exporterParameter, this.convertParameterValue(exporterParameter, entry.getValue()));
            }
        }
    }

    protected Object convertParameterValue(JRExporterParameter parameter, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if ("true".equals(str)) {
                return Boolean.TRUE;
            }
            if ("false".equals(str)) {
                return Boolean.FALSE;
            }
            if (str.length() > 0 && Character.isDigit(str.charAt(0))) {
                try {
                    return new Integer(str);
                }
                catch (NumberFormatException ex) {
                    return this.convertFieldToObjectValue(str);
                }
            }
            return this.convertFieldToObjectValue(str);
        }
        return value;
    }

    protected void onInit() {
    }

    protected JasperReport loadReport() {
        String url = this.getUrl();
        if (url == null) {
            return null;
        }
        Resource mainReport = this.getResource(url);
        return this.loadReport(mainReport);
    }

    private Resource getResource(String url) {
        Assert.notNull((Object)url, (String)"Location must not be null");
        if (url.startsWith("classpath:")) {
            return new UrlResource(ClassUtils.getDefaultClassLoader().getResource(url.substring("classpath:".length())));
        }
        return this.getApplicationContext().getResource(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final JasperReport loadReport(Resource resource) {
        try {
            String fileName = resource.getFilename();
            if (fileName.endsWith(".jasper")) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Loading pre-compiled Jasper Report from " + resource));
                }
                try (InputStream is = resource.getInputStream();){
                    JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)is);
                    return jasperReport;
                }
            }
            if (!fileName.endsWith(".jrxml")) throw new IllegalArgumentException("Report filename [" + fileName + "] must end in either .jasper or .jrxml");
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Compiling Jasper Report loaded from " + resource));
            }
            try (InputStream is = resource.getInputStream();){
                JasperDesign design = JRXmlLoader.load((InputStream)is);
                JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)design);
                return jasperReport;
            }
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Could not load JasperReports report from " + resource, (Throwable)ex);
        }
        catch (JRException ex) {
            throw new ApplicationContextException("Could not parse JasperReports report from " + resource, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final JRTemplate loadTemplate(Resource resource) {
        JRTemplate jRTemplate;
        String fileName = resource.getFilename();
        if (!fileName.endsWith(".jrtx")) throw new IllegalArgumentException("Report Template filename [" + fileName + "] must end with .jrtx");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Loading Jasper Report Template from " + resource));
        }
        InputStream is = resource.getInputStream();
        try {
            jRTemplate = JRXmlTemplateLoader.load((InputStream)is);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new ApplicationContextException("Could not load JasperReports report template from " + resource, (Throwable)ex);
            }
        }
        is.close();
        return jRTemplate;
    }

    protected JRExporterParameter getExporterParameter(Object parameter) {
        if (parameter instanceof JRExporterParameter) {
            return (JRExporterParameter)parameter;
        }
        if (parameter instanceof String) {
            return this.convertToExporterParameter((String)parameter);
        }
        throw new IllegalArgumentException("Parameter [" + parameter + "] is invalid type. Should be either String or JRExporterParameter.");
    }

    protected JRExporterParameter convertToExporterParameter(String fqFieldName) {
        int index = fqFieldName.lastIndexOf(46);
        if (index == -1 || index == fqFieldName.length()) {
            throw new IllegalArgumentException("Parameter name [" + fqFieldName + "] is not a valid static field. The parameter name must map to a static field such as [net.sf.jasperreports.engine.export.JRHtmlExporterParameter.IMAGES_URI]");
        }
        String className = fqFieldName.substring(0, index);
        String fieldName = fqFieldName.substring(index + 1);
        try {
            Class cls = ClassUtils.forName((String)className, (ClassLoader)this.getApplicationContext().getClassLoader());
            Field field = cls.getField(fieldName);
            if (JRExporterParameter.class.isAssignableFrom(field.getType())) {
                try {
                    return (JRExporterParameter)field.get(null);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalArgumentException("Unable to access field [" + fieldName + "] of class [" + className + "]. Check that it is static and accessible.");
                }
            }
            throw new IllegalArgumentException("Field [" + fieldName + "] on class [" + className + "] is not assignable from JRExporterParameter - check the type of this field.");
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Class [" + className + "] in key [" + fqFieldName + "] could not be found.");
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalArgumentException("Field [" + fieldName + "] in key [" + fqFieldName + "] could not be found on class [" + className + "].");
        }
    }

    protected Object convertFieldToObjectValue(String fqFieldName) {
        int index = fqFieldName.lastIndexOf(46);
        if (index == -1 || index == fqFieldName.length()) {
            return fqFieldName;
        }
        try {
            String className = fqFieldName.substring(0, index);
            String fieldName = fqFieldName.substring(index + 1);
            Class cls = ClassUtils.forName((String)className, (ClassLoader)this.getApplicationContext().getClassLoader());
            Field field = cls.getField(fieldName);
            return field.get(null);
        }
        catch (Exception ex) {
            return fqFieldName;
        }
    }
}

