/**
 * 
 */
package it.mice.voila.runtime.jasper.view;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.view.jasperreports.AbstractJasperReportsView;
import org.springframework.web.servlet.view.jasperreports.JasperReportsCsvView;
import org.springframework.web.servlet.view.jasperreports.JasperReportsHtmlView;
import org.springframework.web.servlet.view.jasperreports.JasperReportsPdfView;
import org.springframework.web.servlet.view.jasperreports.JasperReportsXlsView;

/**
 *
 */
public class JasperReportsMultiFormatView extends org.springframework.web.servlet.view.jasperreports.JasperReportsMultiFormatView {
	private boolean debug = false;
	/**
	 * Costruttore di classe.
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public JasperReportsMultiFormatView() {
		Map formatMappings = new HashMap<String, Class<? extends AbstractJasperReportsView>>(5);
		formatMappings.put("csv", JasperReportsCsvView.class);
		formatMappings.put("html", JasperReportsHtmlView.class);
		formatMappings.put("pdf", JasperReportsPdfView.class);
		formatMappings.put("xls", JasperReportsXlsView.class);
		formatMappings.put("rtf", JasperReportsRtfView.class);
		setFormatMappings(formatMappings);
	}
	
	/**
	 * Getter per la propriet debug.
	 * @return la propriet debug
	 */
	public boolean isDebug() {
		return debug;
	}

	/**
	 * Setter per la propriet debug.
	 * @param debug la propriet debug da settare
	 */
	public void setDebug(boolean debug) {
		this.debug = debug;
	}

	/**
	 * Finds the report data to use for rendering the report and then invokes the
	 * {@link #renderReport} method that should be implemented by the subclass.
	 * @param model the model map, as passed in for view rendering. Must contain
	 * a report data value that can be converted to a <code>JRDataSource</code>,
	 * acccording to the rules of the {@link #fillReport} method.
	 */
	@Override
	protected void renderMergedOutputModel(
			Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {

		if (isDebug()) {
			initApplicationContext();
		}
		super.renderMergedOutputModel(model, request, response);
	}

}
