/**
 * 
 */
package it.mice.voila.runtime.jasper;

import it.mice.voila.runtime.displaytag.basedec.TextareaToHtmlParagraphDecorator;
import it.mice.voila.runtime.entity.Entity;

import java.sql.Clob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRProperties;

/**
 *
 */
public class JasperUtils {
	
	/**
	 * buildDataSource.
	 * @param entity the entity.
	 * @return the result.
	 */
	public static JRDataSource buildDataSource(Entity entity) {
		Collection<Entity> coll = new ArrayList<Entity>();
		coll.add(entity);
		return new JRBeanCollectionDataSource(coll);
	}
	/**
	 * Prepare a new jasper report parameter map initizlized on the given dataSource and format.
	 * @param dataSource the given datasource
	 * @param format the format.
	 * @return jasper report parameter map initizlized.
	 */
	public static Map<String, Object> prepareJasperParameterMap(Entity dataSource, String format) {
		Map<String, Object> parameterMap = new HashMap<String, Object>();
		parameterMap.put("dataSource", JasperUtils.buildDataSource(dataSource));
		parameterMap.put("format", format);
		JRProperties.setProperty("net.sf.jasperreports.default.pdf.encoding", "Identity-H");
		JRProperties.setProperty("net.sf.jasperreports.default.pdf.font.name", "ARIALUNI.TTF");
		
		return parameterMap;
	}
	
	public static String clobToHtmlParagraph(Clob clobValue) {
		TextareaToHtmlParagraphDecorator decorator = new TextareaToHtmlParagraphDecorator();
		return decorator.decorate(clobValue);
	}	
}
