/*
 * Decompiled with CFR 0.152.
 */
package it.infuse.jenkins.usemango;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import it.infuse.jenkins.usemango.model.TestIndexItem;
import it.infuse.jenkins.usemango.util.ProjectUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class UseMangoTestExecutor
implements Queue.Executable {
    private final Queue.Task task;
    private final FilePath workspace;
    private final BuildListener listener;
    private final TestIndexItem test;
    private final String command;

    public UseMangoTestExecutor(Queue.Task task, FilePath workspace, BuildListener listener, TestIndexItem test, String command) {
        this.task = task;
        this.workspace = workspace;
        this.listener = listener;
        this.test = test;
        this.command = command;
    }

    public Queue.Task getParent() {
        return this.task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public synchronized void run() {
        Node currentNode = Executor.of((Queue.Executable)this).getOwner().getNode();
        if (currentNode != null) {
            String operatingSystem = null;
            try {
                operatingSystem = (String)currentNode.toComputer().getEnvironment().get((Object)"OS");
            }
            catch (IOException | InterruptedException e) {
                this.listener.error("Unable to determine OS for node '" + currentNode.getNodeName() + "', task stopped.");
                e.printStackTrace(this.listener.getLogger());
            }
            if (operatingSystem != null && operatingSystem.toLowerCase().contains("windows")) {
                this.listener.getLogger().println("START: Executing test '" + this.test.getName() + "' on Windows node " + currentNode.getNodeName());
                String[] parts = this.command.split(" --password ");
                String cmd = parts[0].concat(" -a ");
                ArgumentListBuilder args = new ArgumentListBuilder();
                args.addTokenized(cmd);
                args.addMasked(parts[1]);
                Launcher launcher = currentNode.createLauncher((TaskListener)this.listener);
                Launcher.ProcStarter starter = new Launcher.ProcStarter(launcher);
                ByteArrayOutputStream out = null;
                try {
                    out = new ByteArrayOutputStream();
                    starter = starter.cmds(args).stdout((OutputStream)out);
                    int exitCode = launcher.launch(starter).join();
                    String stdout = out.toString(StandardCharsets.UTF_8.name());
                    ProjectUtils.createLogFile(this.workspace, this.test.getId(), stdout, this.listener);
                    if (exitCode == 0) {
                        this.test.setPassed(true);
                        this.listener.getLogger().println("PASS: Test '" + this.test.getName() + "' passed");
                    } else {
                        this.test.setPassed(false);
                        this.listener.getLogger().println("FAIL: Test '" + this.test.getName() + "' failed");
                    }
                    String logsPath = stdout.substring(0, stdout.lastIndexOf("\\run.log"));
                    logsPath = logsPath.substring(logsPath.lastIndexOf("\n") + 1);
                    FilePath junitPath = new FilePath(currentNode.getChannel(), logsPath);
                    if (junitPath.exists()) {
                        String junit = IOUtils.toString((InputStream)junitPath.child("\\junit.xml").read(), (String)StandardCharsets.UTF_8.name());
                        this.workspace.child("results").child(ProjectUtils.getJUnitFileName(this.test.getId())).write(junit, StandardCharsets.UTF_8.name());
                        this.listener.getLogger().println("STOP: Outcome saved to workspace for test '" + this.test.getName() + "'");
                    }
                    throw new IOException("useMango Junit log file not found at path '" + logsPath);
                }
                catch (IOException | IllegalArgumentException | InterruptedException | NullPointerException e) {
                    if (this.workspace != null) {
                        ProjectUtils.createLogFile(this.workspace, this.test.getId(), e.getMessage(), this.listener);
                    }
                    this.listener.error(e.getMessage());
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        this.listener.error(e.getMessage());
                    }
                }
            } else {
                this.test.setPassed(false);
                String failureMessage = "Failed to execute test: Node '" + currentNode.getDisplayName() + "' does not have Windows OS.";
                ProjectUtils.createLogFile(this.workspace, this.test.getId(), failureMessage, this.listener);
                this.listener.error(failureMessage);
            }
        } else {
            this.test.setPassed(false);
            String failureMessage = "Failed to execute test: Node is null.";
            ProjectUtils.createLogFile(this.workspace, this.test.getId(), failureMessage, this.listener);
            this.listener.error(failureMessage);
        }
    }

    public long getEstimatedDuration() {
        return 60000L;
    }
}

