/*
 * Fatture in Cloud API v2 - API Reference
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.1.3
 * Contact: info@fattureincloud.it
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreatePaymentAccountRequest;
import it.fattureincloud.sdk.model.CreatePaymentAccountResponse;
import it.fattureincloud.sdk.model.CreatePaymentMethodRequest;
import it.fattureincloud.sdk.model.CreatePaymentMethodResponse;
import it.fattureincloud.sdk.model.CreateVatTypeRequest;
import it.fattureincloud.sdk.model.CreateVatTypeResponse;
import it.fattureincloud.sdk.model.GetPaymentAccountResponse;
import it.fattureincloud.sdk.model.GetPaymentMethodResponse;
import it.fattureincloud.sdk.model.GetTaxProfileResponse;
import it.fattureincloud.sdk.model.GetVatTypeResponse;
import it.fattureincloud.sdk.model.ModifyPaymentAccountRequest;
import it.fattureincloud.sdk.model.ModifyPaymentAccountResponse;
import it.fattureincloud.sdk.model.ModifyPaymentMethodRequest;
import it.fattureincloud.sdk.model.ModifyPaymentMethodResponse;
import it.fattureincloud.sdk.model.ModifyVatTypeRequest;
import it.fattureincloud.sdk.model.ModifyVatTypeResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SettingsApi {
  private ApiClient localVarApiClient;
  private int localHostIndex;
  private String localCustomBaseUrl;

  public SettingsApi() {
    this(Configuration.getDefaultApiClient());
  }

  public SettingsApi(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return localVarApiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public int getHostIndex() {
    return localHostIndex;
  }

  public void setHostIndex(int hostIndex) {
    this.localHostIndex = hostIndex;
  }

  public String getCustomBaseUrl() {
    return localCustomBaseUrl;
  }

  public void setCustomBaseUrl(String customBaseUrl) {
    this.localCustomBaseUrl = customBaseUrl;
  }

  /**
   * Build call for createPaymentAccount
   *
   * @param companyId The ID of the company. (required)
   * @param createPaymentAccountRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createPaymentAccountCall(
      Integer companyId,
      CreatePaymentAccountRequest createPaymentAccountRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = createPaymentAccountRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/settings/payment_accounts"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call createPaymentAccountValidateBeforeCall(
      Integer companyId,
      CreatePaymentAccountRequest createPaymentAccountRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling createPaymentAccount(Async)");
    }

    return createPaymentAccountCall(companyId, createPaymentAccountRequest, _callback);
  }

  /**
   * Create Payment Account Creates a new payment account.
   *
   * @param companyId The ID of the company. (required)
   * @param createPaymentAccountRequest (optional)
   * @return CreatePaymentAccountResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public CreatePaymentAccountResponse createPaymentAccount(
      Integer companyId, CreatePaymentAccountRequest createPaymentAccountRequest)
      throws ApiException {
    ApiResponse<CreatePaymentAccountResponse> localVarResp =
        createPaymentAccountWithHttpInfo(companyId, createPaymentAccountRequest);
    return localVarResp.getData();
  }

  /**
   * Create Payment Account Creates a new payment account.
   *
   * @param companyId The ID of the company. (required)
   * @param createPaymentAccountRequest (optional)
   * @return ApiResponse&lt;CreatePaymentAccountResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<CreatePaymentAccountResponse> createPaymentAccountWithHttpInfo(
      Integer companyId, CreatePaymentAccountRequest createPaymentAccountRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        createPaymentAccountValidateBeforeCall(companyId, createPaymentAccountRequest, null);
    Type localVarReturnType = new TypeToken<CreatePaymentAccountResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Create Payment Account (asynchronously) Creates a new payment account.
   *
   * @param companyId The ID of the company. (required)
   * @param createPaymentAccountRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createPaymentAccountAsync(
      Integer companyId,
      CreatePaymentAccountRequest createPaymentAccountRequest,
      final ApiCallback<CreatePaymentAccountResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        createPaymentAccountValidateBeforeCall(companyId, createPaymentAccountRequest, _callback);
    Type localVarReturnType = new TypeToken<CreatePaymentAccountResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for createPaymentMethod
   *
   * @param companyId The ID of the company. (required)
   * @param createPaymentMethodRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createPaymentMethodCall(
      Integer companyId,
      CreatePaymentMethodRequest createPaymentMethodRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = createPaymentMethodRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/settings/payment_methods"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call createPaymentMethodValidateBeforeCall(
      Integer companyId,
      CreatePaymentMethodRequest createPaymentMethodRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling createPaymentMethod(Async)");
    }

    return createPaymentMethodCall(companyId, createPaymentMethodRequest, _callback);
  }

  /**
   * Create Payment Method Creates a new payment method.
   *
   * @param companyId The ID of the company. (required)
   * @param createPaymentMethodRequest (optional)
   * @return CreatePaymentMethodResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public CreatePaymentMethodResponse createPaymentMethod(
      Integer companyId, CreatePaymentMethodRequest createPaymentMethodRequest)
      throws ApiException {
    ApiResponse<CreatePaymentMethodResponse> localVarResp =
        createPaymentMethodWithHttpInfo(companyId, createPaymentMethodRequest);
    return localVarResp.getData();
  }

  /**
   * Create Payment Method Creates a new payment method.
   *
   * @param companyId The ID of the company. (required)
   * @param createPaymentMethodRequest (optional)
   * @return ApiResponse&lt;CreatePaymentMethodResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<CreatePaymentMethodResponse> createPaymentMethodWithHttpInfo(
      Integer companyId, CreatePaymentMethodRequest createPaymentMethodRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        createPaymentMethodValidateBeforeCall(companyId, createPaymentMethodRequest, null);
    Type localVarReturnType = new TypeToken<CreatePaymentMethodResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Create Payment Method (asynchronously) Creates a new payment method.
   *
   * @param companyId The ID of the company. (required)
   * @param createPaymentMethodRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createPaymentMethodAsync(
      Integer companyId,
      CreatePaymentMethodRequest createPaymentMethodRequest,
      final ApiCallback<CreatePaymentMethodResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        createPaymentMethodValidateBeforeCall(companyId, createPaymentMethodRequest, _callback);
    Type localVarReturnType = new TypeToken<CreatePaymentMethodResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for createVatType
   *
   * @param companyId The ID of the company. (required)
   * @param createVatTypeRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createVatTypeCall(
      Integer companyId, CreateVatTypeRequest createVatTypeRequest, final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = createVatTypeRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/settings/vat_types"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call createVatTypeValidateBeforeCall(
      Integer companyId, CreateVatTypeRequest createVatTypeRequest, final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling createVatType(Async)");
    }

    return createVatTypeCall(companyId, createVatTypeRequest, _callback);
  }

  /**
   * Create Vat Type Creates a vat type.
   *
   * @param companyId The ID of the company. (required)
   * @param createVatTypeRequest (optional)
   * @return CreateVatTypeResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public CreateVatTypeResponse createVatType(
      Integer companyId, CreateVatTypeRequest createVatTypeRequest) throws ApiException {
    ApiResponse<CreateVatTypeResponse> localVarResp =
        createVatTypeWithHttpInfo(companyId, createVatTypeRequest);
    return localVarResp.getData();
  }

  /**
   * Create Vat Type Creates a vat type.
   *
   * @param companyId The ID of the company. (required)
   * @param createVatTypeRequest (optional)
   * @return ApiResponse&lt;CreateVatTypeResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<CreateVatTypeResponse> createVatTypeWithHttpInfo(
      Integer companyId, CreateVatTypeRequest createVatTypeRequest) throws ApiException {
    okhttp3.Call localVarCall =
        createVatTypeValidateBeforeCall(companyId, createVatTypeRequest, null);
    Type localVarReturnType = new TypeToken<CreateVatTypeResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Create Vat Type (asynchronously) Creates a vat type.
   *
   * @param companyId The ID of the company. (required)
   * @param createVatTypeRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createVatTypeAsync(
      Integer companyId,
      CreateVatTypeRequest createVatTypeRequest,
      final ApiCallback<CreateVatTypeResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        createVatTypeValidateBeforeCall(companyId, createVatTypeRequest, _callback);
    Type localVarReturnType = new TypeToken<CreateVatTypeResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for deletePaymentAccount
   *
   * @param companyId The ID of the company. (required)
   * @param paymentAccountId The Referred Payment Account Id. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deletePaymentAccountCall(
      Integer companyId, Integer paymentAccountId, final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/settings/payment_accounts/{payment_account_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "payment_account_id" + "}",
                localVarApiClient.escapeString(paymentAccountId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call deletePaymentAccountValidateBeforeCall(
      Integer companyId, Integer paymentAccountId, final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling deletePaymentAccount(Async)");
    }

    // verify the required parameter 'paymentAccountId' is set
    if (paymentAccountId == null) {
      throw new ApiException(
          "Missing the required parameter 'paymentAccountId' when calling deletePaymentAccount(Async)");
    }

    return deletePaymentAccountCall(companyId, paymentAccountId, _callback);
  }

  /**
   * Delete Payment Account Deletes the specified payment account.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentAccountId The Referred Payment Account Id. (required)
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public void deletePaymentAccount(Integer companyId, Integer paymentAccountId)
      throws ApiException {
    deletePaymentAccountWithHttpInfo(companyId, paymentAccountId);
  }

  /**
   * Delete Payment Account Deletes the specified payment account.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentAccountId The Referred Payment Account Id. (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<Void> deletePaymentAccountWithHttpInfo(
      Integer companyId, Integer paymentAccountId) throws ApiException {
    okhttp3.Call localVarCall =
        deletePaymentAccountValidateBeforeCall(companyId, paymentAccountId, null);
    return localVarApiClient.execute(localVarCall);
  }

  /**
   * Delete Payment Account (asynchronously) Deletes the specified payment account.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentAccountId The Referred Payment Account Id. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deletePaymentAccountAsync(
      Integer companyId, Integer paymentAccountId, final ApiCallback<Void> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        deletePaymentAccountValidateBeforeCall(companyId, paymentAccountId, _callback);
    localVarApiClient.executeAsync(localVarCall, _callback);
    return localVarCall;
  }
  /**
   * Build call for deletePaymentMethod
   *
   * @param companyId The ID of the company. (required)
   * @param paymentMethodId The Referred Payment Method Id. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deletePaymentMethodCall(
      Integer companyId, Integer paymentMethodId, final ApiCallback _callback) throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/settings/payment_methods/{payment_method_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "payment_method_id" + "}",
                localVarApiClient.escapeString(paymentMethodId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call deletePaymentMethodValidateBeforeCall(
      Integer companyId, Integer paymentMethodId, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling deletePaymentMethod(Async)");
    }

    // verify the required parameter 'paymentMethodId' is set
    if (paymentMethodId == null) {
      throw new ApiException(
          "Missing the required parameter 'paymentMethodId' when calling deletePaymentMethod(Async)");
    }

    return deletePaymentMethodCall(companyId, paymentMethodId, _callback);
  }

  /**
   * Delete Payment Method Deletes the specified payment method.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentMethodId The Referred Payment Method Id. (required)
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public void deletePaymentMethod(Integer companyId, Integer paymentMethodId) throws ApiException {
    deletePaymentMethodWithHttpInfo(companyId, paymentMethodId);
  }

  /**
   * Delete Payment Method Deletes the specified payment method.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentMethodId The Referred Payment Method Id. (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<Void> deletePaymentMethodWithHttpInfo(
      Integer companyId, Integer paymentMethodId) throws ApiException {
    okhttp3.Call localVarCall =
        deletePaymentMethodValidateBeforeCall(companyId, paymentMethodId, null);
    return localVarApiClient.execute(localVarCall);
  }

  /**
   * Delete Payment Method (asynchronously) Deletes the specified payment method.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentMethodId The Referred Payment Method Id. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deletePaymentMethodAsync(
      Integer companyId, Integer paymentMethodId, final ApiCallback<Void> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        deletePaymentMethodValidateBeforeCall(companyId, paymentMethodId, _callback);
    localVarApiClient.executeAsync(localVarCall, _callback);
    return localVarCall;
  }
  /**
   * Build call for deleteVatType
   *
   * @param companyId The ID of the company. (required)
   * @param vatTypeId The Referred Vat Type Id. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deleteVatTypeCall(
      Integer companyId, Integer vatTypeId, final ApiCallback _callback) throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/settings/vat_types/{vat_type_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "vat_type_id" + "}", localVarApiClient.escapeString(vatTypeId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call deleteVatTypeValidateBeforeCall(
      Integer companyId, Integer vatTypeId, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling deleteVatType(Async)");
    }

    // verify the required parameter 'vatTypeId' is set
    if (vatTypeId == null) {
      throw new ApiException(
          "Missing the required parameter 'vatTypeId' when calling deleteVatType(Async)");
    }

    return deleteVatTypeCall(companyId, vatTypeId, _callback);
  }

  /**
   * Delete Vat Type Deletes the specified vat type.
   *
   * @param companyId The ID of the company. (required)
   * @param vatTypeId The Referred Vat Type Id. (required)
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public void deleteVatType(Integer companyId, Integer vatTypeId) throws ApiException {
    deleteVatTypeWithHttpInfo(companyId, vatTypeId);
  }

  /**
   * Delete Vat Type Deletes the specified vat type.
   *
   * @param companyId The ID of the company. (required)
   * @param vatTypeId The Referred Vat Type Id. (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<Void> deleteVatTypeWithHttpInfo(Integer companyId, Integer vatTypeId)
      throws ApiException {
    okhttp3.Call localVarCall = deleteVatTypeValidateBeforeCall(companyId, vatTypeId, null);
    return localVarApiClient.execute(localVarCall);
  }

  /**
   * Delete Vat Type (asynchronously) Deletes the specified vat type.
   *
   * @param companyId The ID of the company. (required)
   * @param vatTypeId The Referred Vat Type Id. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deleteVatTypeAsync(
      Integer companyId, Integer vatTypeId, final ApiCallback<Void> _callback) throws ApiException {

    okhttp3.Call localVarCall = deleteVatTypeValidateBeforeCall(companyId, vatTypeId, _callback);
    localVarApiClient.executeAsync(localVarCall, _callback);
    return localVarCall;
  }
  /**
   * Build call for getPaymentAccount
   *
   * @param companyId The ID of the company. (required)
   * @param paymentAccountId The Referred Payment Account Id. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getPaymentAccountCall(
      Integer companyId,
      Integer paymentAccountId,
      String fields,
      String fieldset,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/settings/payment_accounts/{payment_account_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "payment_account_id" + "}",
                localVarApiClient.escapeString(paymentAccountId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (fields != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fields", fields));
    }

    if (fieldset != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fieldset", fieldset));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getPaymentAccountValidateBeforeCall(
      Integer companyId,
      Integer paymentAccountId,
      String fields,
      String fieldset,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getPaymentAccount(Async)");
    }

    // verify the required parameter 'paymentAccountId' is set
    if (paymentAccountId == null) {
      throw new ApiException(
          "Missing the required parameter 'paymentAccountId' when calling getPaymentAccount(Async)");
    }

    return getPaymentAccountCall(companyId, paymentAccountId, fields, fieldset, _callback);
  }

  /**
   * Get Payment Account Gets the specified payment account.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentAccountId The Referred Payment Account Id. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @return GetPaymentAccountResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public GetPaymentAccountResponse getPaymentAccount(
      Integer companyId, Integer paymentAccountId, String fields, String fieldset)
      throws ApiException {
    ApiResponse<GetPaymentAccountResponse> localVarResp =
        getPaymentAccountWithHttpInfo(companyId, paymentAccountId, fields, fieldset);
    return localVarResp.getData();
  }

  /**
   * Get Payment Account Gets the specified payment account.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentAccountId The Referred Payment Account Id. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @return ApiResponse&lt;GetPaymentAccountResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetPaymentAccountResponse> getPaymentAccountWithHttpInfo(
      Integer companyId, Integer paymentAccountId, String fields, String fieldset)
      throws ApiException {
    okhttp3.Call localVarCall =
        getPaymentAccountValidateBeforeCall(companyId, paymentAccountId, fields, fieldset, null);
    Type localVarReturnType = new TypeToken<GetPaymentAccountResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get Payment Account (asynchronously) Gets the specified payment account.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentAccountId The Referred Payment Account Id. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getPaymentAccountAsync(
      Integer companyId,
      Integer paymentAccountId,
      String fields,
      String fieldset,
      final ApiCallback<GetPaymentAccountResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        getPaymentAccountValidateBeforeCall(
            companyId, paymentAccountId, fields, fieldset, _callback);
    Type localVarReturnType = new TypeToken<GetPaymentAccountResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getPaymentMethod
   *
   * @param companyId The ID of the company. (required)
   * @param paymentMethodId The Referred Payment Method Id. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getPaymentMethodCall(
      Integer companyId,
      Integer paymentMethodId,
      String fields,
      String fieldset,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/settings/payment_methods/{payment_method_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "payment_method_id" + "}",
                localVarApiClient.escapeString(paymentMethodId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (fields != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fields", fields));
    }

    if (fieldset != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fieldset", fieldset));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getPaymentMethodValidateBeforeCall(
      Integer companyId,
      Integer paymentMethodId,
      String fields,
      String fieldset,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getPaymentMethod(Async)");
    }

    // verify the required parameter 'paymentMethodId' is set
    if (paymentMethodId == null) {
      throw new ApiException(
          "Missing the required parameter 'paymentMethodId' when calling getPaymentMethod(Async)");
    }

    return getPaymentMethodCall(companyId, paymentMethodId, fields, fieldset, _callback);
  }

  /**
   * Get Payment Method Gets the specified payment method.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentMethodId The Referred Payment Method Id. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @return GetPaymentMethodResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public GetPaymentMethodResponse getPaymentMethod(
      Integer companyId, Integer paymentMethodId, String fields, String fieldset)
      throws ApiException {
    ApiResponse<GetPaymentMethodResponse> localVarResp =
        getPaymentMethodWithHttpInfo(companyId, paymentMethodId, fields, fieldset);
    return localVarResp.getData();
  }

  /**
   * Get Payment Method Gets the specified payment method.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentMethodId The Referred Payment Method Id. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @return ApiResponse&lt;GetPaymentMethodResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetPaymentMethodResponse> getPaymentMethodWithHttpInfo(
      Integer companyId, Integer paymentMethodId, String fields, String fieldset)
      throws ApiException {
    okhttp3.Call localVarCall =
        getPaymentMethodValidateBeforeCall(companyId, paymentMethodId, fields, fieldset, null);
    Type localVarReturnType = new TypeToken<GetPaymentMethodResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get Payment Method (asynchronously) Gets the specified payment method.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentMethodId The Referred Payment Method Id. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getPaymentMethodAsync(
      Integer companyId,
      Integer paymentMethodId,
      String fields,
      String fieldset,
      final ApiCallback<GetPaymentMethodResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        getPaymentMethodValidateBeforeCall(companyId, paymentMethodId, fields, fieldset, _callback);
    Type localVarReturnType = new TypeToken<GetPaymentMethodResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getTaxProfile
   *
   * @param companyId The ID of the company. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getTaxProfileCall(Integer companyId, final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/settings/tax_profile"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getTaxProfileValidateBeforeCall(
      Integer companyId, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getTaxProfile(Async)");
    }

    return getTaxProfileCall(companyId, _callback);
  }

  /**
   * Get Tax Profile Gets the Tax Profile
   *
   * @param companyId The ID of the company. (required)
   * @return GetTaxProfileResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public GetTaxProfileResponse getTaxProfile(Integer companyId) throws ApiException {
    ApiResponse<GetTaxProfileResponse> localVarResp = getTaxProfileWithHttpInfo(companyId);
    return localVarResp.getData();
  }

  /**
   * Get Tax Profile Gets the Tax Profile
   *
   * @param companyId The ID of the company. (required)
   * @return ApiResponse&lt;GetTaxProfileResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetTaxProfileResponse> getTaxProfileWithHttpInfo(Integer companyId)
      throws ApiException {
    okhttp3.Call localVarCall = getTaxProfileValidateBeforeCall(companyId, null);
    Type localVarReturnType = new TypeToken<GetTaxProfileResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get Tax Profile (asynchronously) Gets the Tax Profile
   *
   * @param companyId The ID of the company. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getTaxProfileAsync(
      Integer companyId, final ApiCallback<GetTaxProfileResponse> _callback) throws ApiException {

    okhttp3.Call localVarCall = getTaxProfileValidateBeforeCall(companyId, _callback);
    Type localVarReturnType = new TypeToken<GetTaxProfileResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getVatType
   *
   * @param companyId The ID of the company. (required)
   * @param vatTypeId The Referred Vat Type Id. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getVatTypeCall(
      Integer companyId, Integer vatTypeId, final ApiCallback _callback) throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/settings/vat_types/{vat_type_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "vat_type_id" + "}", localVarApiClient.escapeString(vatTypeId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getVatTypeValidateBeforeCall(
      Integer companyId, Integer vatTypeId, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getVatType(Async)");
    }

    // verify the required parameter 'vatTypeId' is set
    if (vatTypeId == null) {
      throw new ApiException(
          "Missing the required parameter 'vatTypeId' when calling getVatType(Async)");
    }

    return getVatTypeCall(companyId, vatTypeId, _callback);
  }

  /**
   * Get Vat Type Gets the specified vat type.
   *
   * @param companyId The ID of the company. (required)
   * @param vatTypeId The Referred Vat Type Id. (required)
   * @return GetVatTypeResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public GetVatTypeResponse getVatType(Integer companyId, Integer vatTypeId) throws ApiException {
    ApiResponse<GetVatTypeResponse> localVarResp = getVatTypeWithHttpInfo(companyId, vatTypeId);
    return localVarResp.getData();
  }

  /**
   * Get Vat Type Gets the specified vat type.
   *
   * @param companyId The ID of the company. (required)
   * @param vatTypeId The Referred Vat Type Id. (required)
   * @return ApiResponse&lt;GetVatTypeResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetVatTypeResponse> getVatTypeWithHttpInfo(
      Integer companyId, Integer vatTypeId) throws ApiException {
    okhttp3.Call localVarCall = getVatTypeValidateBeforeCall(companyId, vatTypeId, null);
    Type localVarReturnType = new TypeToken<GetVatTypeResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get Vat Type (asynchronously) Gets the specified vat type.
   *
   * @param companyId The ID of the company. (required)
   * @param vatTypeId The Referred Vat Type Id. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getVatTypeAsync(
      Integer companyId, Integer vatTypeId, final ApiCallback<GetVatTypeResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall = getVatTypeValidateBeforeCall(companyId, vatTypeId, _callback);
    Type localVarReturnType = new TypeToken<GetVatTypeResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for modifyPaymentAccount
   *
   * @param companyId The ID of the company. (required)
   * @param paymentAccountId The Referred Payment Account Id. (required)
   * @param modifyPaymentAccountRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyPaymentAccountCall(
      Integer companyId,
      Integer paymentAccountId,
      ModifyPaymentAccountRequest modifyPaymentAccountRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = modifyPaymentAccountRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/settings/payment_accounts/{payment_account_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "payment_account_id" + "}",
                localVarApiClient.escapeString(paymentAccountId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call modifyPaymentAccountValidateBeforeCall(
      Integer companyId,
      Integer paymentAccountId,
      ModifyPaymentAccountRequest modifyPaymentAccountRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling modifyPaymentAccount(Async)");
    }

    // verify the required parameter 'paymentAccountId' is set
    if (paymentAccountId == null) {
      throw new ApiException(
          "Missing the required parameter 'paymentAccountId' when calling modifyPaymentAccount(Async)");
    }

    return modifyPaymentAccountCall(
        companyId, paymentAccountId, modifyPaymentAccountRequest, _callback);
  }

  /**
   * Modify Payment Account Modifies the specified payment account.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentAccountId The Referred Payment Account Id. (required)
   * @param modifyPaymentAccountRequest (optional)
   * @return ModifyPaymentAccountResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ModifyPaymentAccountResponse modifyPaymentAccount(
      Integer companyId,
      Integer paymentAccountId,
      ModifyPaymentAccountRequest modifyPaymentAccountRequest)
      throws ApiException {
    ApiResponse<ModifyPaymentAccountResponse> localVarResp =
        modifyPaymentAccountWithHttpInfo(companyId, paymentAccountId, modifyPaymentAccountRequest);
    return localVarResp.getData();
  }

  /**
   * Modify Payment Account Modifies the specified payment account.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentAccountId The Referred Payment Account Id. (required)
   * @param modifyPaymentAccountRequest (optional)
   * @return ApiResponse&lt;ModifyPaymentAccountResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<ModifyPaymentAccountResponse> modifyPaymentAccountWithHttpInfo(
      Integer companyId,
      Integer paymentAccountId,
      ModifyPaymentAccountRequest modifyPaymentAccountRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        modifyPaymentAccountValidateBeforeCall(
            companyId, paymentAccountId, modifyPaymentAccountRequest, null);
    Type localVarReturnType = new TypeToken<ModifyPaymentAccountResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Modify Payment Account (asynchronously) Modifies the specified payment account.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentAccountId The Referred Payment Account Id. (required)
   * @param modifyPaymentAccountRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyPaymentAccountAsync(
      Integer companyId,
      Integer paymentAccountId,
      ModifyPaymentAccountRequest modifyPaymentAccountRequest,
      final ApiCallback<ModifyPaymentAccountResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        modifyPaymentAccountValidateBeforeCall(
            companyId, paymentAccountId, modifyPaymentAccountRequest, _callback);
    Type localVarReturnType = new TypeToken<ModifyPaymentAccountResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for modifyPaymentMethod
   *
   * @param companyId The ID of the company. (required)
   * @param paymentMethodId The Referred Payment Method Id. (required)
   * @param modifyPaymentMethodRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyPaymentMethodCall(
      Integer companyId,
      Integer paymentMethodId,
      ModifyPaymentMethodRequest modifyPaymentMethodRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = modifyPaymentMethodRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/settings/payment_methods/{payment_method_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "payment_method_id" + "}",
                localVarApiClient.escapeString(paymentMethodId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call modifyPaymentMethodValidateBeforeCall(
      Integer companyId,
      Integer paymentMethodId,
      ModifyPaymentMethodRequest modifyPaymentMethodRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling modifyPaymentMethod(Async)");
    }

    // verify the required parameter 'paymentMethodId' is set
    if (paymentMethodId == null) {
      throw new ApiException(
          "Missing the required parameter 'paymentMethodId' when calling modifyPaymentMethod(Async)");
    }

    return modifyPaymentMethodCall(
        companyId, paymentMethodId, modifyPaymentMethodRequest, _callback);
  }

  /**
   * Modify Payment Method Modifies the specified payment method.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentMethodId The Referred Payment Method Id. (required)
   * @param modifyPaymentMethodRequest (optional)
   * @return ModifyPaymentMethodResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ModifyPaymentMethodResponse modifyPaymentMethod(
      Integer companyId,
      Integer paymentMethodId,
      ModifyPaymentMethodRequest modifyPaymentMethodRequest)
      throws ApiException {
    ApiResponse<ModifyPaymentMethodResponse> localVarResp =
        modifyPaymentMethodWithHttpInfo(companyId, paymentMethodId, modifyPaymentMethodRequest);
    return localVarResp.getData();
  }

  /**
   * Modify Payment Method Modifies the specified payment method.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentMethodId The Referred Payment Method Id. (required)
   * @param modifyPaymentMethodRequest (optional)
   * @return ApiResponse&lt;ModifyPaymentMethodResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<ModifyPaymentMethodResponse> modifyPaymentMethodWithHttpInfo(
      Integer companyId,
      Integer paymentMethodId,
      ModifyPaymentMethodRequest modifyPaymentMethodRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        modifyPaymentMethodValidateBeforeCall(
            companyId, paymentMethodId, modifyPaymentMethodRequest, null);
    Type localVarReturnType = new TypeToken<ModifyPaymentMethodResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Modify Payment Method (asynchronously) Modifies the specified payment method.
   *
   * @param companyId The ID of the company. (required)
   * @param paymentMethodId The Referred Payment Method Id. (required)
   * @param modifyPaymentMethodRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyPaymentMethodAsync(
      Integer companyId,
      Integer paymentMethodId,
      ModifyPaymentMethodRequest modifyPaymentMethodRequest,
      final ApiCallback<ModifyPaymentMethodResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        modifyPaymentMethodValidateBeforeCall(
            companyId, paymentMethodId, modifyPaymentMethodRequest, _callback);
    Type localVarReturnType = new TypeToken<ModifyPaymentMethodResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for modifyVatType
   *
   * @param companyId The ID of the company. (required)
   * @param vatTypeId The Referred Vat Type Id. (required)
   * @param modifyVatTypeRequest (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyVatTypeCall(
      Integer companyId,
      Integer vatTypeId,
      ModifyVatTypeRequest modifyVatTypeRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = modifyVatTypeRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/settings/vat_types/{vat_type_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "vat_type_id" + "}", localVarApiClient.escapeString(vatTypeId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call modifyVatTypeValidateBeforeCall(
      Integer companyId,
      Integer vatTypeId,
      ModifyVatTypeRequest modifyVatTypeRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling modifyVatType(Async)");
    }

    // verify the required parameter 'vatTypeId' is set
    if (vatTypeId == null) {
      throw new ApiException(
          "Missing the required parameter 'vatTypeId' when calling modifyVatType(Async)");
    }

    return modifyVatTypeCall(companyId, vatTypeId, modifyVatTypeRequest, _callback);
  }

  /**
   * Modify Vat Type Modifies the specified vat type.
   *
   * @param companyId The ID of the company. (required)
   * @param vatTypeId The Referred Vat Type Id. (required)
   * @param modifyVatTypeRequest (optional)
   * @return ModifyVatTypeResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ModifyVatTypeResponse modifyVatType(
      Integer companyId, Integer vatTypeId, ModifyVatTypeRequest modifyVatTypeRequest)
      throws ApiException {
    ApiResponse<ModifyVatTypeResponse> localVarResp =
        modifyVatTypeWithHttpInfo(companyId, vatTypeId, modifyVatTypeRequest);
    return localVarResp.getData();
  }

  /**
   * Modify Vat Type Modifies the specified vat type.
   *
   * @param companyId The ID of the company. (required)
   * @param vatTypeId The Referred Vat Type Id. (required)
   * @param modifyVatTypeRequest (optional)
   * @return ApiResponse&lt;ModifyVatTypeResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<ModifyVatTypeResponse> modifyVatTypeWithHttpInfo(
      Integer companyId, Integer vatTypeId, ModifyVatTypeRequest modifyVatTypeRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        modifyVatTypeValidateBeforeCall(companyId, vatTypeId, modifyVatTypeRequest, null);
    Type localVarReturnType = new TypeToken<ModifyVatTypeResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Modify Vat Type (asynchronously) Modifies the specified vat type.
   *
   * @param companyId The ID of the company. (required)
   * @param vatTypeId The Referred Vat Type Id. (required)
   * @param modifyVatTypeRequest (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyVatTypeAsync(
      Integer companyId,
      Integer vatTypeId,
      ModifyVatTypeRequest modifyVatTypeRequest,
      final ApiCallback<ModifyVatTypeResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        modifyVatTypeValidateBeforeCall(companyId, vatTypeId, modifyVatTypeRequest, _callback);
    Type localVarReturnType = new TypeToken<ModifyVatTypeResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
}
