/*
 * Fatture in Cloud API v2 - API Reference
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.1.3
 * Contact: info@fattureincloud.it
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreateReceiptRequest;
import it.fattureincloud.sdk.model.CreateReceiptResponse;
import it.fattureincloud.sdk.model.GetReceiptPreCreateInfoResponse;
import it.fattureincloud.sdk.model.GetReceiptResponse;
import it.fattureincloud.sdk.model.GetReceiptsMonthlyTotalsResponse;
import it.fattureincloud.sdk.model.ListReceiptsResponse;
import it.fattureincloud.sdk.model.ModifyReceiptRequest;
import it.fattureincloud.sdk.model.ModifyReceiptResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReceiptsApi {
  private ApiClient localVarApiClient;
  private int localHostIndex;
  private String localCustomBaseUrl;

  public ReceiptsApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ReceiptsApi(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return localVarApiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public int getHostIndex() {
    return localHostIndex;
  }

  public void setHostIndex(int hostIndex) {
    this.localHostIndex = hostIndex;
  }

  public String getCustomBaseUrl() {
    return localCustomBaseUrl;
  }

  public void setCustomBaseUrl(String customBaseUrl) {
    this.localCustomBaseUrl = customBaseUrl;
  }

  /**
   * Build call for createReceipt
   *
   * @param companyId The ID of the company. (required)
   * @param createReceiptRequest The Receipt to create. (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Created Receipt. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createReceiptCall(
      Integer companyId, CreateReceiptRequest createReceiptRequest, final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = createReceiptRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/receipts"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call createReceiptValidateBeforeCall(
      Integer companyId, CreateReceiptRequest createReceiptRequest, final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling createReceipt(Async)");
    }

    return createReceiptCall(companyId, createReceiptRequest, _callback);
  }

  /**
   * Create Receipt Creates a new receipt.
   *
   * @param companyId The ID of the company. (required)
   * @param createReceiptRequest The Receipt to create. (optional)
   * @return CreateReceiptResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Created Receipt. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public CreateReceiptResponse createReceipt(
      Integer companyId, CreateReceiptRequest createReceiptRequest) throws ApiException {
    ApiResponse<CreateReceiptResponse> localVarResp =
        createReceiptWithHttpInfo(companyId, createReceiptRequest);
    return localVarResp.getData();
  }

  /**
   * Create Receipt Creates a new receipt.
   *
   * @param companyId The ID of the company. (required)
   * @param createReceiptRequest The Receipt to create. (optional)
   * @return ApiResponse&lt;CreateReceiptResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Created Receipt. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<CreateReceiptResponse> createReceiptWithHttpInfo(
      Integer companyId, CreateReceiptRequest createReceiptRequest) throws ApiException {
    okhttp3.Call localVarCall =
        createReceiptValidateBeforeCall(companyId, createReceiptRequest, null);
    Type localVarReturnType = new TypeToken<CreateReceiptResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Create Receipt (asynchronously) Creates a new receipt.
   *
   * @param companyId The ID of the company. (required)
   * @param createReceiptRequest The Receipt to create. (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Created Receipt. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createReceiptAsync(
      Integer companyId,
      CreateReceiptRequest createReceiptRequest,
      final ApiCallback<CreateReceiptResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        createReceiptValidateBeforeCall(companyId, createReceiptRequest, _callback);
    Type localVarReturnType = new TypeToken<CreateReceiptResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for deleteReceipt
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document removed. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deleteReceiptCall(
      Integer companyId, Integer documentId, final ApiCallback _callback) throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/receipts/{document_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call deleteReceiptValidateBeforeCall(
      Integer companyId, Integer documentId, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling deleteReceipt(Async)");
    }

    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(
          "Missing the required parameter 'documentId' when calling deleteReceipt(Async)");
    }

    return deleteReceiptCall(companyId, documentId, _callback);
  }

  /**
   * Delete Receipt Deletes the specified receipt.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document removed. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public void deleteReceipt(Integer companyId, Integer documentId) throws ApiException {
    deleteReceiptWithHttpInfo(companyId, documentId);
  }

  /**
   * Delete Receipt Deletes the specified receipt.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document removed. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<Void> deleteReceiptWithHttpInfo(Integer companyId, Integer documentId)
      throws ApiException {
    okhttp3.Call localVarCall = deleteReceiptValidateBeforeCall(companyId, documentId, null);
    return localVarApiClient.execute(localVarCall);
  }

  /**
   * Delete Receipt (asynchronously) Deletes the specified receipt.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document removed. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deleteReceiptAsync(
      Integer companyId, Integer documentId, final ApiCallback<Void> _callback)
      throws ApiException {

    okhttp3.Call localVarCall = deleteReceiptValidateBeforeCall(companyId, documentId, _callback);
    localVarApiClient.executeAsync(localVarCall, _callback);
    return localVarCall;
  }
  /**
   * Build call for getReceipt
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Receipt Details. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getReceiptCall(
      Integer companyId,
      Integer documentId,
      String fields,
      String fieldset,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/receipts/{document_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (fields != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fields", fields));
    }

    if (fieldset != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fieldset", fieldset));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getReceiptValidateBeforeCall(
      Integer companyId,
      Integer documentId,
      String fields,
      String fieldset,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getReceipt(Async)");
    }

    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(
          "Missing the required parameter 'documentId' when calling getReceipt(Async)");
    }

    return getReceiptCall(companyId, documentId, fields, fieldset, _callback);
  }

  /**
   * Get Receipt Gets the specified receipt.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @return GetReceiptResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Receipt Details. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public GetReceiptResponse getReceipt(
      Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
    ApiResponse<GetReceiptResponse> localVarResp =
        getReceiptWithHttpInfo(companyId, documentId, fields, fieldset);
    return localVarResp.getData();
  }

  /**
   * Get Receipt Gets the specified receipt.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @return ApiResponse&lt;GetReceiptResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Receipt Details. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetReceiptResponse> getReceiptWithHttpInfo(
      Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
    okhttp3.Call localVarCall =
        getReceiptValidateBeforeCall(companyId, documentId, fields, fieldset, null);
    Type localVarReturnType = new TypeToken<GetReceiptResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get Receipt (asynchronously) Gets the specified receipt.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Receipt Details. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getReceiptAsync(
      Integer companyId,
      Integer documentId,
      String fields,
      String fieldset,
      final ApiCallback<GetReceiptResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        getReceiptValidateBeforeCall(companyId, documentId, fields, fieldset, _callback);
    Type localVarReturnType = new TypeToken<GetReceiptResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getReceiptPreCreateInfo
   *
   * @param companyId The ID of the company. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Pre-create info. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getReceiptPreCreateInfoCall(Integer companyId, final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/receipts/info"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getReceiptPreCreateInfoValidateBeforeCall(
      Integer companyId, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getReceiptPreCreateInfo(Async)");
    }

    return getReceiptPreCreateInfoCall(companyId, _callback);
  }

  /**
   * Get Receipt Pre-Create Info Retrieves the information useful while creating a new receipt.
   *
   * @param companyId The ID of the company. (required)
   * @return GetReceiptPreCreateInfoResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Pre-create info. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public GetReceiptPreCreateInfoResponse getReceiptPreCreateInfo(Integer companyId)
      throws ApiException {
    ApiResponse<GetReceiptPreCreateInfoResponse> localVarResp =
        getReceiptPreCreateInfoWithHttpInfo(companyId);
    return localVarResp.getData();
  }

  /**
   * Get Receipt Pre-Create Info Retrieves the information useful while creating a new receipt.
   *
   * @param companyId The ID of the company. (required)
   * @return ApiResponse&lt;GetReceiptPreCreateInfoResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Pre-create info. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetReceiptPreCreateInfoResponse> getReceiptPreCreateInfoWithHttpInfo(
      Integer companyId) throws ApiException {
    okhttp3.Call localVarCall = getReceiptPreCreateInfoValidateBeforeCall(companyId, null);
    Type localVarReturnType = new TypeToken<GetReceiptPreCreateInfoResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get Receipt Pre-Create Info (asynchronously) Retrieves the information useful while creating a
   * new receipt.
   *
   * @param companyId The ID of the company. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Pre-create info. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getReceiptPreCreateInfoAsync(
      Integer companyId, final ApiCallback<GetReceiptPreCreateInfoResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall = getReceiptPreCreateInfoValidateBeforeCall(companyId, _callback);
    Type localVarReturnType = new TypeToken<GetReceiptPreCreateInfoResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getReceiptsMonthlyTotals
   *
   * @param companyId The ID of the company. (required)
   * @param type Receipt Type (required)
   * @param year Year for which you want monthly totals (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Monthly Totals. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getReceiptsMonthlyTotalsCall(
      Integer companyId, String type, String year, final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/receipts/monthly_totals"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (type != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
    }

    if (year != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("year", year));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getReceiptsMonthlyTotalsValidateBeforeCall(
      Integer companyId, String type, String year, final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getReceiptsMonthlyTotals(Async)");
    }

    // verify the required parameter 'type' is set
    if (type == null) {
      throw new ApiException(
          "Missing the required parameter 'type' when calling getReceiptsMonthlyTotals(Async)");
    }

    // verify the required parameter 'year' is set
    if (year == null) {
      throw new ApiException(
          "Missing the required parameter 'year' when calling getReceiptsMonthlyTotals(Async)");
    }

    return getReceiptsMonthlyTotalsCall(companyId, type, year, _callback);
  }

  /**
   * Get Receipts Monthly Totals Returns the monthly totals by year and receipt type.
   *
   * @param companyId The ID of the company. (required)
   * @param type Receipt Type (required)
   * @param year Year for which you want monthly totals (required)
   * @return GetReceiptsMonthlyTotalsResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Monthly Totals. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public GetReceiptsMonthlyTotalsResponse getReceiptsMonthlyTotals(
      Integer companyId, String type, String year) throws ApiException {
    ApiResponse<GetReceiptsMonthlyTotalsResponse> localVarResp =
        getReceiptsMonthlyTotalsWithHttpInfo(companyId, type, year);
    return localVarResp.getData();
  }

  /**
   * Get Receipts Monthly Totals Returns the monthly totals by year and receipt type.
   *
   * @param companyId The ID of the company. (required)
   * @param type Receipt Type (required)
   * @param year Year for which you want monthly totals (required)
   * @return ApiResponse&lt;GetReceiptsMonthlyTotalsResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Monthly Totals. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetReceiptsMonthlyTotalsResponse> getReceiptsMonthlyTotalsWithHttpInfo(
      Integer companyId, String type, String year) throws ApiException {
    okhttp3.Call localVarCall =
        getReceiptsMonthlyTotalsValidateBeforeCall(companyId, type, year, null);
    Type localVarReturnType = new TypeToken<GetReceiptsMonthlyTotalsResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get Receipts Monthly Totals (asynchronously) Returns the monthly totals by year and receipt
   * type.
   *
   * @param companyId The ID of the company. (required)
   * @param type Receipt Type (required)
   * @param year Year for which you want monthly totals (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Monthly Totals. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getReceiptsMonthlyTotalsAsync(
      Integer companyId,
      String type,
      String year,
      final ApiCallback<GetReceiptsMonthlyTotalsResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        getReceiptsMonthlyTotalsValidateBeforeCall(companyId, type, year, _callback);
    Type localVarReturnType = new TypeToken<GetReceiptsMonthlyTotalsResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for listReceipts
   *
   * @param companyId The ID of the company. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param page The page to retrieve. (optional, default to 1)
   * @param perPage The size of the page. (optional, default to 5)
   * @param sort List of comma-separated fields for result sorting (minus for desc sorting).
   *     (optional)
   * @param q Query for filtering the results. (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Receipts list. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call listReceiptsCall(
      Integer companyId,
      String fields,
      String fieldset,
      Integer page,
      Integer perPage,
      String sort,
      String q,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/receipts"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (fields != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fields", fields));
    }

    if (fieldset != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fieldset", fieldset));
    }

    if (page != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
    }

    if (perPage != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
    }

    if (sort != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
    }

    if (q != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("q", q));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call listReceiptsValidateBeforeCall(
      Integer companyId,
      String fields,
      String fieldset,
      Integer page,
      Integer perPage,
      String sort,
      String q,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling listReceipts(Async)");
    }

    return listReceiptsCall(companyId, fields, fieldset, page, perPage, sort, q, _callback);
  }

  /**
   * List Receipts Lists the receipts.
   *
   * @param companyId The ID of the company. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param page The page to retrieve. (optional, default to 1)
   * @param perPage The size of the page. (optional, default to 5)
   * @param sort List of comma-separated fields for result sorting (minus for desc sorting).
   *     (optional)
   * @param q Query for filtering the results. (optional)
   * @return ListReceiptsResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Receipts list. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public ListReceiptsResponse listReceipts(
      Integer companyId,
      String fields,
      String fieldset,
      Integer page,
      Integer perPage,
      String sort,
      String q)
      throws ApiException {
    ApiResponse<ListReceiptsResponse> localVarResp =
        listReceiptsWithHttpInfo(companyId, fields, fieldset, page, perPage, sort, q);
    return localVarResp.getData();
  }

  /**
   * List Receipts Lists the receipts.
   *
   * @param companyId The ID of the company. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param page The page to retrieve. (optional, default to 1)
   * @param perPage The size of the page. (optional, default to 5)
   * @param sort List of comma-separated fields for result sorting (minus for desc sorting).
   *     (optional)
   * @param q Query for filtering the results. (optional)
   * @return ApiResponse&lt;ListReceiptsResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Receipts list. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<ListReceiptsResponse> listReceiptsWithHttpInfo(
      Integer companyId,
      String fields,
      String fieldset,
      Integer page,
      Integer perPage,
      String sort,
      String q)
      throws ApiException {
    okhttp3.Call localVarCall =
        listReceiptsValidateBeforeCall(companyId, fields, fieldset, page, perPage, sort, q, null);
    Type localVarReturnType = new TypeToken<ListReceiptsResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * List Receipts (asynchronously) Lists the receipts.
   *
   * @param companyId The ID of the company. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param page The page to retrieve. (optional, default to 1)
   * @param perPage The size of the page. (optional, default to 5)
   * @param sort List of comma-separated fields for result sorting (minus for desc sorting).
   *     (optional)
   * @param q Query for filtering the results. (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Receipts list. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call listReceiptsAsync(
      Integer companyId,
      String fields,
      String fieldset,
      Integer page,
      Integer perPage,
      String sort,
      String q,
      final ApiCallback<ListReceiptsResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        listReceiptsValidateBeforeCall(
            companyId, fields, fieldset, page, perPage, sort, q, _callback);
    Type localVarReturnType = new TypeToken<ListReceiptsResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for modifyReceipt
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param modifyReceiptRequest Modified receipt. (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Modified receipt. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyReceiptCall(
      Integer companyId,
      Integer documentId,
      ModifyReceiptRequest modifyReceiptRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = modifyReceiptRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/receipts/{document_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call modifyReceiptValidateBeforeCall(
      Integer companyId,
      Integer documentId,
      ModifyReceiptRequest modifyReceiptRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling modifyReceipt(Async)");
    }

    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(
          "Missing the required parameter 'documentId' when calling modifyReceipt(Async)");
    }

    return modifyReceiptCall(companyId, documentId, modifyReceiptRequest, _callback);
  }

  /**
   * Modify Receipt Modifies the specified receipt.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param modifyReceiptRequest Modified receipt. (optional)
   * @return ModifyReceiptResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Modified receipt. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ModifyReceiptResponse modifyReceipt(
      Integer companyId, Integer documentId, ModifyReceiptRequest modifyReceiptRequest)
      throws ApiException {
    ApiResponse<ModifyReceiptResponse> localVarResp =
        modifyReceiptWithHttpInfo(companyId, documentId, modifyReceiptRequest);
    return localVarResp.getData();
  }

  /**
   * Modify Receipt Modifies the specified receipt.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param modifyReceiptRequest Modified receipt. (optional)
   * @return ApiResponse&lt;ModifyReceiptResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Modified receipt. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<ModifyReceiptResponse> modifyReceiptWithHttpInfo(
      Integer companyId, Integer documentId, ModifyReceiptRequest modifyReceiptRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        modifyReceiptValidateBeforeCall(companyId, documentId, modifyReceiptRequest, null);
    Type localVarReturnType = new TypeToken<ModifyReceiptResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Modify Receipt (asynchronously) Modifies the specified receipt.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param modifyReceiptRequest Modified receipt. (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Modified receipt. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyReceiptAsync(
      Integer companyId,
      Integer documentId,
      ModifyReceiptRequest modifyReceiptRequest,
      final ApiCallback<ModifyReceiptResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        modifyReceiptValidateBeforeCall(companyId, documentId, modifyReceiptRequest, _callback);
    Type localVarReturnType = new TypeToken<ModifyReceiptResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
}
