/*
 * Fatture in Cloud API v2 - API Reference
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.1.3
 * Contact: info@fattureincloud.it
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package it.fattureincloud.sdk.api;

import com.google.gson.reflect.TypeToken;
import it.fattureincloud.sdk.ApiCallback;
import it.fattureincloud.sdk.ApiClient;
import it.fattureincloud.sdk.ApiException;
import it.fattureincloud.sdk.ApiResponse;
import it.fattureincloud.sdk.Configuration;
import it.fattureincloud.sdk.Pair;
import it.fattureincloud.sdk.model.CreateArchiveDocumentRequest;
import it.fattureincloud.sdk.model.CreateArchiveDocumentResponse;
import it.fattureincloud.sdk.model.GetArchiveDocumentResponse;
import it.fattureincloud.sdk.model.ListArchiveDocumentsResponse;
import it.fattureincloud.sdk.model.ModifyArchiveDocumentRequest;
import it.fattureincloud.sdk.model.ModifyArchiveDocumentResponse;
import it.fattureincloud.sdk.model.UploadArchiveAttachmentResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArchiveApi {
  private ApiClient localVarApiClient;
  private int localHostIndex;
  private String localCustomBaseUrl;

  public ArchiveApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ArchiveApi(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return localVarApiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public int getHostIndex() {
    return localHostIndex;
  }

  public void setHostIndex(int hostIndex) {
    this.localHostIndex = hostIndex;
  }

  public String getCustomBaseUrl() {
    return localCustomBaseUrl;
  }

  public void setCustomBaseUrl(String customBaseUrl) {
    this.localCustomBaseUrl = customBaseUrl;
  }

  /**
   * Build call for createArchiveDocument
   *
   * @param companyId The ID of the company. (required)
   * @param createArchiveDocumentRequest The Archive Document. (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> The Archive Document. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createArchiveDocumentCall(
      Integer companyId,
      CreateArchiveDocumentRequest createArchiveDocumentRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = createArchiveDocumentRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/archive"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call createArchiveDocumentValidateBeforeCall(
      Integer companyId,
      CreateArchiveDocumentRequest createArchiveDocumentRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling createArchiveDocument(Async)");
    }

    return createArchiveDocumentCall(companyId, createArchiveDocumentRequest, _callback);
  }

  /**
   * Create Archive Document Creates a new archive document.
   *
   * @param companyId The ID of the company. (required)
   * @param createArchiveDocumentRequest The Archive Document. (optional)
   * @return CreateArchiveDocumentResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> The Archive Document. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public CreateArchiveDocumentResponse createArchiveDocument(
      Integer companyId, CreateArchiveDocumentRequest createArchiveDocumentRequest)
      throws ApiException {
    ApiResponse<CreateArchiveDocumentResponse> localVarResp =
        createArchiveDocumentWithHttpInfo(companyId, createArchiveDocumentRequest);
    return localVarResp.getData();
  }

  /**
   * Create Archive Document Creates a new archive document.
   *
   * @param companyId The ID of the company. (required)
   * @param createArchiveDocumentRequest The Archive Document. (optional)
   * @return ApiResponse&lt;CreateArchiveDocumentResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> The Archive Document. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<CreateArchiveDocumentResponse> createArchiveDocumentWithHttpInfo(
      Integer companyId, CreateArchiveDocumentRequest createArchiveDocumentRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        createArchiveDocumentValidateBeforeCall(companyId, createArchiveDocumentRequest, null);
    Type localVarReturnType = new TypeToken<CreateArchiveDocumentResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Create Archive Document (asynchronously) Creates a new archive document.
   *
   * @param companyId The ID of the company. (required)
   * @param createArchiveDocumentRequest The Archive Document. (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> The Archive Document. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call createArchiveDocumentAsync(
      Integer companyId,
      CreateArchiveDocumentRequest createArchiveDocumentRequest,
      final ApiCallback<CreateArchiveDocumentResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        createArchiveDocumentValidateBeforeCall(companyId, createArchiveDocumentRequest, _callback);
    Type localVarReturnType = new TypeToken<CreateArchiveDocumentResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for deleteArchiveDocument
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document removed. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deleteArchiveDocumentCall(
      Integer companyId, Integer documentId, final ApiCallback _callback) throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/archive/{document_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call deleteArchiveDocumentValidateBeforeCall(
      Integer companyId, Integer documentId, final ApiCallback _callback) throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling deleteArchiveDocument(Async)");
    }

    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(
          "Missing the required parameter 'documentId' when calling deleteArchiveDocument(Async)");
    }

    return deleteArchiveDocumentCall(companyId, documentId, _callback);
  }

  /**
   * Delete Archive Document Deletes the specified archive document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document removed. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public void deleteArchiveDocument(Integer companyId, Integer documentId) throws ApiException {
    deleteArchiveDocumentWithHttpInfo(companyId, documentId);
  }

  /**
   * Delete Archive Document Deletes the specified archive document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document removed. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<Void> deleteArchiveDocumentWithHttpInfo(Integer companyId, Integer documentId)
      throws ApiException {
    okhttp3.Call localVarCall =
        deleteArchiveDocumentValidateBeforeCall(companyId, documentId, null);
    return localVarApiClient.execute(localVarCall);
  }

  /**
   * Delete Archive Document (asynchronously) Deletes the specified archive document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Document removed. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call deleteArchiveDocumentAsync(
      Integer companyId, Integer documentId, final ApiCallback<Void> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        deleteArchiveDocumentValidateBeforeCall(companyId, documentId, _callback);
    localVarApiClient.executeAsync(localVarCall, _callback);
    return localVarCall;
  }
  /**
   * Build call for getArchiveDocument
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Archive Document Details </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getArchiveDocumentCall(
      Integer companyId,
      Integer documentId,
      String fields,
      String fieldset,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/archive/{document_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (fields != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fields", fields));
    }

    if (fieldset != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fieldset", fieldset));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getArchiveDocumentValidateBeforeCall(
      Integer companyId,
      Integer documentId,
      String fields,
      String fieldset,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling getArchiveDocument(Async)");
    }

    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(
          "Missing the required parameter 'documentId' when calling getArchiveDocument(Async)");
    }

    return getArchiveDocumentCall(companyId, documentId, fields, fieldset, _callback);
  }

  /**
   * Get Archive Document Gets the specified archive document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @return GetArchiveDocumentResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Archive Document Details </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public GetArchiveDocumentResponse getArchiveDocument(
      Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
    ApiResponse<GetArchiveDocumentResponse> localVarResp =
        getArchiveDocumentWithHttpInfo(companyId, documentId, fields, fieldset);
    return localVarResp.getData();
  }

  /**
   * Get Archive Document Gets the specified archive document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @return ApiResponse&lt;GetArchiveDocumentResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Archive Document Details </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<GetArchiveDocumentResponse> getArchiveDocumentWithHttpInfo(
      Integer companyId, Integer documentId, String fields, String fieldset) throws ApiException {
    okhttp3.Call localVarCall =
        getArchiveDocumentValidateBeforeCall(companyId, documentId, fields, fieldset, null);
    Type localVarReturnType = new TypeToken<GetArchiveDocumentResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get Archive Document (asynchronously) Gets the specified archive document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Archive Document Details </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call getArchiveDocumentAsync(
      Integer companyId,
      Integer documentId,
      String fields,
      String fieldset,
      final ApiCallback<GetArchiveDocumentResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        getArchiveDocumentValidateBeforeCall(companyId, documentId, fields, fieldset, _callback);
    Type localVarReturnType = new TypeToken<GetArchiveDocumentResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for listArchiveDocuments
   *
   * @param companyId The ID of the company. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param sort List of comma-separated fields for result sorting (minus for desc sorting).
   *     (optional)
   * @param page The page to retrieve. (optional, default to 1)
   * @param perPage The size of the page. (optional, default to 5)
   * @param q Query for filtering the results. (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Results list. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call listArchiveDocumentsCall(
      Integer companyId,
      String fields,
      String fieldset,
      String sort,
      Integer page,
      Integer perPage,
      String q,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/archive"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (fields != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fields", fields));
    }

    if (fieldset != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("fieldset", fieldset));
    }

    if (sort != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
    }

    if (page != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
    }

    if (perPage != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
    }

    if (q != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("q", q));
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call listArchiveDocumentsValidateBeforeCall(
      Integer companyId,
      String fields,
      String fieldset,
      String sort,
      Integer page,
      Integer perPage,
      String q,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling listArchiveDocuments(Async)");
    }

    return listArchiveDocumentsCall(companyId, fields, fieldset, sort, page, perPage, q, _callback);
  }

  /**
   * List Archive Documents Lists the archive documents.
   *
   * @param companyId The ID of the company. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param sort List of comma-separated fields for result sorting (minus for desc sorting).
   *     (optional)
   * @param page The page to retrieve. (optional, default to 1)
   * @param perPage The size of the page. (optional, default to 5)
   * @param q Query for filtering the results. (optional)
   * @return ListArchiveDocumentsResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Results list. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ListArchiveDocumentsResponse listArchiveDocuments(
      Integer companyId,
      String fields,
      String fieldset,
      String sort,
      Integer page,
      Integer perPage,
      String q)
      throws ApiException {
    ApiResponse<ListArchiveDocumentsResponse> localVarResp =
        listArchiveDocumentsWithHttpInfo(companyId, fields, fieldset, sort, page, perPage, q);
    return localVarResp.getData();
  }

  /**
   * List Archive Documents Lists the archive documents.
   *
   * @param companyId The ID of the company. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param sort List of comma-separated fields for result sorting (minus for desc sorting).
   *     (optional)
   * @param page The page to retrieve. (optional, default to 1)
   * @param perPage The size of the page. (optional, default to 5)
   * @param q Query for filtering the results. (optional)
   * @return ApiResponse&lt;ListArchiveDocumentsResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Results list. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<ListArchiveDocumentsResponse> listArchiveDocumentsWithHttpInfo(
      Integer companyId,
      String fields,
      String fieldset,
      String sort,
      Integer page,
      Integer perPage,
      String q)
      throws ApiException {
    okhttp3.Call localVarCall =
        listArchiveDocumentsValidateBeforeCall(
            companyId, fields, fieldset, sort, page, perPage, q, null);
    Type localVarReturnType = new TypeToken<ListArchiveDocumentsResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * List Archive Documents (asynchronously) Lists the archive documents.
   *
   * @param companyId The ID of the company. (required)
   * @param fields List of comma-separated fields. (optional)
   * @param fieldset Name of the fieldset. (optional)
   * @param sort List of comma-separated fields for result sorting (minus for desc sorting).
   *     (optional)
   * @param page The page to retrieve. (optional, default to 1)
   * @param perPage The size of the page. (optional, default to 5)
   * @param q Query for filtering the results. (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Results list. </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call listArchiveDocumentsAsync(
      Integer companyId,
      String fields,
      String fieldset,
      String sort,
      Integer page,
      Integer perPage,
      String q,
      final ApiCallback<ListArchiveDocumentsResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        listArchiveDocumentsValidateBeforeCall(
            companyId, fields, fieldset, sort, page, perPage, q, _callback);
    Type localVarReturnType = new TypeToken<ListArchiveDocumentsResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for modifyArchiveDocument
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param modifyArchiveDocumentRequest Modified Archive Document (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> The modified Archived Document </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyArchiveDocumentCall(
      Integer companyId,
      Integer documentId,
      ModifyArchiveDocumentRequest modifyArchiveDocumentRequest,
      final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = modifyArchiveDocumentRequest;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/archive/{document_id}"
            .replace("{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()))
            .replace(
                "{" + "document_id" + "}", localVarApiClient.escapeString(documentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call modifyArchiveDocumentValidateBeforeCall(
      Integer companyId,
      Integer documentId,
      ModifyArchiveDocumentRequest modifyArchiveDocumentRequest,
      final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling modifyArchiveDocument(Async)");
    }

    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(
          "Missing the required parameter 'documentId' when calling modifyArchiveDocument(Async)");
    }

    return modifyArchiveDocumentCall(
        companyId, documentId, modifyArchiveDocumentRequest, _callback);
  }

  /**
   * Modify Archive Document Modifies the specified archive document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param modifyArchiveDocumentRequest Modified Archive Document (optional)
   * @return ModifyArchiveDocumentResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> The modified Archived Document </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ModifyArchiveDocumentResponse modifyArchiveDocument(
      Integer companyId,
      Integer documentId,
      ModifyArchiveDocumentRequest modifyArchiveDocumentRequest)
      throws ApiException {
    ApiResponse<ModifyArchiveDocumentResponse> localVarResp =
        modifyArchiveDocumentWithHttpInfo(companyId, documentId, modifyArchiveDocumentRequest);
    return localVarResp.getData();
  }

  /**
   * Modify Archive Document Modifies the specified archive document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param modifyArchiveDocumentRequest Modified Archive Document (optional)
   * @return ApiResponse&lt;ModifyArchiveDocumentResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> The modified Archived Document </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<ModifyArchiveDocumentResponse> modifyArchiveDocumentWithHttpInfo(
      Integer companyId,
      Integer documentId,
      ModifyArchiveDocumentRequest modifyArchiveDocumentRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        modifyArchiveDocumentValidateBeforeCall(
            companyId, documentId, modifyArchiveDocumentRequest, null);
    Type localVarReturnType = new TypeToken<ModifyArchiveDocumentResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Modify Archive Document (asynchronously) Modifies the specified archive document.
   *
   * @param companyId The ID of the company. (required)
   * @param documentId The ID of the document. (required)
   * @param modifyArchiveDocumentRequest Modified Archive Document (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> The modified Archived Document </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call modifyArchiveDocumentAsync(
      Integer companyId,
      Integer documentId,
      ModifyArchiveDocumentRequest modifyArchiveDocumentRequest,
      final ApiCallback<ModifyArchiveDocumentResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        modifyArchiveDocumentValidateBeforeCall(
            companyId, documentId, modifyArchiveDocumentRequest, _callback);
    Type localVarReturnType = new TypeToken<ModifyArchiveDocumentResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for uploadArchiveDocumentAttachment
   *
   * @param companyId The ID of the company. (required)
   * @param filename Attachment file name (optional)
   * @param attachment Attachment file [.png, .jpg, .gif, .pdf, .zip, .xls, .xlsx, .doc, .docx]
   *     (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call uploadArchiveDocumentAttachmentCall(
      Integer companyId, String filename, File attachment, final ApiCallback _callback)
      throws ApiException {
    String basePath = null;
    // Operation Servers
    String[] localBasePaths = new String[] {};

    // Determine Base Path to Use
    if (localCustomBaseUrl != null) {
      basePath = localCustomBaseUrl;
    } else if (localBasePaths.length > 0) {
      basePath = localBasePaths[localHostIndex];
    } else {
      basePath = null;
    }

    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/c/{company_id}/archive/attachment"
            .replace(
                "{" + "company_id" + "}", localVarApiClient.escapeString(companyId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    if (filename != null) {
      localVarFormParams.put("filename", filename);
    }

    if (attachment != null) {
      localVarFormParams.put("attachment", attachment);
    }

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"multipart/form-data"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    if (localVarContentType != null) {
      localVarHeaderParams.put("Content-Type", localVarContentType);
    }

    String[] localVarAuthNames = new String[] {"OAuth2AuthenticationCodeFlow"};
    return localVarApiClient.buildCall(
        basePath,
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call uploadArchiveDocumentAttachmentValidateBeforeCall(
      Integer companyId, String filename, File attachment, final ApiCallback _callback)
      throws ApiException {
    // verify the required parameter 'companyId' is set
    if (companyId == null) {
      throw new ApiException(
          "Missing the required parameter 'companyId' when calling uploadArchiveDocumentAttachment(Async)");
    }

    return uploadArchiveDocumentAttachmentCall(companyId, filename, attachment, _callback);
  }

  /**
   * Upload Archive Document Attachment Uploads an attachment destined to an archive document. The
   * actual association between the document and the attachment must be implemented separately,
   * using the returned token.
   *
   * @param companyId The ID of the company. (required)
   * @param filename Attachment file name (optional)
   * @param attachment Attachment file [.png, .jpg, .gif, .pdf, .zip, .xls, .xlsx, .doc, .docx]
   *     (optional)
   * @return UploadArchiveAttachmentResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public UploadArchiveAttachmentResponse uploadArchiveDocumentAttachment(
      Integer companyId, String filename, File attachment) throws ApiException {
    ApiResponse<UploadArchiveAttachmentResponse> localVarResp =
        uploadArchiveDocumentAttachmentWithHttpInfo(companyId, filename, attachment);
    return localVarResp.getData();
  }

  /**
   * Upload Archive Document Attachment Uploads an attachment destined to an archive document. The
   * actual association between the document and the attachment must be implemented separately,
   * using the returned token.
   *
   * @param companyId The ID of the company. (required)
   * @param filename Attachment file name (optional)
   * @param attachment Attachment file [.png, .jpg, .gif, .pdf, .zip, .xls, .xlsx, .doc, .docx]
   *     (optional)
   * @return ApiResponse&lt;UploadArchiveAttachmentResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public ApiResponse<UploadArchiveAttachmentResponse> uploadArchiveDocumentAttachmentWithHttpInfo(
      Integer companyId, String filename, File attachment) throws ApiException {
    okhttp3.Call localVarCall =
        uploadArchiveDocumentAttachmentValidateBeforeCall(companyId, filename, attachment, null);
    Type localVarReturnType = new TypeToken<UploadArchiveAttachmentResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Upload Archive Document Attachment (asynchronously) Uploads an attachment destined to an
   * archive document. The actual association between the document and the attachment must be
   * implemented separately, using the returned token.
   *
   * @param companyId The ID of the company. (required)
   * @param filename Attachment file name (optional)
   * @param attachment Attachment file [.png, .jpg, .gif, .pdf, .zip, .xls, .xlsx, .doc, .docx]
   *     (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @http.response.details
   *     <table border="1">
   * <caption>Response Details</caption>
   * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   * <tr><td> 200 </td><td> Example response </td><td>  -  </td></tr>
   * <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
   * <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
   * </table>
   */
  public okhttp3.Call uploadArchiveDocumentAttachmentAsync(
      Integer companyId,
      String filename,
      File attachment,
      final ApiCallback<UploadArchiveAttachmentResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        uploadArchiveDocumentAttachmentValidateBeforeCall(
            companyId, filename, attachment, _callback);
    Type localVarReturnType = new TypeToken<UploadArchiveAttachmentResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
}
