/*
 * Decompiled with CFR 0.152.
 */
package ir.sohreco.androidfilechooser;

import android.content.Context;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import ir.sohreco.androidfilechooser.Item;
import ir.sohreco.androidfilechooser.R;
import java.util.List;

class ItemHolder
extends RecyclerView.ViewHolder {
    private ImageView ivItemIcon;
    private TextView tvItemName;
    private CheckBox cbFile;
    private OnItemClickListener itemClickListener;

    ItemHolder(View itemView, OnItemClickListener itemClickListener, @ColorRes int textColorResId) {
        super(itemView);
        this.itemClickListener = itemClickListener;
        this.ivItemIcon = (ImageView)itemView.findViewById(R.id.item_icon_imageview);
        this.tvItemName = (TextView)itemView.findViewById(R.id.item_name_textview);
        this.cbFile = (CheckBox)itemView.findViewById(R.id.file_checkbox);
        if (textColorResId != 0) {
            this.tvItemName.setTextColor(ContextCompat.getColor((Context)itemView.getContext(), (int)textColorResId));
        }
    }

    void bind(final Item item) {
        this.cbFile.setVisibility(8);
        this.tvItemName.setText((CharSequence)item.getName());
        this.ivItemIcon.setImageDrawable(item.getIcon());
        this.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ItemHolder.this.itemClickListener.onItemClick(item);
            }
        });
    }

    void bind(final Item item, final List<Item> selectedItems) {
        this.cbFile.setVisibility(0);
        this.tvItemName.setText((CharSequence)item.getName());
        this.ivItemIcon.setImageDrawable(item.getIcon());
        this.cbFile.setOnCheckedChangeListener(null);
        this.cbFile.setChecked(selectedItems.contains(item));
        this.cbFile.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                if (b) {
                    selectedItems.add(item);
                } else {
                    selectedItems.remove(item);
                }
            }
        });
        this.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ItemHolder.this.cbFile.performClick();
            }
        });
    }

    static interface OnItemClickListener {
        public void onItemClick(Item var1);
    }
}

