/*
 * Decompiled with CFR 0.152.
 */
package ir.sohreco.androidfilechooser;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import ir.sohreco.androidfilechooser.Item;
import ir.sohreco.androidfilechooser.R;

class ItemHolder
extends RecyclerView.ViewHolder {
    private ImageView ivItemIcon;
    private TextView tvItemName;
    private OnItemClickListener itemClickListener;

    ItemHolder(View itemView, OnItemClickListener itemClickListener) {
        super(itemView);
        this.itemClickListener = itemClickListener;
        this.ivItemIcon = (ImageView)itemView.findViewById(R.id.item_icon_imageview);
        this.tvItemName = (TextView)itemView.findViewById(R.id.item_name_textview);
    }

    void bind(final Item item) {
        this.tvItemName.setText((CharSequence)item.getName());
        this.ivItemIcon.setImageDrawable(item.getIcon());
        this.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ItemHolder.this.itemClickListener.onItemClick(item);
            }
        });
    }

    static interface OnItemClickListener {
        public void onItemClick(Item var1);
    }
}

