/*
 * Decompiled with CFR 0.152.
 */
package ir.sohreco.androidfilechooser;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatDialogFragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import ir.sohreco.androidfilechooser.ExternalStorageNotAvailableException;
import ir.sohreco.androidfilechooser.Item;
import ir.sohreco.androidfilechooser.ItemHolder;
import ir.sohreco.androidfilechooser.ItemsAdapter;
import ir.sohreco.androidfilechooser.R;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

public class FileChooserDialog
extends AppCompatDialogFragment
implements ItemHolder.OnItemClickListener,
View.OnClickListener {
    private static final String KEY_CHOOSER_TYPE = "chooserType";
    private static final String KEY_CHOOSER_LISTENER = "chooserListener";
    private static final String KEY_TITLE = "title";
    private static final String KEY_FILE_FORMATS = "fileFormats";
    private static final String KEY_INITIAL_DIRECTORY = "initialDirectory";
    private static final String KEY_SELECT_DIRECTORY_BUTTON_TEXT = "selectDirectoryButtonText";
    private static final String KEY_SELECT_DIRECTORY_BUTTON_TEXT_SIZE = "selectDirectoryButtonTextSize";
    private static final String KEY_SELECT_DIRECTORY_BUTTON_TEXT_COLOR_ID = "selectDirectoryButtonTextColorId";
    private static final String KEY_SELECT_DIRECTORY_BUTTON_BACKGROUND_ID = "selectDirectoryButtonBackgroundId";
    private static final String KEY_FILE_ICON_ID = "fileIconId";
    private static final String KEY_DIRECTORY_ICON_ID = "directoryIconId";
    private static final String KEY_PREVIOUS_DIRECTORY_BUTTON_ICON_ID = "previousDirectoryButtonIconId";
    private Button btnPrevDirectory;
    private Button btnSelectDirectory;
    private RecyclerView rvItems;
    private TextView tvCurrentDirectory;
    private ChooserType chooserType;
    private ChooserListener chooserListener;
    private ItemsAdapter itemsAdapter;
    private String[] fileFormats;
    private String currentDirectoryPath;
    private String title;
    private String initialDirectory;
    private String selectDirectoryButtonText;
    @DrawableRes
    private int directoryIconId;
    @DrawableRes
    private int fileIconId;
    @DrawableRes
    private int previousDirectoryButtonIconId;
    @DrawableRes
    private int selectDirectoryButtonBackgroundId;
    @ColorRes
    private int selectDirectoryButtonTextColorId;
    private float selectDirectoryButtonTextSize;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getGivenArguments();
        if (this.title == null) {
            this.setStyle(1, 0);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_chooser, container, false);
        this.findViews(view);
        this.setListeners();
        this.getDialog().setTitle((CharSequence)this.title);
        if (this.chooserType == ChooserType.DIRECTORY_CHOOSER) {
            this.btnSelectDirectory.setVisibility(0);
            this.btnSelectDirectory.setText((CharSequence)this.selectDirectoryButtonText);
            if (this.selectDirectoryButtonBackgroundId != 0) {
                this.btnSelectDirectory.setBackgroundResource(this.selectDirectoryButtonBackgroundId);
            }
            if (this.selectDirectoryButtonTextColorId != 0) {
                this.btnSelectDirectory.setTextColor(this.getResources().getColor(this.selectDirectoryButtonTextColorId));
            }
            if (this.selectDirectoryButtonTextSize > 0.0f) {
                this.btnSelectDirectory.setTextSize(this.selectDirectoryButtonTextSize);
            }
        }
        this.btnPrevDirectory.setBackgroundResource(this.previousDirectoryButtonIconId);
        this.itemsAdapter = new ItemsAdapter(this);
        this.rvItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.rvItems.setAdapter((RecyclerView.Adapter)this.itemsAdapter);
        this.loadItems(this.initialDirectory != null ? this.initialDirectory : Environment.getExternalStorageDirectory().getPath());
        return view;
    }

    @Override
    public void onItemClick(Item item) {
        if (item.isDirectory()) {
            this.loadItems(item.getPath());
        } else {
            this.chooserListener.onSelect(item.getPath());
            this.dismiss();
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.previous_dir_imagebutton) {
            File parent = new File(this.currentDirectoryPath).getParentFile();
            if (parent != null && parent.canRead()) {
                this.loadItems(parent.getPath());
            }
        } else if (id2 == R.id.select_dir_button) {
            this.chooserListener.onSelect(this.currentDirectoryPath);
            this.dismiss();
        }
    }

    private void loadItems(String path) {
        this.currentDirectoryPath = path;
        String currentDir = path.substring(path.lastIndexOf(File.separator) + 1);
        this.tvCurrentDirectory.setText((CharSequence)currentDir);
        File[] files = new File(path).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.canRead()) {
                    if (FileChooserDialog.this.chooserType == ChooserType.FILE_CHOOSER && file.isFile()) {
                        if (FileChooserDialog.this.fileFormats != null && FileChooserDialog.this.fileFormats.length > 0) {
                            for (String fileFormat : FileChooserDialog.this.fileFormats) {
                                if (!file.getName().endsWith(fileFormat)) continue;
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }
                    return file.isDirectory();
                }
                return false;
            }
        });
        ArrayList<Item> items = new ArrayList<Item>();
        for (File f : files) {
            int drawableId = f.isFile() ? this.fileIconId : this.directoryIconId;
            Drawable drawable2 = ContextCompat.getDrawable((Context)this.getActivity().getApplicationContext(), (int)drawableId);
            items.add(new Item(f.getPath(), drawable2));
        }
        Collections.sort(items);
        this.itemsAdapter.setItems(items);
    }

    private void getGivenArguments() {
        Bundle args = this.getArguments();
        this.chooserType = (ChooserType)((Object)args.getSerializable(KEY_CHOOSER_TYPE));
        this.chooserListener = (ChooserListener)args.getSerializable(KEY_CHOOSER_LISTENER);
        this.title = args.getString(KEY_TITLE);
        this.fileFormats = args.getStringArray(KEY_FILE_FORMATS);
        this.initialDirectory = args.getString(KEY_INITIAL_DIRECTORY);
        this.selectDirectoryButtonText = args.getString(KEY_SELECT_DIRECTORY_BUTTON_TEXT);
        this.selectDirectoryButtonTextSize = args.getFloat(KEY_SELECT_DIRECTORY_BUTTON_TEXT_SIZE);
        this.selectDirectoryButtonTextColorId = args.getInt(KEY_SELECT_DIRECTORY_BUTTON_TEXT_COLOR_ID);
        this.selectDirectoryButtonBackgroundId = args.getInt(KEY_SELECT_DIRECTORY_BUTTON_BACKGROUND_ID);
        this.fileIconId = args.getInt(KEY_FILE_ICON_ID);
        this.directoryIconId = args.getInt(KEY_DIRECTORY_ICON_ID);
        this.previousDirectoryButtonIconId = args.getInt(KEY_PREVIOUS_DIRECTORY_BUTTON_ICON_ID);
    }

    private void setListeners() {
        this.btnPrevDirectory.setOnClickListener((View.OnClickListener)this);
        this.btnSelectDirectory.setOnClickListener((View.OnClickListener)this);
    }

    private void findViews(View v) {
        this.rvItems = (RecyclerView)v.findViewById(R.id.items_recyclerview);
        this.btnPrevDirectory = (Button)v.findViewById(R.id.previous_dir_imagebutton);
        this.btnSelectDirectory = (Button)v.findViewById(R.id.select_dir_button);
        this.tvCurrentDirectory = (TextView)v.findViewById(R.id.current_dir_textview);
    }

    public static class Builder {
        private ChooserType chooserType;
        private ChooserListener chooserListener;
        private String[] fileFormats;
        private String title;
        private String selectDirectoryButtonText;
        private String initialDirectory;
        @DrawableRes
        private int fileIconId = R.drawable.ic_file;
        @DrawableRes
        private int directoryIconId = R.drawable.ic_directory;
        @DrawableRes
        private int previousDirectoryButtonIcon = R.drawable.ic_prev_dir;
        @DrawableRes
        private int selectDirectoryButtonBackgroundId;
        @ColorRes
        private int selectDirectoryButtonTextColorId;
        private float selectDirectoryButtonTextSize;

        public Builder(ChooserType chooserType, ChooserListener chooserListener) {
            this.chooserType = chooserType;
            this.chooserListener = chooserListener;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setFileFormats(String[] fileFormats) {
            this.fileFormats = fileFormats;
            return this;
        }

        public Builder setInitialDirectory(File initialDirectory) {
            if (initialDirectory == null) {
                throw new NullPointerException("initialDirectory can't be null.");
            }
            if (!initialDirectory.exists()) {
                throw new IllegalArgumentException(initialDirectory.getPath() + " Does not exist.");
            }
            if (!initialDirectory.isDirectory()) {
                throw new IllegalArgumentException(initialDirectory.getPath() + " Is not a directory.");
            }
            if (!initialDirectory.canRead()) {
                throw new IllegalArgumentException("Can't access " + initialDirectory.getPath());
            }
            this.initialDirectory = initialDirectory.getPath();
            return this;
        }

        public Builder setSelectDirectoryButtonText(String text) {
            this.selectDirectoryButtonText = text;
            return this;
        }

        public Builder setSelectDirectoryButtonTextSize(float textSize) {
            this.selectDirectoryButtonTextSize = textSize;
            return this;
        }

        public Builder setSelectDirectoryButtonTextColor(@ColorRes int colorId) {
            this.selectDirectoryButtonTextColorId = colorId;
            return this;
        }

        public Builder setSelectDirectoryButtonBackground(@DrawableRes int backgroundId) {
            this.selectDirectoryButtonBackgroundId = backgroundId;
            return this;
        }

        public Builder setFileIcon(@DrawableRes int iconId) {
            this.fileIconId = iconId;
            return this;
        }

        public Builder setDirectoryIcon(@DrawableRes int iconId) {
            this.directoryIconId = iconId;
            return this;
        }

        public Builder setPreviousDirectoryButtonIcon(@DrawableRes int iconId) {
            this.previousDirectoryButtonIcon = iconId;
            return this;
        }

        public FileChooserDialog build() throws ExternalStorageNotAvailableException {
            boolean externalStorageAvailable;
            String externalStorageState = Environment.getExternalStorageState();
            boolean bl = externalStorageAvailable = externalStorageState.equals("mounted") || externalStorageState.equals("mounted_ro");
            if (!externalStorageAvailable) {
                throw new ExternalStorageNotAvailableException();
            }
            FileChooserDialog fragment = new FileChooserDialog();
            Bundle args = new Bundle();
            args.putSerializable(FileChooserDialog.KEY_CHOOSER_TYPE, (Serializable)((Object)this.chooserType));
            args.putSerializable(FileChooserDialog.KEY_CHOOSER_LISTENER, (Serializable)this.chooserListener);
            args.putString(FileChooserDialog.KEY_TITLE, this.title);
            args.putStringArray(FileChooserDialog.KEY_FILE_FORMATS, this.fileFormats);
            args.putString(FileChooserDialog.KEY_INITIAL_DIRECTORY, this.initialDirectory);
            args.putString(FileChooserDialog.KEY_SELECT_DIRECTORY_BUTTON_TEXT, this.selectDirectoryButtonText);
            args.putFloat(FileChooserDialog.KEY_SELECT_DIRECTORY_BUTTON_TEXT_SIZE, this.selectDirectoryButtonTextSize);
            args.putInt(FileChooserDialog.KEY_SELECT_DIRECTORY_BUTTON_TEXT_COLOR_ID, this.selectDirectoryButtonTextColorId);
            args.putInt(FileChooserDialog.KEY_SELECT_DIRECTORY_BUTTON_BACKGROUND_ID, this.selectDirectoryButtonBackgroundId);
            args.putInt(FileChooserDialog.KEY_FILE_ICON_ID, this.fileIconId);
            args.putInt(FileChooserDialog.KEY_DIRECTORY_ICON_ID, this.directoryIconId);
            args.putInt(FileChooserDialog.KEY_PREVIOUS_DIRECTORY_BUTTON_ICON_ID, this.previousDirectoryButtonIcon);
            fragment.setArguments(args);
            return fragment;
        }
    }

    public static enum ChooserType {
        FILE_CHOOSER,
        DIRECTORY_CHOOSER;

    }

    public static interface ChooserListener
    extends Serializable {
        public void onSelect(String var1);
    }
}

