/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres.embedded;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

final class ProcessOutputLogger
implements Runnable {
    private final Logger logger;
    private final Process process;
    private final BufferedReader reader;

    private ProcessOutputLogger(Logger logger, Process process) {
        this.logger = logger;
        this.process = process;
        this.reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (this.process.isAlive()) {
                try {
                    this.logger.info(this.reader.readLine());
                }
                catch (IOException e) {
                    this.logger.error("while reading output", (Throwable)e);
                    try {
                        this.reader.close();
                        return;
                    }
                    catch (IOException e2) {
                        this.logger.error("caught i/o exception closing reader", (Throwable)e2);
                    }
                    return;
                }
            }
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                this.logger.error("caught i/o exception closing reader", (Throwable)e);
            }
        }
    }

    static void logOutput(Logger logger, Process process, String processName) {
        String threadName = StringUtils.isNotBlank((CharSequence)processName) ? processName + "@" + process.hashCode() : process.toString();
        Thread t = new Thread(new ProcessOutputLogger(logger, process));
        t.setName(threadName);
        t.start();
    }
}

